/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.item.PortableTeleporterContainer;
import mekanism.common.item.ItemEnergized;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.security.IOwnerItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemPortableTeleporter
extends ItemEnergized
implements IOwnerItem {
    public ItemPortableTeleporter(Item.Properties properties) {
        super(MekanismConfig.gear.portableTeleporterChargeRate, MekanismConfig.gear.portableTeleporterMaxEnergy, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(OwnerDisplay.of((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.getOwnerUUID(stack)).getTextComponent());
        if (this.getFrequency(stack) != null) {
            tooltip.add(MekanismLang.FREQUENCY.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, this.getFrequency((ItemStack)stack).name}));
            tooltip.add(MekanismLang.MODE.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, !this.getFrequency((ItemStack)stack).publicFreq ? MekanismLang.PRIVATE : MekanismLang.PUBLIC}));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (this.getOwnerUUID(stack) == null) {
                this.setOwnerUUID(stack, player.func_110124_au());
                Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate(player.func_110124_au(), null));
                player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.NOW_OWN.translateColored(EnumColor.GRAY, new Object[0])));
            } else if (SecurityUtils.canAccess(player, stack)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(stack.func_200301_q(), (i, inv, p) -> new PortableTeleporterContainer(i, inv, hand, stack)), buf -> {
                    buf.func_179249_a((Enum)hand);
                    buf.func_150788_a(stack);
                });
            } else {
                SecurityUtils.displayNoAccess(player);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public void setOwnerUUID(@Nonnull ItemStack stack, @Nullable UUID owner) {
        this.setFrequency(stack, null);
        if (owner == null) {
            ItemDataUtils.removeData(stack, "owner");
        } else {
            ItemDataUtils.setUUID(stack, "owner", owner);
        }
    }

    public Frequency.Identity getFrequency(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "frequency", 10)) {
            return Frequency.Identity.load(ItemDataUtils.getCompound(stack, "frequency"));
        }
        return null;
    }

    public void setFrequency(ItemStack stack, Frequency frequency) {
        if (frequency == null) {
            ItemDataUtils.removeData(stack, "frequency");
        } else {
            ItemDataUtils.setCompound(stack, "frequency", frequency.getIdentity().serialize());
        }
    }
}

