/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.matrix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.content.matrix.MatrixEnergyContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.Direction;

public class SynchronizedMatrixData
extends SynchronizedData<SynchronizedMatrixData>
implements IMekanismStrictEnergyHandler {
    @Nonnull
    private final List<IEnergyContainer> energyContainers;
    @Nonnull
    private final MatrixEnergyContainer energyContainer;
    private FloatingLong clientLastOutput = FloatingLong.ZERO;
    private FloatingLong clientLastInput = FloatingLong.ZERO;
    private FloatingLong clientEnergy = FloatingLong.ZERO;
    private FloatingLong clientMaxTransfer = FloatingLong.ZERO;
    private FloatingLong clientMaxEnergy = FloatingLong.ZERO;
    private int clientProviders;
    private int clientCells;
    @Nonnull
    private final List<IInventorySlot> inventorySlots;
    @Nonnull
    public final EnergyInventorySlot energyInputSlot;
    @Nonnull
    public final EnergyInventorySlot energyOutputSlot;
    private final boolean remote;

    public SynchronizedMatrixData(TileEntityInductionCasing tile) {
        this.remote = tile.isRemote();
        this.energyContainer = new MatrixEnergyContainer(tile);
        this.energyContainers = Collections.singletonList(this.energyContainer);
        this.inventorySlots = new ArrayList<IInventorySlot>();
        this.energyInputSlot = EnergyInventorySlot.drain(this.energyContainer, this, 146, 20);
        this.inventorySlots.add(this.energyInputSlot);
        this.energyOutputSlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityInductionCasing)tile).func_145831_w(), this, 146, 51);
        this.inventorySlots.add(this.energyOutputSlot);
        this.energyInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.energyOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.getEnergy(), this.getStorageCap());
    }

    public void setInventoryData(@Nonnull List<IInventorySlot> toCopy) {
        for (int i = 0; i < toCopy.size(); ++i) {
            if (i >= this.inventorySlots.size()) continue;
            this.inventorySlots.get(i).deserializeNBT(toCopy.get(i).serializeNBT());
        }
    }

    public void addCell(Coord4D coord, TileEntityInductionCell cell) {
        this.energyContainer.addCell(coord, cell);
    }

    public void addProvider(Coord4D coord, TileEntityInductionProvider provider) {
        this.energyContainer.addProvider(coord, provider);
    }

    @Nonnull
    public MatrixEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    public FloatingLong getEnergy() {
        return this.remote ? this.clientEnergy : this.energyContainer.getEnergy();
    }

    public void tick() {
        this.energyContainer.tick();
    }

    public void invalidate() {
        this.energyContainer.invalidate();
    }

    public FloatingLong getStorageCap() {
        return this.remote ? this.clientMaxEnergy : this.energyContainer.getMaxEnergy();
    }

    public FloatingLong getTransferCap() {
        return this.remote ? this.clientMaxTransfer : this.energyContainer.getMaxTransfer();
    }

    public FloatingLong getLastInput() {
        return this.remote ? this.clientLastInput : this.energyContainer.getLastInput();
    }

    public FloatingLong getLastOutput() {
        return this.remote ? this.clientLastOutput : this.energyContainer.getLastOutput();
    }

    public int getCellCount() {
        return this.remote ? this.clientCells : this.energyContainer.getCells();
    }

    public int getProviderCount() {
        return this.remote ? this.clientProviders : this.energyContainer.getProviders();
    }

    public void setClientEnergy(FloatingLong cachedTotal) {
        this.clientEnergy = cachedTotal;
    }

    public void setClientMaxEnergy(FloatingLong storageCap) {
        this.clientMaxEnergy = storageCap;
    }

    public void setClientMaxTransfer(FloatingLong transferCap) {
        this.clientMaxTransfer = transferCap;
    }

    public void setClientLastInput(FloatingLong lastInput) {
        this.clientLastInput = lastInput;
    }

    public void setClientLastOutput(FloatingLong lastOutput) {
        this.clientLastOutput = lastOutput;
    }

    public void setClientCells(int cells) {
        this.clientCells = cells;
    }

    public void setClientProviders(int providers) {
        this.clientProviders = providers;
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }
}

