/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.entangloporter;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyType;
import mekanism.common.inventory.slot.EntangloporterInventorySlot;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;

public class InventoryFrequency
extends Frequency
implements IMekanismInventory,
IMekanismGasHandler,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler {
    public static final String ENTANGLOPORTER = "Entangloporter";
    public BasicFluidTank storedFluid;
    public BasicGasTank storedGas;
    private IInventorySlot storedItem;
    public IEnergyContainer storedEnergy;
    public BasicHeatCapacitor storedHeat;
    private List<IInventorySlot> inventorySlots;
    private List<IGasTank> gasTanks;
    private List<IExtendedFluidTank> fluidTanks;
    private List<IEnergyContainer> energyContainers;
    private List<IHeatCapacitor> heatCapacitors;

    public InventoryFrequency(String n, UUID uuid) {
        super(FrequencyType.INVENTORY, n, uuid);
        this.presetVariables();
    }

    public InventoryFrequency(CompoundNBT nbtTags, boolean fromUpdate) {
        super(FrequencyType.INVENTORY, nbtTags, fromUpdate);
    }

    public InventoryFrequency(PacketBuffer dataStream) {
        super(FrequencyType.INVENTORY, dataStream);
    }

    private void presetVariables() {
        this.storedFluid = BasicFluidTank.create(MekanismConfig.general.entangloporterFluidBuffer.get(), this);
        this.fluidTanks = Collections.singletonList(this.storedFluid);
        this.storedGas = BasicGasTank.create(MekanismConfig.general.entangloporterGasBuffer.get(), this);
        this.gasTanks = Collections.singletonList(this.storedGas);
        this.storedItem = EntangloporterInventorySlot.create(this);
        this.inventorySlots = Collections.singletonList(this.storedItem);
        this.storedEnergy = BasicEnergyContainer.create((FloatingLong)MekanismConfig.general.entangloporterEnergyBuffer.get(), this);
        this.energyContainers = Collections.singletonList(this.storedEnergy);
        this.storedHeat = BasicHeatCapacitor.create(1.0, 1.0, 1000.0, this);
        this.heatCapacitors = Collections.singletonList(this.storedHeat);
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_218657_a("energy", (INBT)this.storedEnergy.serializeNBT());
        nbtTags.func_218657_a("fluid", (INBT)this.storedFluid.serializeNBT());
        nbtTags.func_218657_a("gas", (INBT)this.storedGas.serializeNBT());
        nbtTags.func_218657_a("Item", this.storedItem.serializeNBT());
        nbtTags.func_218657_a("heat", (INBT)this.storedHeat.serializeNBT());
    }

    @Override
    protected void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.presetVariables();
        this.storedEnergy.deserializeNBT((INBT)nbtTags.func_74775_l("energy"));
        this.storedFluid.deserializeNBT(nbtTags.func_74775_l("fluid"));
        this.storedGas.deserializeNBT(nbtTags.func_74775_l("gas"));
        this.storedItem.deserializeNBT((INBT)nbtTags.func_74775_l("Item"));
        this.storedHeat.deserializeNBT(nbtTags.func_74775_l("heat"));
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        this.storedEnergy.getEnergy().writeToBuffer(buffer);
        buffer.writeFluidStack(this.storedFluid.getFluid());
        ChemicalUtils.writeChemicalStack(buffer, this.storedGas.getStack());
        buffer.func_150786_a((CompoundNBT)this.storedItem.serializeNBT());
        buffer.writeDouble(this.storedHeat.getHeat());
    }

    @Override
    protected void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.presetVariables();
        this.storedEnergy.setEnergy(FloatingLong.readFromBuffer(dataStream));
        this.storedFluid.setStack(dataStream.readFluidStack());
        this.storedGas.setStack(ChemicalUtils.readGasStack(dataStream));
        this.storedItem.deserializeNBT((INBT)dataStream.func_150793_b());
        this.storedHeat.setHeat(dataStream.readDouble());
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
        return this.heatCapacitors;
    }

    @Override
    public void onContentsChanged() {
    }
}

