/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.block.IHasTileEntity;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.states.IStateStorage;
import mekanism.common.item.block.ItemBlockCardboardBox;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockCardboardBox
extends BlockMekanism
implements IStateStorage,
IHasTileEntity<TileEntityCardboardBox> {
    public BlockCardboardBox() {
        super(Block.Properties.func_200945_a((Material)Material.field_151580_n).func_200948_a(0.5f, 1.0f));
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntityCardboardBox box;
        if (!world.field_72995_K && player.func_225608_bj_() && (box = MekanismUtils.getTileEntity(TileEntityCardboardBox.class, (IBlockReader)world, pos)) != null && box.storedData != null) {
            BlockData data = box.storedData;
            world.func_175656_a(pos, data.blockState);
            if (data.tileTag != null) {
                data.updateLocation(pos);
                TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, pos);
                if (tile != null) {
                    tile.func_145839_a(data.tileTag);
                }
            }
            BlockCardboardBox.func_180635_a((World)world, (BlockPos)pos, (ItemStack)MekanismBlocks.CARDBOARD_BOX.getItemStack());
        }
        return player.func_225608_bj_() ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(@Nonnull BlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PlayerEntity player) {
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        TileEntityCardboardBox tile = MekanismUtils.getTileEntity(TileEntityCardboardBox.class, world, pos);
        if (tile == null) {
            return itemStack;
        }
        if (tile.storedData != null) {
            ((ItemBlockCardboardBox)itemStack.func_77973_b()).setBlockData(itemStack, tile.storedData);
        }
        return itemStack;
    }

    @Override
    public TileEntityType<TileEntityCardboardBox> getTileType() {
        return MekanismTileEntityTypes.CARDBOARD_BOX.getTileEntityType();
    }

    public static class BlockData {
        @Nonnull
        public final BlockState blockState;
        @Nullable
        public CompoundNBT tileTag;

        public BlockData(@Nonnull BlockState blockState) {
            this.blockState = blockState;
        }

        public static BlockData read(CompoundNBT nbtTags) {
            BlockData data = new BlockData(NBTUtil.func_190008_d((CompoundNBT)nbtTags.func_74775_l("blockState")));
            NBTUtils.setCompoundIfPresent(nbtTags, "tileTag", nbt -> {
                data.tileTag = nbt;
            });
            return data;
        }

        public void updateLocation(BlockPos pos) {
            if (this.tileTag != null) {
                this.tileTag.func_74768_a("x", pos.func_177958_n());
                this.tileTag.func_74768_a("y", pos.func_177956_o());
                this.tileTag.func_74768_a("z", pos.func_177952_p());
            }
        }

        public CompoundNBT write(CompoundNBT nbtTags) {
            nbtTags.func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)this.blockState));
            if (this.tileTag != null) {
                nbtTags.func_218657_a("tileTag", (INBT)this.tileTag);
            }
            return nbtTags;
        }
    }
}

