/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import javax.annotation.Nullable;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiBar<INFO extends IBarInfoHandler>
extends GuiTexturedElement {
    private static final ResourceLocation BAR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "base.png");
    private final INFO handler;

    public GuiBar(ResourceLocation resource, IGuiWrapper gui, INFO handler, int x, int y, int width, int height) {
        super(resource, gui, x, y, width + 2, height + 2);
        this.handler = handler;
    }

    public INFO getHandler() {
        return this.handler;
    }

    protected abstract void renderBarOverlay(int var1, int var2, float var3);

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.renderExtendedTexture(BAR, 2, 2);
        if (this.handler.getLevel() > 0.0) {
            GuiBar.minecraft.field_71446_o.func_110577_a(this.getResource());
            this.renderBarOverlay(mouseX, mouseY, partialTicks);
        }
    }

    public void renderToolTip(int mouseX, int mouseY) {
        ITextComponent tooltip = this.handler.getTooltip();
        if (tooltip != null) {
            this.displayTooltip(tooltip, mouseX, mouseY);
        }
    }

    protected static int calculateScaled(double scale, int value) {
        if (scale == 1.0) {
            return value;
        }
        if (scale < 1.0) {
            return (int)(scale * (double)value);
        }
        return (int)Math.round(scale * (double)value);
    }

    public static interface IBarInfoHandler {
        @Nullable
        default public ITextComponent getTooltip() {
            return null;
        }

        public double getLevel();
    }
}

