/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathingWithTypesBucketable;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.JumpGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFlyingFish
extends EntityWaterMobPathingWithTypesBucketable {
    public EntityFlyingFish(World world) {
        super((EntityType<? extends EntityWaterMobPathingWithTypesBucketable>)ModEntities.FLYING_FISH.entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new LookAtGoal((MobEntity)this, WaterMobEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(0, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SurfaceOnAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyingFishFlyGoal(this, 5));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 0.5, 1));
    }

    @Override
    public void func_70636_d() {
        if (!this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        super.func_70636_d();
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203818_az;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.DROPS_COD;
    }

    @Override
    public EntityTypeContainer<?> getContainer() {
        return ModEntities.FLYING_FISH;
    }

    @Override
    public EntityTypeContainerContainable<?, ?> getContainableContainer() {
        return ModEntities.FLYING_FISH;
    }

    public static class SurfaceOnAttackGoal
    extends Goal {
        private final EntityFlyingFish fish;
        private int targetY = 0;
        private boolean fail = false;

        public SurfaceOnAttackGoal(EntityFlyingFish fish) {
            this.fish = fish;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            int i = this.getTopWaterBlock();
            return this.fish.func_70643_av() != null && i != -1 && this.fish.func_180425_c().func_177956_o() < i;
        }

        public boolean func_75253_b() {
            return !this.fail && this.fish.func_180425_c().func_177956_o() != this.targetY;
        }

        public void func_75249_e() {
            this.fail = false;
            this.targetY = this.getTopWaterBlock();
        }

        public void func_75246_d() {
            if (!this.fish.func_70661_as().func_75492_a((double)this.fish.func_180425_c().func_177958_n(), (double)this.targetY, (double)this.fish.func_180425_c().func_177952_p(), 1.0)) {
                this.fail = true;
            }
        }

        public void func_75251_c() {
            this.fail = false;
        }

        private int getTopWaterBlock() {
            if (this.fish.func_70090_H()) {
                World world = this.fish.field_70170_p;
                BlockPos.Mutable pos = new BlockPos.Mutable(this.fish.func_180425_c());
                for (int i = this.fish.func_180425_c().func_177956_o(); i < this.fish.field_70170_p.getMaxHeight(); ++i) {
                    pos.func_185336_p(i);
                    if (!world.func_204610_c((BlockPos)pos).func_206884_a(FluidTags.field_206959_a) || !world.func_175623_d(pos.func_177984_a())) continue;
                    return i;
                }
            }
            this.fail = true;
            return -1;
        }
    }

    public static class FlyingFishFlyGoal
    extends JumpGoal {
        private final EntityFlyingFish fish;
        private final int chance;
        private boolean inWater;
        private BlockPos start;
        private int ticks = 0;
        private int scale;

        public FlyingFishFlyGoal(EntityFlyingFish fish, int chance) {
            this.fish = fish;
            this.chance = chance;
        }

        public boolean func_75250_a() {
            boolean revenge;
            boolean bl = revenge = this.fish.func_70643_av() != null && this.fish.func_70643_av().func_70032_d((Entity)this.fish) < 10.0f;
            if (revenge || this.fish.func_70681_au().nextInt(this.chance) == 0) {
                Direction direction = this.fish.func_184172_bi();
                int dx = direction.func_82601_c();
                int dz = direction.func_82599_e();
                if (revenge) {
                    LivingEntity attacker = this.fish.func_70643_av();
                    Vec3d vec = attacker.func_174791_d().func_178788_d(this.fish.func_174791_d()).func_72432_b();
                    dx = (int)vec.field_72450_a;
                    dz = (int)vec.field_72449_c;
                }
                for (int tempScale = this.scale = this.fish.func_70681_au().nextInt(4) + (revenge ? 7 : 5); tempScale >= 1; --tempScale) {
                    if (this.canJumpTo(this.fish.func_180425_c(), dx, dz, tempScale) && this.isAirAbove(this.fish.func_180425_c(), dx, dz, tempScale)) continue;
                    return false;
                }
                this.start = this.fish.func_180425_c();
                return true;
            }
            return false;
        }

        private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
            BlockPos blockpos = pos.func_177982_a(dx * scale, 0, dz * scale);
            return this.fish.field_70170_p.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a) && !this.fish.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
        }

        private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
            return this.fish.field_70170_p.func_175623_d(pos.func_177982_a(dx * scale, 1, dz * scale)) && this.fish.field_70170_p.func_175623_d(pos.func_177982_a(dx * scale, 2, dz * scale));
        }

        public boolean func_75253_b() {
            return this.ticks < 200 && this.fish.func_70643_av() != null ? this.fish.func_70643_av().func_70032_d((Entity)this.fish) > 10.0f : this.fish.func_174791_d().func_72438_d(new Vec3d((double)this.start.func_177958_n() + 0.5, (double)this.start.func_177956_o(), (double)this.start.func_177952_p() + 0.5)) < (double)this.scale;
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75249_e() {
            this.ticks = 0;
        }

        public void func_75251_c() {
            this.fish.field_70125_A = 0.0f;
            this.ticks = 0;
        }

        public void func_75246_d() {
            boolean lastInWater = this.inWater;
            if (!lastInWater) {
                this.inWater = this.fish.field_70170_p.func_204610_c(new BlockPos((Entity)this.fish)).func_206884_a(FluidTags.field_206959_a);
            }
            if (this.inWater && !lastInWater) {
                this.fish.func_184185_a(SoundEvents.field_205209_aZ, 1.0f, 1.0f);
            }
            Vec3d vec3d = this.fish.func_213322_ci();
            if (vec3d.field_72448_b * vec3d.field_72448_b < (double)0.03f && this.fish.field_70125_A != 0.0f) {
                this.fish.field_70125_A = MathHelper.func_226167_j_((float)this.fish.field_70125_A, (float)0.0f, (float)0.2f);
            } else {
                double d0 = Math.sqrt(Entity.func_213296_b((Vec3d)vec3d));
                double d1 = Math.signum(-vec3d.field_72448_b) * Math.acos(d0 / vec3d.func_72433_c()) * 57.2957763671875;
                this.fish.field_70125_A = (float)d1;
            }
            Direction direction = this.fish.func_184172_bi();
            this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c((double)direction.func_82601_c() * 0.03, 0.04, (double)direction.func_82599_e() * 0.03));
            this.fish.func_70661_as().func_75499_g();
            ++this.ticks;
        }
    }
}

