/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import its_meow.betteranimalsplus.common.entity.EntityJellyfish;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityBobbitWorm
extends EntityAnimalWithTypes {
    protected static final DataParameter<Integer> ATTACK_STATE = EntityDataManager.func_187226_a(EntityBobbitWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private float lastAttack = 0.0f;
    private float lastGrab = 0.0f;
    private Vec3d targetPosition;

    public EntityBobbitWorm(World world) {
        super(ModEntities.BOBBIT_WORM.entityType, world);
        this.func_184644_a(PathNodeType.WATER, 10.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 10.0f));
        HashSet<Class<EntityJellyfish>> blackList = new HashSet<Class<EntityJellyfish>>();
        blackList.add(SkeletonEntity.class);
        blackList.add(EndermanEntity.class);
        blackList.add(EntityJellyfish.class);
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, true, e -> e.func_213311_cf() < 3.0f && !(e instanceof IMob) && !(e instanceof EntityBobbitWorm) && (e.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL || !(e instanceof PlayerEntity)) && !blackList.contains(e.getClass())));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_STATE);
    }

    public int setAttackState(int state) {
        this.field_70180_af.func_187227_b(ATTACK_STATE, (Object)state);
        return state;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(10.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    @Nullable
    protected Vec3d getNewTargetPosition() {
        Vec3d pos = RandomPositionGenerator.func_75463_a((CreatureEntity)this, (int)20, (int)5);
        if (pos != null && this.isGoodBurrowingPosition(new BlockPos(pos))) {
            return pos;
        }
        if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150355_j) {
            return new Vec3d(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
        }
        return null;
    }

    public boolean isGoodBurrowingPosition(BlockPos pos) {
        Block below = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
        BlockState here = this.field_70170_p.func_180495_p(pos);
        return (below == Blocks.field_150435_aG || below == Blocks.field_150354_m || below == Blocks.field_150351_n || below == Blocks.field_150346_d) && here.func_196957_g((IBlockReader)this.field_70170_p, pos, PathType.WATER) && here.func_204520_s().func_206884_a(FluidTags.field_206959_a);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public void func_213352_e(Vec3d vec) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() - (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_());
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public void func_70071_h_() {
        Vec3d pos;
        super.func_70071_h_();
        if (!this.func_70090_H()) {
            this.func_213293_j(this.func_213322_ci().func_82615_a() * (double)0.2f, this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c() * (double)0.2f);
            if (!this.func_189652_ae()) {
                this.func_213293_j(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b() - 0.08, this.func_213322_ci().func_82616_c());
            }
            this.func_213293_j(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b() * (double)0.98f, this.func_213322_ci().func_82616_c());
        } else if (!this.field_70170_p.field_72995_K) {
            if (this.targetPosition != null) {
                this.func_213293_j((this.targetPosition.field_72450_a - this.func_226277_ct_()) * (double)0.05f, (this.targetPosition.field_72448_b - this.func_226278_cu_()) * (double)0.05f, (this.targetPosition.field_72449_c - this.func_226281_cx_()) * (double)0.05f);
            }
            if (this.targetPosition != null && Math.sqrt(this.func_180425_c().func_218140_a(this.targetPosition.field_72450_a, this.targetPosition.field_72448_b, this.targetPosition.field_72449_c, false)) < 1.0) {
                this.func_213293_j(this.func_213322_ci().func_82615_a() * (double)0.2f, this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c() * (double)0.2f);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_213293_j(this.func_213322_ci().func_82615_a() * (double)0.2f, this.func_213322_ci().func_82617_b() * (double)0.2f, this.func_213322_ci().func_82616_c() * (double)0.2f);
        }
        boolean goodPos = this.isGoodBurrowingPosition(this.func_180425_c());
        if (this.targetPosition == null && !goodPos && (pos = this.getNewTargetPosition()) != null) {
            this.targetPosition = pos;
        }
        if (this.targetPosition != null && Math.sqrt(this.func_180425_c().func_218140_a(this.targetPosition.field_72450_a, this.targetPosition.field_72448_b, this.targetPosition.field_72449_c, false)) < 1.0 && !goodPos) {
            this.targetPosition = null;
        }
        if (this.getAttackState() > 0) {
            this.setAttackState(this.getAttackState() - 1);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70089_S()) {
            if (this.func_184188_bt().contains(this.func_70638_az())) {
                float time = 30.0f;
                if (this.lastAttack + (time - 20.0f) < (float)this.field_70173_aa) {
                    this.setAttackState(20);
                }
                if (this.lastAttack + time < (float)this.field_70173_aa) {
                    this.func_70652_k((Entity)this.func_70638_az());
                    this.lastAttack = this.field_70173_aa;
                }
            } else if (this.lastGrab + 60.0f < (float)this.field_70173_aa && this.func_70068_e((Entity)this.func_70638_az()) < 5.0) {
                if (!this.func_70638_az().func_190530_aW() && (double)this.func_70638_az().func_213311_cf() < 2.5 && (double)this.func_70638_az().func_213302_cg() < 2.5) {
                    this.func_70638_az().func_184205_a((Entity)this, false);
                } else if (!this.func_70638_az().func_190530_aW()) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
                this.lastGrab = this.field_70173_aa;
            }
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_85033_bc() {
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public int func_70627_aG() {
        return 120;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    protected void updateAir(int air) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.func_70050_g(air - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.updateAir(i);
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public EntityTypeContainer<EntityBobbitWorm> getContainer() {
        return ModEntities.BOBBIT_WORM;
    }

    @Override
    protected EntityBobbitWorm getBaseChild() {
        return null;
    }
}

