/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.util;

import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;

public final class ClassLoadHacks {
    public static void runOnDist(Supplier<Runnable> clientTarget, Supplier<Runnable> serverTarget) {
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                clientTarget.get().run();
                break;
            }
            case DEDICATED_SERVER: {
                serverTarget.get().run();
                break;
            }
            default: {
                throw new IllegalArgumentException("UNSIDED?");
            }
        }
    }

    public static void runWhenLoaded(String modid, Supplier<Runnable> target) {
        if (ModList.get().isLoaded(modid) || modid.equals("minecraft")) {
            target.get().run();
        }
    }

    public static <T> T getInteropProxy(Class<T> baseType, String modid, String classNameActive, String classNameInactive) {
        T proxy = null;
        try {
            proxy = ModList.get().isLoaded(modid) ? (T)Class.forName(classNameActive).asSubclass(baseType).newInstance() : (T)Class.forName(classNameInactive).asSubclass(baseType).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LogManager.getLogger().error("Error retrieving compatibility class. This is a bug.");
        }
        return proxy;
    }

    public static <T> T getClassIfActive(Class<T> baseType, String modid, String classNameActive) {
        T proxy = null;
        try {
            if (ModList.get().isLoaded(modid)) {
                proxy = Class.forName(classNameActive).asSubclass(baseType).newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LogManager.getLogger().error("Error retrieving compatibility class. This is a bug.");
        }
        return proxy;
    }
}

