/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.gui.Segment;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@OnlyIn(value=Dist.CLIENT)
public class TextSegment
extends Segment {
    public final int color;
    public final String text;
    private final int offset;
    private final float size;

    public TextSegment(Screen gui, float posX, float posY, int width, int height, String text, int color, boolean popup, float size) {
        this(gui, posX, posY, width, height, text, color, 9, popup, size);
    }

    public TextSegment(Screen gui, float posX, float posY, int width, int height, String text, int color, boolean popup) {
        this(gui, posX, posY, width, height, text, color, 9, popup, 0.9f);
    }

    public TextSegment(Screen gui, float posX, float posY, int width, int height, String text, int color, int offset, boolean popup, float size) {
        super(gui, posX, posY, width, height, popup);
        this.color = color;
        this.text = text;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int offsetY = 0;
        for (String line : this.text.split("\n")) {
            DefaultSettings.fontRenderer.drawString(line, this.getPosX(), this.getPosY() + (float)offsetY, this.color, this.size, true);
            offsetY += this.offset;
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

