/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.MathUtil;
import de.pt400c.defaultsettings.gui.MenuScreen;
import de.pt400c.defaultsettings.gui.ScrollableSegment;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.NEX;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@OnlyIn(value=Dist.CLIENT)
public class SearchbarSegment
extends Segment {
    protected boolean grabbed;
    public String query = "";
    protected boolean focused = false;
    private int cursorTimer = 0;
    boolean activated;
    private float flashingTimer = 0.0f;
    private final ResourceLocation icon;
    int cursorPosition;
    protected final ScrollableSegment parent;
    private static final String chars = "@^\u00b0\"\u00a7$%&/()=?`\u00b4\\#+*'-}][{-_~";

    public SearchbarSegment(Screen gui, float posX, float posY, int width, int height, boolean popupSegment, ScrollableSegment parent) {
        super(gui, posX, posY, width, height, popupSegment);
        this.parent = parent;
        this.icon = new ResourceLocation("defaultsettings", "textures/gui/glass.png");
    }

    public static boolean isAllowedCharacter(char character) {
        return character != '\u00a7' && character >= ' ' && character != '\u007f' && chars.indexOf(character) == -1;
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 259) {
            if (this.query.length() < 1 || this.cursorPosition < 1) {
                return false;
            }
            String left = this.query.substring(0, this.cursorPosition);
            String right = this.query.substring(this.cursorPosition);
            left = left.substring(0, left.length() - 1);
            if (this.cursorPosition > 0) {
                --this.cursorPosition;
            }
            this.query = left + right;
            this.activated = false;
            return true;
        }
        if (p_keyPressed_1_ == 263) {
            this.cursorPosition = MathUtil.clamp(this.cursorPosition - 1, 0, this.query.length());
            return true;
        }
        if (p_keyPressed_1_ == 262) {
            this.cursorPosition = MathUtil.clamp(this.cursorPosition + 1, 0, this.query.length());
            return true;
        }
        if (p_keyPressed_1_ == 257 || p_keyPressed_1_ == 335) {
            if (!this.query.isEmpty()) {
                this.activated = true;
            }
            this.sendQuery();
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (SearchbarSegment.isAllowedCharacter(p_charTyped_1_)) {
            String s1 = SharedConstants.func_71565_a((String)Character.toString(p_charTyped_1_));
            if (this.query.isEmpty() && s1.equals(" ")) {
                return true;
            }
            if (this.query.length() > 30) {
                return false;
            }
            String left = this.query.substring(0, this.cursorPosition);
            String right = this.query.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.query = left + s1 + right;
            this.activated = false;
            return true;
        }
        return false;
    }

    private void sendQuery() {
        this.parent.add = 0.0f;
        this.parent.guiContentUpdate(this.query);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        this.flashingTimer = (float)((double)this.flashingTimer + 0.07);
        float darken = (float)((Math.sin(this.flashingTimer - 1.5707964f) + 1.0) / 4.0 + 0.5);
        int color = 0;
        this.width = MathUtil.clamp(DefaultSettings.fontRenderer.getStringWidth(this.query, 1.0f, false) + 15.0f, 40.0f, (float)(this.gui.width - 180));
        String text = this.query;
        float dots = DefaultSettings.fontRenderer.getStringWidth("...", 1.0f, false);
        float widthString = DefaultSettings.fontRenderer.getStringWidth(text, 1.0f, false);
        if (widthString >= (float)(this.gui.width - 190)) {
            text = DefaultSettings.fontRenderer.trimStringToWidth(text, (int)((float)(this.gui.width - 190 - 1) - dots), false) + "...";
        }
        MenuScreen menu = ((GuiConfig)this.gui).menu;
        this.focused = menu.getVariants().get((int)menu.index).selected == this;
        float diff = this.focused ? 1.5f : 1.0f;
        NEX.drawRectRoundedCorners(this.getPosX() - diff, this.getPosY() - diff, this.getPosX() + this.getWidth() + diff, this.getPosY() + this.getHeight() + diff, -1644826, 2.1474836E9f);
        NEX.drawRectRoundedCorners(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), -12829636, 2.1474836E9f);
        GL11.glEnable((int)3553);
        FileUtil.MC.func_110434_K().func_110577_a(this.icon);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        NEX.drawScaledTex(this.getPosX() - 18.0f, this.getPosY() + 2.0f, 15, 15);
        GL11.glDisable((int)3553);
        ++this.cursorTimer;
        if (this.cursorTimer > 80) {
            this.cursorTimer = 0;
        }
        if (this.cursorTimer <= 40 && this.focused) {
            color = -6250336;
            float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
            NEX.drawRect(this.getPosX() + 5.0f + DefaultSettings.fontRenderer.getStringWidth(text.substring(0, this.cursorPosition), 1.0f, false), this.getPosY() + 4.0f, this.getPosX() + 5.5f + DefaultSettings.fontRenderer.getStringWidth(text.substring(0, this.cursorPosition), 1.0f, false), this.getPosY() + this.getHeight() - 4.0f, null, false, null, false);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        if (this.query.isEmpty()) {
            DefaultSettings.fontRenderer.drawString("Query", this.getPosX() + 5.0f, this.getPosY() + 5.0f, this.focused && !this.activated ? NEX.darkenColor(-1644826, darken).getRGB() : -1644826, 1.0f, false);
        } else {
            DefaultSettings.fontRenderer.drawString(text, this.getPosX() + 5.0f, this.getPosY() + 5.0f, -1644826, 1.0f, false);
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            MenuScreen menu = ((GuiConfig)this.gui).menu;
            menu.getVariants().get((int)menu.index).selected = this;
            this.grabbed = true;
            if (this.query.isEmpty()) {
                return true;
            }
            this.cursorPosition = DefaultSettings.fontRenderer.trimStringToWidth(this.query, (int)((float)mouseX - (this.getPosX() + this.hitX + 5.0f)), false).length();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed && this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

