/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.ButtonRoundSegment;
import de.pt400c.defaultsettings.gui.ButtonSegment;
import de.pt400c.defaultsettings.gui.ContextMenuSegment;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.ExportSegment;
import de.pt400c.defaultsettings.gui.MathUtil;
import de.pt400c.defaultsettings.gui.MenuScreen;
import de.pt400c.defaultsettings.gui.QuitButtonSegment;
import de.pt400c.defaultsettings.gui.RenameSegment;
import de.pt400c.defaultsettings.gui.RowItem;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.defaultsettings.gui.TextSegment;
import de.pt400c.neptunefx.NEX;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@OnlyIn(value=Dist.CLIENT)
public class ProfilesSegment
extends Segment {
    protected boolean grabbed;
    protected float add = 0.0f;
    public List<RowItem> list = new ArrayList<RowItem>();
    private boolean invisible;
    private final ScrollbarSegment scrollBar;
    public final SearchbarSegment searchbar;
    private float distanceY = 0.0f;
    private float maxSize = 0.0f;
    private float velocity = 0.0f;
    private final Function<GuiConfig, Integer> widthF;
    private final Function<GuiConfig, Integer> heightF;
    static final int row = 15;
    public ArrayListCaseless profiles = new ArrayListCaseless();
    public final ContextMenuSegment context;
    public String selectedName;

    public ProfilesSegment(Screen gui, float posX, float posY, Function<GuiConfig, Integer> width, Function<GuiConfig, Integer> height) {
        super(gui, posX, posY, width.apply((GuiConfig)gui).intValue(), height.apply((GuiConfig)gui).intValue(), false);
        this.selectedName = FileUtil.privateJson.currentProfile;
        this.scrollBar = new ScrollbarSegment(this.gui, this.posX + this.width, posY, 6, 20, this);
        this.list = this.getRowList(null);
        this.context = new ContextMenuSegment(this.gui, this, 0.0f, 0.0f, 87.0f, 62.0f);
        this.searchbar = new SearchbarSegment(gui, posX + 96.0f, posY - 1.0f, 40, 18, false, this);
        this.widthF = width;
        this.heightF = height;
    }

    @Override
    public void init() {
        this.list = this.getRowList(null);
    }

    public List<RowItem> getRowList(String[] arg) {
        ArrayList<RowItem> rows = new ArrayList<RowItem>();
        File fileDir = FileUtil.getMainFolder();
        int i = 0;
        this.profiles.clear();
        for (File file : fileDir.listFiles()) {
            if (!file.isDirectory() || arg != null && arg.length != 0 && !file.getName().toLowerCase().startsWith(arg[0].toLowerCase()) || file.getName().equals("sharedConfigs")) continue;
            float yOffTemp = 14.5f + (float)(15 * i);
            ++i;
            this.profiles.add(file.getName());
            rows.add(new RowItem(file.getName(), new RadioButtonSegment(this.gui, 104.0f, yOffTemp + 46.5f, 2.5f, 2.5f, file.getName(), false, this)));
        }
        return rows;
    }

    @Override
    public boolean mouseScrolled(float p_mouseScrolled_1_) {
        if (this.context.openContext) {
            return false;
        }
        this.maxSize = 14.5f + (float)(15 * (this.list.size() - 1));
        if (!this.invisible) {
            this.velocity += p_mouseScrolled_1_;
        }
        return true;
    }

    @Override
    public void guiContentUpdate(String ... arg) {
        this.list = this.getRowList(arg);
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        float offX = this.getWidth() + 58.0f;
        float offY = 53.0f;
        float tempHeight = this.getHeight() + 2.0f;
        float tempWidth = 35.0f;
        if ((float)mouseX >= offX && (float)mouseY >= 53.0f && (float)mouseX < offX + 35.0f && (float)mouseY < 53.0f + tempHeight) {
            float yOffTemp;
            for (int i = 0; i < this.list.size() && ((yOffTemp = 14.5f + (float)(15 * i) + this.add) < -3.0f || !(yOffTemp > this.height + 15.0f - 0.5f)); ++i) {
            }
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (resized != this.resized_mark) {
            this.width = this.widthF.apply((GuiConfig)this.gui).intValue();
            this.height = this.heightF.apply((GuiConfig)this.gui).intValue();
            this.resized_mark = resized;
            this.context.openContext = false;
        }
        this.add += this.velocity;
        if (this.add > 0.0f) {
            this.add = 0.0f;
            this.velocity = 0.0f;
        }
        if (this.add < 0.0f) {
            float fix;
            float yOff = this.maxSize + this.add;
            float movable = this.getPosY() + yOff;
            if (movable < (fix = this.getPosY() + this.height - 1.0f)) {
                float tempAdd = this.getPosY() + this.height - 1.0f - (float)(15 * (this.list.size() - 1)) - this.getPosY() - 15.0f - 0.5f;
                this.velocity = 0.0f;
                this.add = tempAdd;
            }
        }
        if (this.velocity > 0.0f) {
            this.velocity -= 1.0f;
            if (this.velocity - 1.0f == 0.0f) {
                this.velocity -= 1.0f;
            }
        } else if (this.velocity < 0.0f) {
            this.velocity += 1.0f;
            if (this.velocity + 1.0f == 0.0f) {
                this.velocity += 1.0f;
            }
        }
        this.maxSize = 14.5f + (float)(15 * (this.list.size() - 1));
        int color = -1644826;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        this.invisible = this.maxSize <= this.height;
        NEX.drawRect(this.getPosX(), this.getPosY(), this.getPosX() + this.width + (!this.invisible ? this.scrollBar.getWidth() + 2.0f : 0.0f), this.getPosY() + this.height, -12829636, false, null, false);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        NEX.drawRect(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), -12829636, true, null, false);
        if (this.grabbed && !this.context.openContext) {
            if (this.invisible) {
                this.distanceY = 0.0f;
            } else {
                float factor = (float)mouseY - this.distanceY;
                if (factor > 0.0f) {
                    factor = 0.0f;
                }
                if (factor < 0.0f) {
                    float fix;
                    float yOff = this.maxSize + factor;
                    float movable = this.getPosY() + yOff;
                    if (movable < (fix = this.getPosY() + this.height - 1.0f)) {
                        float tempAdd;
                        factor = tempAdd = this.getPosY() + this.height - 1.0f - (float)(15 * (this.list.size() - 1)) - this.getPosY() - 15.0f - 0.5f;
                    }
                }
                this.add = factor;
            }
        } else {
            this.distanceY = 0.0f;
        }
        int scaleFactor = (int)scaledFactor;
        GL11.glPushMatrix();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)(this.getPosX() * (float)scaleFactor)), (int)((int)(((float)FileUtil.MC.field_195558_d.func_198087_p() - this.getPosY() - this.getHeight() - 1.0f) * (float)scaleFactor)), (int)((int)(this.getWidth() * (float)scaleFactor)), (int)((int)((this.getHeight() + 1.0f) * (float)scaleFactor)));
        boolean hover = false;
        for (int i = 0; i < this.list.size(); ++i) {
            float yOffTemp = 14.5f + (float)(15 * i) + this.add;
            if (yOffTemp < -3.0f) continue;
            if (yOffTemp > this.height + 15.0f - 0.5f) break;
            String text = this.list.get((int)i).displayString;
            if (FileUtil.deleted.contains(text)) {
                text = "\u00a7c" + text;
            }
            float dots = DefaultSettings.fontRenderer.getStringWidth("...", 1.0f, false);
            float widthString = DefaultSettings.fontRenderer.getStringWidth(text, 1.0f, false);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            if (((String)this.profiles.get(i)).equals(this.context.id)) {
                NEX.drawRectRoundedCorners(this.getPosX() + 19.0f, this.getPosY() + yOffTemp - 13.5f, this.getPosX() + this.getWidth() - 5.0f, this.getPosY() + yOffTemp - 1.0f, NEX.calcAlpha(-7631989, 1.0f - this.context.alpha).getRGB(), 2.0f);
            }
            if (((String)this.profiles.get(i)).equals(FileUtil.mainJson.mainProfile)) {
                color = -14580265;
                float f = (float)(color >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(color & 0xFF) / 255.0f;
                GL11.glColor3f((float)f, (float)f1, (float)f2);
                color = -1644826;
                NEX.drawCircle(this.getPosX(), this.getPosY() + yOffTemp - 7.25f, 2.0f, 270.0f, 50);
                if (NEX.distanceBetweenPoints(this.getPosX(), this.getPosY() + yOffTemp - 7.25f, mouseX, mouseY) <= 3.5f) {
                    hover = true;
                }
            }
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            if (widthString >= this.width - 40.0f) {
                DefaultSettings.fontRenderer.drawString(DefaultSettings.fontRenderer.trimStringToWidth(text, (int)(this.width - 40.0f - 1.0f - dots), false) + "...", (float)((int)this.getPosX() + 23), (float)((int)this.getPosY()) + yOffTemp - 11.5f, -1644826, 1.0f, false);
            } else {
                DefaultSettings.fontRenderer.drawString(text, (float)((int)this.getPosX() + 23), (float)((int)this.getPosY()) + yOffTemp - 11.5f, -1644826, 1.0f, false);
            }
            for (Segment segment : this.list.get((int)i).childs) {
                segment.customRender(mouseX, mouseY, 0.0f, this.add, partialTicks);
            }
            if (i == this.list.size() - 1) continue;
            NEX.drawRect(this.getPosX(), this.getPosY() + yOffTemp, this.getPosX() + this.getWidth() - 3.0f, this.getPosY() + yOffTemp + 0.5f, -6250336, true, null, false);
        }
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
        float percentHeight = this.height / this.maxSize;
        this.scrollBar.height = MathUtil.clamp(this.height * percentHeight, 20.0f, 2.1474836E9f);
        float first = this.maxSize - this.height + 1.0f;
        float second = -this.add;
        boolean active = true;
        if (first > second) {
            active = false;
        }
        float posPercentage = -this.add / (this.maxSize - this.height + (float)(active ? 1 : -1));
        this.scrollBar.setPos(this.posX + this.width, this.posY + (this.height - this.scrollBar.height) * posPercentage);
        if (!this.invisible) {
            NEX.drawRect(this.getPosX() + this.width - 3.0f, this.getPosY(), this.getPosX() + this.width - 2.0f, this.getPosY() + this.getHeight(), -1644826, true, null, false);
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        NEX.drawRectRoundedCornersHollow(this.getPosX() - 4.0f, this.getPosY() - 4.0f, this.getPosX() + (this.invisible ? this.width : this.width + this.scrollBar.getWidth() + 2.0f) + 4.0f, this.getPosY() + this.height + 4.0f, color, 10.0f, 6.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        if (!this.invisible) {
            this.scrollBar.render(mouseX, mouseY, partialTicks);
        }
        this.searchbar.render(mouseX, mouseY, partialTicks);
        this.context.render(mouseX, mouseY, partialTicks);
        ArrayList<String> lines = new ArrayList<String>();
        if (hover) {
            String txt = "Main Profile, default to be used";
            float textWidth = (int)((float)(mouseX + 12) + DefaultSettings.fontRenderer.getStringWidth(txt, 0.8f, true));
            if (textWidth > (float)this.gui.width) {
                lines.addAll(DefaultSettings.fontRenderer.listFormattedStringToWidth(txt, this.gui.width - mouseX - 12, true));
            } else {
                lines.add(txt);
            }
            textWidth = 0.0f;
            for (String line : lines) {
                if (!(DefaultSettings.fontRenderer.getStringWidth(line, 0.8f, true) > textWidth)) continue;
                textWidth = DefaultSettings.fontRenderer.getStringWidth(line, 0.8f, true);
            }
            NEX.drawButton(mouseX + 5, mouseY - 7 - 10 * lines.size(), (float)(mouseX + 15) + textWidth, mouseY - 3, -12961222, -2302756, 2);
            int offset = 0;
            Collections.reverse(lines);
            for (String line : lines) {
                DefaultSettings.fontRenderer.drawString(line, (float)(mouseX + 9), (float)(mouseY - 14 - offset), -12961222, 0.8f, true);
                offset += 10;
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            if (!this.context.isSelected(mouseX, mouseY)) {
                this.context.openContext = false;
            }
            ((DefaultSettingsGUI)this.gui).setSelected(this);
            for (int i = 0; i < this.list.size(); ++i) {
                float yOffTemp = (float)(15 * i + 15) - 0.5f + this.add;
                if (yOffTemp < -3.0f) continue;
                if (yOffTemp > this.height + 15.0f - 0.5f) break;
                for (Segment segment : this.list.get((int)i).childs) {
                    if (!segment.mouseClicked(mouseX, mouseY, button)) continue;
                    return true;
                }
            }
            this.grabbed = true;
            this.distanceY += (float)mouseY - this.add;
            return true;
        }
        return this.scrollBar.mouseClicked(mouseX, mouseY, button) ? true : this.searchbar.mouseClicked(mouseX, mouseY, button);
    }

    public void openContext(int mouseX, int mouseY, String id) {
        this.context.setPos(mouseX, mouseY);
        this.context.id = id;
        this.context.openContext = true;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        this.grabbed = false;
        if (button == 1 && !this.context.openContext) {
            int posY;
            int clickedID = (int)Math.ceil(-(this.add - ((float)mouseY - this.getPosY() + 0.5f)) / 15.0f - 1.0f);
            int posX = (float)mouseX <= this.posX + this.getWidth() - 80.0f ? mouseX : mouseX - 85;
            int n = posY = (float)mouseY <= 21.0f + this.posY + this.getHeight() - 85.0f ? mouseY : mouseY - 60;
            if (this.profiles.size() - 1 >= clickedID) {
                this.openContext(posX, posY, (String)this.profiles.get(clickedID));
            }
        }
        if (this.context.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            float yOffTemp = 14.5f + (float)(15 * i) + this.add;
            if (yOffTemp < -3.0f) continue;
            if (yOffTemp > this.height + 15.0f - 0.5f) break;
            if (this.scrollBar.mouseReleased(mouseX, mouseY, button)) {
                return true;
            }
            for (Segment segment : this.list.get((int)i).childs) {
                if (!segment.mouseReleased(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return this.searchbar.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        for (int i = 0; i < this.list.size(); ++i) {
            float yOffTemp = 14.5f + (float)(15 * i) + this.add;
            if (yOffTemp < -3.0f) continue;
            if (yOffTemp > this.height + 15.0f - 0.5f) break;
            for (Segment segment : this.list.get((int)i).childs) {
                if (!segment.mouseDragged(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return this.scrollBar.mouseDragged(mouseX, mouseY, button) ? true : this.searchbar.mouseDragged(mouseX, mouseY, button);
    }

    public static class ArrayListCaseless
    extends ArrayList<String> {
        private static final long serialVersionUID = 1366320704613211176L;

        @Override
        public boolean contains(Object o) {
            String str = (String)o;
            for (String s : this) {
                if (!str.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AddSegment
    extends ButtonSegment {
        private final Function<GuiConfig, Integer> posXF;
        private RenameSegment nameField;

        public AddSegment(Screen gui, Function<GuiConfig, Integer> posX, float posY, int width, int height, boolean popup) {
            super(gui, (float)posX.apply((GuiConfig)gui).intValue(), posY, null, null, width, height, 0, popup);
            this.posXF = posX;
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks) {
            if (resized != this.resized_mark && this.posXF != null) {
                this.posX = this.posXF.apply((GuiConfig)this.gui).intValue();
                this.resized_mark = resized;
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            int color = -12077006;
            if (this.isSelected(mouseX, mouseY)) {
                color = -12804821;
            }
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor3f((float)f, (float)f1, (float)f2);
            NEX.drawCircle(this.posX + this.width / 2.0f, this.posY + this.height / 2.0f, this.width / 2.0f, 0.0f, 0);
            int scaleFactor = (int)scaledFactor;
            NEX.drawLine2D_2(1.0f, 1.0f, 1.0f, 1.0f, scaleFactor, 3.0f, new MathUtil.Vec2f(this.posX + this.width / 2.0f, this.posY + 3.0f), new MathUtil.Vec2f(this.posX + this.width / 2.0f, this.posY + this.height - 3.0f));
            NEX.drawLine2D_2(1.0f, 1.0f, 1.0f, 1.0f, scaleFactor, 3.0f, new MathUtil.Vec2f(this.posX + 3.0f, this.posY + this.height / 2.0f), new MathUtil.Vec2f(this.posX + this.width - 3.0f, this.posY + this.height / 2.0f));
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
        }

        @Override
        public boolean mouseReleased(int mouseX, int mouseY, int button) {
            if (this.grabbed) {
                if (this.isSelected(mouseX, mouseY)) {
                    this.grabbed = false;
                }
                this.clickSound();
                GuiConfig gui = (GuiConfig)this.gui;
                gui.popup.setOpening(true);
                gui.popup.getWindow().title = "New Profile";
                gui.popup.getWindow().setPos(this.width / 2.0f - 105.0f, this.height / 2.0f - 50.0f);
                gui.popupField = gui.popup;
                gui.popupField.getWindow().clearChildren();
                this.nameField = new RenameSegment(gui, "", 10.0f, 35.0f, 190, 18, true);
                gui.popupField.getWindow().addChild(this.nameField);
                gui.popupField.getWindow().addChild(new QuitButtonSegment((Screen)gui, 190.0f, 5.0f, 14, 14, button2 -> {
                    gui.popupField.setOpening(false);
                    return true;
                }, 3.0f, true));
                MenuScreen menu = ((GuiConfig)this.gui).menu;
                menu.getVariants().get((int)menu.index).selected = this.nameField;
                gui.popupField.getWindow().addChild(new ButtonRoundSegment(gui, 75.0f, 75.0f, 60.0f, 20.0f, "Okay", null, button2 -> {
                    if (!gui.scrollableProfiles.profiles.contains(this.nameField.query.toLowerCase())) {
                        gui.scrollableProfiles.context.backgroundTimer = 2.6179938f;
                        gui.scrollableProfiles.context.setPos(-100.0f, -100.0f);
                        File fileDir = new File(FileUtil.getMainFolder(), this.nameField.query);
                        fileDir.mkdir();
                        gui.scrollableProfiles.guiContentUpdate(gui.scrollableProfiles.searchbar.query);
                        gui.scrollableProfiles.context.id = this.nameField.query;
                        gui.popupField.setOpening(false);
                    } else {
                        this.nameField.denied = true;
                    }
                    return true;
                }, 0.8f, true));
                gui.popup.setVisible(true);
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RadioButtonSegment
    extends Segment {
        protected final String name;
        protected boolean grabbed;
        public float timer;
        private float offX;
        private float offY;
        private final ProfilesSegment parent;

        public RadioButtonSegment(Screen gui, float posX, float posY, float width, float height, String name, boolean popupSegment, ProfilesSegment parent) {
            super(gui, posX, posY, width, height, popupSegment);
            this.timer = 0.0f;
            this.name = name;
            this.parent = parent;
            this.timer = this.parent.selectedName.equals(name) ? 1.0471976f : 0.0f;
        }

        @Override
        public void customRender(int mouseX, int mouseY, float customPosX, float customPosY, float partialTicks) {
            if (this.parent.selectedName.equals(this.name)) {
                if (this.timer <= 1.0471976f) {
                    this.timer = (float)((double)this.timer + 0.05);
                }
            } else if (this.timer > 0.0f) {
                this.timer = (float)((double)this.timer - 0.05);
            }
            float tempTimer = this.timer;
            if (this.timer > 1.0471976f) {
                tempTimer = 1.0471976f;
            } else if (this.timer < 0.0f) {
                tempTimer = 0.0f;
            }
            float alphaRate = (float)((Math.sin(3.0f * tempTimer - 4.712389f) + 1.0) / 2.0);
            int color = ExportSegment.locked ? -7895161 : -1644826;
            this.offX = customPosX;
            this.offY = customPosY;
            customPosX += this.getPosX();
            customPosY += this.getPosY();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor3f((float)f, (float)f1, (float)f2);
            NEX.drawCircle(customPosX + this.width / 2.0f, customPosY + this.width / 2.0f, 6.0f, 0.0f, 0);
            color = -14145496;
            f = (float)(color >> 16 & 0xFF) / 255.0f;
            f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            f2 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor3f((float)f, (float)f1, (float)f2);
            NEX.drawCircle(customPosX + this.width / 2.0f, customPosY + this.width / 2.0f, 5.0f, 0.0f, 0);
            if (this.timer <= 1.0471976f) {
                color = -14145496;
            }
            color = -97000;
            int value = (int)(((float)(color >> 24 & 0xFF) / 255.0f - alphaRate) * 255.0f);
            color = (value & 0xFF) << 24 | (color >> 16 & 0xFF & 0xFF) << 16 | (color >> 8 & 0xFF & 0xFF) << 8 | color & 0xFF & 0xFF;
            f = (float)(color >> 16 & 0xFF) / 255.0f;
            f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            f2 = (float)(color & 0xFF) / 255.0f;
            float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
            GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
            NEX.drawCircle(customPosX + this.width / 2.0f, customPosY + this.width / 2.0f, 3.0f, 0.0f, 0);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }

        @Override
        public boolean isSelected(int mouseX, int mouseY) {
            float tempX = this.getPosX() + this.offX + this.hitX;
            float tempY = this.getPosY() + this.offY + this.hitY;
            return (((GuiConfig)this.gui).popupField == null || this.getIsPopupSegment()) && (float)mouseX >= tempX - 4.0f && (float)mouseY >= tempY - 4.0f && (float)mouseX < tempX + this.getWidth() + 4.0f && (float)mouseY < tempY + this.getHeight() + 4.0f;
        }

        @Override
        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = true;
                ((DefaultSettingsGUI)this.gui).resetSelected();
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseDragged(int mouseX, int mouseY, int button) {
            if (!this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
                return false;
            }
            return true;
        }

        @Override
        public boolean mouseReleased(int mouseX, int mouseY, int button) {
            if (this.grabbed) {
                if (this.isSelected(mouseX, mouseY)) {
                    this.grabbed = false;
                }
                if (ExportSegment.locked) {
                    return false;
                }
                this.parent.selectedName = this.name;
                if (!FileUtil.privateJson.currentProfile.equals(this.name)) {
                    FileUtil.privateJson.targetProfile = this.name;
                    GuiConfig gui = (GuiConfig)this.gui;
                    gui.popup.setOpening(true);
                    gui.popup.getWindow().title = "Profiles Warning";
                    gui.popup.getWindow().setPos(this.width / 2.0f - 105.0f, this.height / 2.0f - 50.0f);
                    gui.popupField = gui.popup;
                    gui.popupField.getWindow().clearChildren();
                    gui.popupField.getWindow().addChild(new TextSegment(gui, 5.0f, 30.0f, 20, 20, "The new profile will be loaded by\nnext game's startup\n\n\u00a7cThus editing this profile requires\n\u00a7ca restart", -1, true));
                    gui.popupField.getWindow().addChild(new QuitButtonSegment((Screen)gui, 190.0f, 5.0f, 14, 14, button2 -> {
                        gui.popupField.setOpening(false);
                        return true;
                    }, 3.0f, true));
                    gui.popupField.getWindow().addChild(new ButtonRoundSegment(gui, 75.0f, 75.0f, 60.0f, 20.0f, "Okay", null, button2 -> {
                        gui.popupField.setOpening(false);
                        return true;
                    }, 0.8f, true));
                    gui.popup.setVisible(true);
                    FileUtil.privateJson.save();
                }
                this.clickSound();
                return true;
            }
            return false;
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class SearchbarSegment
    extends Segment {
        protected boolean grabbed;
        public String query;
        protected boolean focused;
        private int cursorTimer;
        boolean activated;
        private float flashingTimer;
        private final ResourceLocation icon;
        int cursorPosition;
        protected final ProfilesSegment parent;
        private static final String chars = "@^\u00b0\"\u00a7$%&/()=?`\u00b4\\#+*'-}][{-_~";

        public SearchbarSegment(Screen gui, float posX, float posY, int width, int height, boolean popupSegment, ProfilesSegment parent) {
            super(gui, posX, posY, width, height, popupSegment);
            this.query = "";
            this.focused = false;
            this.cursorTimer = 0;
            this.flashingTimer = 0.0f;
            this.parent = parent;
            this.icon = new ResourceLocation("defaultsettings", "textures/gui/glass.png");
        }

        public boolean isAllowedCharacter(char character) {
            return character != '\u00a7' && character >= ' ' && character != '\u007f' && chars.indexOf(character) == -1;
        }

        @Override
        public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
            if (p_keyPressed_1_ == 259) {
                if (this.query.length() < 1 || this.cursorPosition < 1) {
                    return false;
                }
                String left = this.query.substring(0, this.cursorPosition);
                String right = this.query.substring(this.cursorPosition);
                left = left.substring(0, left.length() - 1);
                if (this.cursorPosition > 0) {
                    --this.cursorPosition;
                }
                this.query = left + right;
                this.activated = false;
                return true;
            }
            if (p_keyPressed_1_ == 263) {
                this.cursorPosition = MathUtil.clamp(this.cursorPosition - 1, 0, this.query.length());
                return true;
            }
            if (p_keyPressed_1_ == 262) {
                this.cursorPosition = MathUtil.clamp(this.cursorPosition + 1, 0, this.query.length());
                return true;
            }
            if (p_keyPressed_1_ == 257 || p_keyPressed_1_ == 335) {
                if (!this.query.isEmpty()) {
                    this.activated = true;
                }
                this.sendQuery();
                return true;
            }
            return false;
        }

        @Override
        public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
            if (this.isAllowedCharacter(p_charTyped_1_)) {
                String s1 = SharedConstants.func_71565_a((String)Character.toString(p_charTyped_1_));
                if (this.query.isEmpty() && s1.equals(" ")) {
                    return true;
                }
                if (this.query.length() > 30) {
                    return false;
                }
                String left = this.query.substring(0, this.cursorPosition);
                String right = this.query.substring(this.cursorPosition);
                ++this.cursorPosition;
                this.query = left + s1 + right;
                this.activated = false;
                return true;
            }
            return false;
        }

        private void sendQuery() {
            this.parent.add = 0.0f;
            this.parent.guiContentUpdate(this.query);
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks) {
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            this.flashingTimer = (float)((double)this.flashingTimer + 0.07);
            float darken = (float)((Math.sin(this.flashingTimer - 1.5707964f) + 1.0) / 4.0 + 0.5);
            int color = 0;
            this.width = MathUtil.clamp(DefaultSettings.fontRenderer.getStringWidth(this.query, 1.0f, false) + 15.0f, 40.0f, (float)(this.gui.width - 240));
            String text = this.query;
            float dots = DefaultSettings.fontRenderer.getStringWidth("...", 1.0f, false);
            float widthString = DefaultSettings.fontRenderer.getStringWidth(text, 1.0f, false);
            if (widthString >= (float)(this.gui.width - 250)) {
                text = DefaultSettings.fontRenderer.trimStringToWidth(text, (int)((float)(this.gui.width - 250 - 1) - dots), false) + "...";
            }
            MenuScreen menu = ((GuiConfig)this.gui).menu;
            this.focused = menu.getVariants().get((int)menu.index).selected == this;
            float diff = this.focused ? 1.5f : 1.0f;
            NEX.drawRectRoundedCorners(this.getPosX() - diff, this.getPosY() - diff, this.getPosX() + this.getWidth() + diff, this.getPosY() + this.getHeight() + diff, -1644826, 2.1474836E9f);
            NEX.drawRectRoundedCorners(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), -12829636, 2.1474836E9f);
            GL11.glEnable((int)3553);
            FileUtil.MC.func_110434_K().func_110577_a(this.icon);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            NEX.drawScaledTex(this.getPosX() - 18.0f, this.getPosY() + 2.0f, 15, 15);
            GL11.glDisable((int)3553);
            ++this.cursorTimer;
            if (this.cursorTimer > 80) {
                this.cursorTimer = 0;
            }
            if (this.cursorTimer <= 40 && this.focused) {
                color = -6250336;
                float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
                float f = (float)(color >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
                NEX.drawRect(this.getPosX() + 5.0f + DefaultSettings.fontRenderer.getStringWidth(text.substring(0, this.cursorPosition), 1.0f, false), this.getPosY() + 4.0f, this.getPosX() + 5.5f + DefaultSettings.fontRenderer.getStringWidth(text.substring(0, this.cursorPosition), 1.0f, false), this.getPosY() + this.getHeight() - 4.0f, null, false, null, false);
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            if (this.query.isEmpty()) {
                DefaultSettings.fontRenderer.drawString("Query", this.getPosX() + 5.0f, this.getPosY() + 5.0f, this.focused && !this.activated ? NEX.darkenColor(-1644826, darken).getRGB() : -1644826, 1.0f, false);
            } else {
                DefaultSettings.fontRenderer.drawString(text, this.getPosX() + 5.0f, this.getPosY() + 5.0f, -1644826, 1.0f, false);
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }

        @Override
        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (this.isSelected(mouseX, mouseY)) {
                MenuScreen menu = ((GuiConfig)this.gui).menu;
                menu.getVariants().get((int)menu.index).selected = this;
                this.grabbed = true;
                if (this.query.isEmpty()) {
                    return true;
                }
                this.cursorPosition = DefaultSettings.fontRenderer.trimStringToWidth(this.query, (int)((float)mouseX - (this.getPosX() + this.hitX + 5.0f)), false).length();
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseDragged(int mouseX, int mouseY, int button) {
            if (!this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            return super.mouseDragged(mouseX, mouseY, button);
        }

        @Override
        public boolean mouseReleased(int mouseX, int mouseY, int button) {
            if (this.grabbed && this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ScrollbarSegment
    extends ButtonSegment {
        protected boolean grabbed;
        private final ProfilesSegment superScrollable;
        private double distanceY;

        public ScrollbarSegment(Screen gui, float posX, float posY, int width, int height, ProfilesSegment segment) {
            super(gui, posX, posY, null, null, width, height, 0);
            this.distanceY = 0.0;
            this.superScrollable = segment;
        }

        @Override
        public boolean isSelected(int mouseX, int mouseY) {
            return (float)mouseX >= this.getPosX() && (float)mouseY >= this.getPosY() + 3.0f && (float)mouseX < this.getPosX() + this.getWidth() && (float)mouseY < this.getPosY() + this.getHeight() - 3.0f;
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.grabbed) {
                int factor = (int)((double)mouseY - this.distanceY);
                this.posY = factor;
                if (this.posY < this.superScrollable.posY) {
                    this.posY = this.superScrollable.posY;
                }
                if (this.posY > this.superScrollable.posY + this.superScrollable.height - this.height) {
                    this.posY = this.superScrollable.posY + this.superScrollable.height - this.height;
                }
                float distance = Math.round(this.superScrollable.height - this.height);
                float pos = Math.round(this.posY - this.superScrollable.posY);
                float tempAdd = (int)(this.superScrollable.getPosY() + this.superScrollable.height - 1.0f - (float)(15 * (this.superScrollable.list.size() - 1)) - this.superScrollable.getPosY() - 15.0f - 0.5f);
                this.superScrollable.add = (int)(tempAdd * (pos / distance));
            } else {
                this.distanceY = 0.0;
            }
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            NEX.drawRectRoundedCorners(this.getPosX(), this.getPosY() + 3.0f, this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight() - 3.0f, -2039584, 800.0f);
            NEX.drawLine2D_2(0.2f, 0.2f, 0.2f, 1.0f, (int)scaledFactor, 2.0f, new MathUtil.Vec2f(this.getPosX() + this.width / 2.0f - 2.0f + 0.5f, this.getPosY() + this.height / 2.0f - 3.0f), new MathUtil.Vec2f(this.getPosX() + this.width / 2.0f + 2.0f - 0.5f, this.getPosY() + this.height / 2.0f - 3.0f));
            NEX.drawLine2D_2(0.2f, 0.2f, 0.2f, 1.0f, (int)scaledFactor, 2.0f, new MathUtil.Vec2f(this.getPosX() + this.width / 2.0f - 2.0f + 0.5f, this.getPosY() + this.height / 2.0f), new MathUtil.Vec2f(this.getPosX() + this.width / 2.0f + 2.0f - 0.5f, this.getPosY() + this.height / 2.0f));
            NEX.drawLine2D_2(0.2f, 0.2f, 0.2f, 1.0f, (int)scaledFactor, 2.0f, new MathUtil.Vec2f(this.getPosX() + this.width / 2.0f - 2.0f + 0.5f, this.getPosY() + this.height / 2.0f + 3.0f), new MathUtil.Vec2f(this.getPosX() + this.width / 2.0f + 2.0f - 0.5f, this.getPosY() + this.height / 2.0f + 3.0f));
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }

        @Override
        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = true;
                ((DefaultSettingsGUI)this.gui).resetSelected();
                this.distanceY += (double)((int)((float)mouseY - this.posY));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseDragged(int mouseX, int mouseY, int button) {
            return super.mouseDragged(mouseX, mouseY, button);
        }

        @Override
        public boolean mouseReleased(int mouseX, int mouseY, int button) {
            if (this.grabbed) {
                this.grabbed = false;
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }
    }
}

