/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.FramebufferPopup;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.PopupWindow;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.NEX;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public class PopupSegment
extends Segment {
    @Nonnull
    private PopupWindow window;
    boolean isVisible = false;
    public float backgroundTimer = 0.0f;
    public float windowTimer = 0.0f;
    public boolean open;
    public FramebufferPopup mapFrameBuffer;
    public FramebufferPopup mapFrameBufferContents;
    private int bufferWidth;
    private int testWidth = 220;
    private int bufferHeight;
    private int testHeight = 110;
    private float distanceX = 0.0f;
    private float distanceY = 0.0f;
    public float popX = 0.0f;
    public float popY = 0.0f;
    public boolean compiled = false;
    public boolean dragging;
    private float widthBuffer;
    private float heightBuffer;

    public PopupSegment(Screen gui, float posX, float posY, float width, float height) {
        super(gui, posX, posY, width, height, true);
        this.bufferWidth *= (int)scaledFactor;
        this.bufferHeight *= (int)scaledFactor;
        this.popX = this.gui.width / 2 - (this.testWidth - 10) / 2;
        this.popY = this.gui.height / 2 - (this.testHeight - 10) / 2;
        this.mapFrameBufferContents = new FramebufferPopup(this.bufferWidth, this.bufferHeight);
        this.mapFrameBuffer = new FramebufferPopup(this.bufferWidth, this.bufferHeight);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (resized != this.resized_mark) {
            this.width = this.gui.width;
            this.height = this.gui.height;
            this.bufferWidth = this.testWidth * (int)scaledFactor;
            this.bufferHeight = this.testHeight * (int)scaledFactor;
            this.popX = this.gui.width / 2 - (this.testWidth - 10) / 2;
            this.popY = this.gui.height / 2 - (this.testHeight - 10) / 2;
            this.mapFrameBufferContents.resize(this.bufferWidth, this.bufferHeight);
            this.mapFrameBuffer.resize(this.bufferWidth, this.bufferHeight);
            this.resized_mark = resized;
        }
        if (this.isVisible) {
            if (this.open) {
                if (this.backgroundTimer <= 1.0471976f) {
                    this.backgroundTimer = (float)((double)this.backgroundTimer + 0.05);
                }
                if (this.windowTimer <= 1.0471976f) {
                    this.windowTimer = (float)((double)this.windowTimer + 0.05);
                }
            } else {
                if (this.backgroundTimer > 0.0f) {
                    this.backgroundTimer = (float)((double)this.backgroundTimer - 0.05);
                } else {
                    this.setVisible(false);
                    ((GuiConfig)this.gui).popupField = null;
                }
                if (this.windowTimer > 0.0f) {
                    this.windowTimer = (float)((double)this.windowTimer - 0.05);
                }
            }
            float alpha = (float)((Math.sin(3.0f * this.backgroundTimer - 1.5707964f) + 1.0) / 2.0);
            GL30.glDisable((int)3008);
            NEX.drawRect(this.posX, this.posY, this.posX + this.width, this.posY + this.height, -1040187392, true, Float.valueOf(alpha), true);
            GL30.glEnable((int)3008);
            if (!this.compiled) {
                this.heightBuffer = this.bufferHeight / (int)scaledFactor;
                this.widthBuffer = this.bufferWidth / (int)scaledFactor;
                GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL30.glBindFramebuffer((int)36160, (int)this.mapFrameBuffer.msFbo);
                GL30.glViewport((int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight);
                GL30.glClear((int)16640);
                GL30.glEnable((int)3553);
                RenderHelper.func_74518_a();
                GL30.glClear((int)256);
                GL30.glMatrixMode((int)5889);
                GL30.glPushMatrix();
                GL30.glLoadIdentity();
                GL30.glOrtho((double)0.0, (double)(this.bufferWidth / (int)scaledFactor), (double)(this.bufferHeight / (int)scaledFactor), (double)0.0, (double)1000.0, (double)3000.0);
                GL30.glMatrixMode((int)5888);
                GL30.glPushMatrix();
                GL30.glLoadIdentity();
                GL30.glEnable((int)3042);
                GL30.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
                GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.window.render(mouseX, mouseY, partialTicks);
                GL30.glBindFramebuffer((int)36008, (int)this.mapFrameBuffer.msFbo);
                GL30.glBindFramebuffer((int)36009, (int)this.mapFrameBuffer.fbo);
                GL30.glBlitFramebuffer((int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight, (int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight, (int)16384, (int)9728);
                FileUtil.MC.func_147110_a().func_147610_a(true);
                GL30.glClear((int)16640);
                GL30.glLoadIdentity();
                GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL30.glMatrixMode((int)5889);
                GL30.glPopMatrix();
                GL30.glMatrixMode((int)5888);
                GL30.glPopMatrix();
                if (DefaultSettings.compatibilityMode) {
                    FileUtil.MC.func_147110_a().func_147610_a(true);
                } else {
                    GL30.glBindFramebuffer((int)36160, (int)((GuiConfig)this.gui).framebufferMc.framebuffer);
                }
                GL30.glViewport((int)0, (int)0, (int)FileUtil.MC.func_147110_a().field_147621_c, (int)FileUtil.MC.func_147110_a().field_147618_d);
                this.compiled = true;
            }
            int currBound = GL30.glGetInteger((int)32873);
            GL30.glBindTexture((int)3553, (int)this.mapFrameBuffer.texture);
            if (this.dragging) {
                float origX = this.popX;
                float origY = this.popY;
                this.popX = (float)mouseX - this.distanceX;
                this.popY = (float)mouseY - this.distanceY;
                if (this.popX - origX != 0.0f || this.popY - origY != 0.0f) {
                    this.window.children.forEach(segment -> segment.setPosHit(segment.posX, segment.posY, this.popX, this.popY));
                }
            }
            GL30.glPushMatrix();
            GL30.glTranslated((double)this.popX, (double)this.popY, (double)0.0);
            float alphaRate = ((GuiConfig)this.gui).popupField == null ? 1.0f : (float)((Math.sin(3.0f * ((GuiConfig)this.gui).popupField.windowTimer - 4.712389f) + 1.0) / 2.0);
            GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alphaRate));
            GL30.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL30.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL30.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL30.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL30.glEnable((int)3042);
            GL30.glDisable((int)3008);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GL30.glBegin((int)7);
            GL30.glTexCoord2f((float)0.0f, (float)0.0f);
            GL30.glVertex3d((double)0.0, (double)this.heightBuffer, (double)0.0);
            GL30.glTexCoord2f((float)1.0f, (float)0.0f);
            GL30.glVertex3d((double)this.widthBuffer, (double)this.heightBuffer, (double)0.0);
            GL30.glTexCoord2f((float)1.0f, (float)1.0f);
            GL30.glVertex3d((double)this.widthBuffer, (double)0.0, (double)0.0);
            GL30.glTexCoord2f((float)0.0f, (float)1.0f);
            GL30.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL30.glEnd();
            GL30.glEnable((int)3008);
            GL30.glDisable((int)3042);
            GL30.glBindTexture((int)3553, (int)currBound);
            GL30.glPopMatrix();
            this.renderContents(mouseX, mouseY, partialTicks);
            float c = 0.22745098f;
            GL30.glColor4f((float)c, (float)c, (float)c, (float)1.0f);
            this.window.hoverChecks(mouseX, mouseY);
        }
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        return ((DefaultSettingsGUI)this.gui).menu.getVariants().get((int)((DefaultSettingsGUI)this.gui).menu.index).selected != null ? ((DefaultSettingsGUI)this.gui).menu.getVariants().get((int)((DefaultSettingsGUI)this.gui).menu.index).selected.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : false;
    }

    @Override
    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        return ((DefaultSettingsGUI)this.gui).menu.getVariants().get((int)((DefaultSettingsGUI)this.gui).menu.index).selected != null ? ((DefaultSettingsGUI)this.gui).menu.getVariants().get((int)((DefaultSettingsGUI)this.gui).menu.index).selected.charTyped(p_charTyped_1_, p_charTyped_2_) : false;
    }

    public boolean isSelectedUpper(int mouseX, int mouseY) {
        return (float)mouseX >= this.popX + 5.0f && (float)mouseY >= this.popY + 15.0f && (float)mouseX <= this.popX + (float)(this.testWidth - 10) + 5.0f && (float)mouseY <= this.popY + 29.0f || (float)mouseX >= this.popX + 15.0f && (float)mouseY >= this.popY + 5.0f && (float)mouseX < this.popX + (float)(this.testWidth - 20) + 5.0f && (float)mouseY < this.popY + 15.0f || NEX.distanceBetweenPoints(this.popX + 15.0f, this.popY + 15.0f, mouseX, mouseY) <= 10.0f || NEX.distanceBetweenPoints(this.popX + (float)(this.testWidth - 10) - 5.0f, this.popY + 15.0f, mouseX, mouseY) <= 10.0f;
    }

    public void renderContents(int mouseX, int mouseY, float partialTicks) {
        this.heightBuffer = this.bufferHeight / (int)scaledFactor;
        this.widthBuffer = this.bufferWidth / (int)scaledFactor;
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL30.glBindFramebuffer((int)36160, (int)this.mapFrameBufferContents.msFbo);
        GL30.glViewport((int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight);
        GL30.glClear((int)16640);
        GL30.glEnable((int)3553);
        RenderHelper.func_74518_a();
        GL30.glClear((int)256);
        GL30.glMatrixMode((int)5889);
        GL30.glPushMatrix();
        GL30.glLoadIdentity();
        GL30.glOrtho((double)0.0, (double)(this.bufferWidth / (int)scaledFactor), (double)(this.bufferHeight / (int)scaledFactor), (double)0.0, (double)1000.0, (double)3000.0);
        GL30.glMatrixMode((int)5888);
        GL30.glPushMatrix();
        GL30.glLoadIdentity();
        GL30.glEnable((int)3042);
        GL30.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.window.renderContents(mouseX, mouseY, partialTicks);
        GL30.glBindFramebuffer((int)36008, (int)this.mapFrameBufferContents.msFbo);
        GL30.glBindFramebuffer((int)36009, (int)this.mapFrameBufferContents.fbo);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight, (int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight, (int)16384, (int)9728);
        FileUtil.MC.func_147110_a().func_147610_a(true);
        GL30.glClear((int)16640);
        GL30.glLoadIdentity();
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL30.glMatrixMode((int)5889);
        GL30.glPopMatrix();
        GL30.glMatrixMode((int)5888);
        GL30.glPopMatrix();
        if (DefaultSettings.compatibilityMode) {
            FileUtil.MC.func_147110_a().func_147610_a(true);
        } else {
            GL30.glBindFramebuffer((int)36160, (int)((GuiConfig)this.gui).framebufferMc.framebuffer);
        }
        GL30.glViewport((int)0, (int)0, (int)FileUtil.MC.func_147110_a().field_147621_c, (int)FileUtil.MC.func_147110_a().field_147618_d);
        int currBound = GL30.glGetInteger((int)32873);
        GL30.glBindTexture((int)3553, (int)this.mapFrameBufferContents.texture);
        GL30.glPushMatrix();
        GL30.glTranslated((double)this.popX, (double)this.popY, (double)0.0);
        float alphaRate = ((GuiConfig)this.gui).popupField == null ? 1.0f : (float)((Math.sin(3.0f * ((GuiConfig)this.gui).popupField.windowTimer - 4.712389f) + 1.0) / 2.0);
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alphaRate));
        GL30.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL30.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL30.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL30.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL30.glEnable((int)3042);
        GL30.glDisable((int)3008);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GL30.glBegin((int)7);
        GL30.glTexCoord2f((float)0.0f, (float)0.0f);
        GL30.glVertex3d((double)0.0, (double)this.heightBuffer, (double)0.0);
        GL30.glTexCoord2f((float)1.0f, (float)0.0f);
        GL30.glVertex3d((double)this.widthBuffer, (double)this.heightBuffer, (double)0.0);
        GL30.glTexCoord2f((float)1.0f, (float)1.0f);
        GL30.glVertex3d((double)this.widthBuffer, (double)0.0, (double)0.0);
        GL30.glTexCoord2f((float)0.0f, (float)1.0f);
        GL30.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL30.glEnd();
        GL30.glEnable((int)3008);
        GL30.glDisable((int)3042);
        GL30.glBindTexture((int)3553, (int)currBound);
        GL30.glPopMatrix();
    }

    public boolean isSelectedLower(int mouseX, int mouseY) {
        return (float)mouseX >= this.popX + 5.0f && (float)mouseY >= this.popY + 29.0f && (float)mouseX <= this.popX + (float)(this.testWidth - 10) + 5.0f && (float)mouseY <= this.popY + (float)(this.testHeight - 10) + 5.0f;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isVisible) {
            if (!this.isSelectedUpper(mouseX, mouseY) && !this.isSelectedLower(mouseX, mouseY)) {
                ((GuiConfig)this.gui).popupField.setOpening(false);
            }
            if (this.isSelectedUpper(mouseX, mouseY)) {
                this.dragging = true;
                this.distanceX = (float)mouseX - this.popX;
                this.distanceY = (float)mouseY - this.popY;
            }
            return this.window.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseDragged(int p_mouseDragged_1_, int p_mouseDragged_3_, int p_mouseDragged_5_) {
        if (this.isVisible) {
            return this.window.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_);
        }
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_);
    }

    public void reset() {
        this.popX = this.gui.width / 2 - (this.testWidth - 10) / 2;
        this.popY = this.gui.height / 2 - (this.testHeight - 10) / 2;
        this.compiled = false;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.dragging = false;
        if (this.isVisible) {
            return this.window.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public PopupSegment setOpening(boolean open, int width, int height) {
        this.open = open;
        this.bufferWidth = width;
        this.testWidth = width;
        this.bufferHeight = height;
        this.testHeight = height;
        this.bufferWidth = this.testWidth * (int)scaledFactor;
        this.bufferHeight = this.testHeight * (int)scaledFactor;
        this.popX = this.gui.width / 2 - (this.testWidth - 10) / 2;
        this.popY = this.gui.height / 2 - (this.testHeight - 10) / 2;
        this.mapFrameBufferContents.resize(this.bufferWidth, this.bufferHeight);
        this.mapFrameBuffer.resize(this.bufferWidth, this.bufferHeight);
        this.compiled = false;
        this.window.width = width - 10;
        this.window.height = height - 10;
        return this;
    }

    public PopupSegment setOpening(boolean open) {
        this.open = open;
        if (open) {
            this.bufferWidth = 220;
            this.testWidth = 220;
            this.bufferHeight = 110;
            this.testHeight = 110;
            this.bufferWidth = this.testWidth * (int)scaledFactor;
            this.bufferHeight = this.testHeight * (int)scaledFactor;
            this.popX = this.gui.width / 2 - (this.testWidth - 10) / 2;
            this.popY = this.gui.height / 2 - (this.testHeight - 10) / 2;
            this.mapFrameBufferContents.resize(this.bufferWidth, this.bufferHeight);
            this.mapFrameBuffer.resize(this.bufferWidth, this.bufferHeight);
            this.compiled = false;
            this.window.width = 210.0f;
            this.window.height = 100.0f;
        }
        return this;
    }

    public PopupSegment setWindow(PopupWindow segment) {
        this.window = segment;
        return this;
    }

    public PopupWindow getWindow() {
        return this.window;
    }
}

