/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.Segment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MenuArea
extends Segment {
    private List<Segment> children = new ArrayList<Segment>();
    public Segment selected = null;

    public MenuArea(Screen gui, float posX, float posY) {
        super(gui, posX, posY, (float)gui.width - posX, (float)gui.height - posY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        List<Segment> list = this.children;
        synchronized (list) {
            this.children.forEach(segment -> segment.render(mouseX, mouseY, partialTicks));
            if (((GuiConfig)this.gui).popupField == null) {
                this.children.forEach(segment -> segment.hoverCheck(mouseX, mouseY));
            }
        }
    }

    @Override
    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        return this.selected != null ? this.selected.charTyped(p_charTyped_1_, p_charTyped_2_) : false;
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        return this.selected != null ? this.selected.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseScrolled(float p_mouseScrolled_1_) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (segment.mouseScrolled(p_mouseScrolled_1_)) break;
            }
        }
        return super.mouseScrolled(p_mouseScrolled_1_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (!segment.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
        }
        this.selected = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseDragged(int p_mouseDragged_1_, int p_mouseDragged_3_, int p_mouseDragged_5_) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (segment.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_)) break;
            }
        }
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_3_, int p_mouseReleased_5_) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (segment.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_)) break;
            }
        }
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuArea addChild(Segment segment) {
        List<Segment> list = this.children;
        synchronized (list) {
            this.children.add(segment.setPos(this.posX + segment.posX, this.posY + segment.posY));
            segment.init();
        }
        return this;
    }

    public List<Segment> getChildren() {
        return this.children;
    }
}

