/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.BakedSegment;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.defaultsettings.gui.MathUtil;
import de.pt400c.neptunefx.NEX;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@OnlyIn(value=Dist.CLIENT)
public class ExportSegment
extends BakedSegment {
    private final String hoverMessage = "Switch Export Mode for the modpack";
    private final LeftMenu menu;
    private final Function<GuiConfig, Integer> posYF;
    public float animTimer = 0.0f;
    protected boolean grabbed;
    private float processFactor;
    public float flickerTimer = 0.0f;
    private float prevOff;
    static boolean locked;
    private static final ResourceLocation icon;
    private boolean doIt;

    public ExportSegment(Screen gui, float posX, Function<GuiConfig, Integer> posY, float width, float height, LeftMenu menu) {
        super(gui, 0, posX, posY.apply((GuiConfig)gui).intValue(), width, height, 44, 44, 44, true, false);
        this.posYF = posY;
        this.menu = menu;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (resized != this.resized_mark) {
            this.posY = this.posYF.apply((GuiConfig)this.gui).intValue();
        }
        this.setup();
        locked = ((GuiConfig)this.gui).menu.exportActive.getByte() == 2 && FileUtil.exportMode() && FileUtil.mainJson.activeConfigs.size() != 0;
        boolean inactive = false;
        byte exportActive = ((GuiConfig)this.gui).menu.exportActive.getByte();
        float darken = 0.0f;
        if (exportActive == 2) {
            if (this.animTimer <= 1.0471976f) {
                this.animTimer = (float)((double)this.animTimer + 0.05);
                this.doIt = true;
            }
        } else if (exportActive == 1) {
            if (this.animTimer > 0.0f) {
                this.animTimer = (float)((double)this.animTimer - 0.05);
                this.doIt = true;
            }
        } else {
            inactive = true;
            this.flickerTimer = (float)((double)this.flickerTimer + 0.05);
            darken = (float)((Math.sin(this.flickerTimer - 1.5707964f) + 1.0) / 4.0 + 0.5);
            this.doIt = true;
        }
        if (this.menu.offs != this.prevOff || this.doIt) {
            this.compiled = false;
            this.doIt = false;
        }
        if (!this.compiled) {
            this.preRender();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glShadeModel((int)7425);
            NEX.drawGradient(0.0f, 1.0f, 72.0f - this.menu.offs, 2.0f, -5592406, 0xE6E6E6, 1);
            NEX.drawGradient(0.0f, 41.0f, 72.0f - this.menu.offs, 42.0f, -5592406, 0xE6E6E6, 1);
            GL11.glShadeModel((int)7424);
            NEX.drawRect(0.0f, 0.0f, 72.0f - this.menu.offs, 1.0f, -1644826, false, null, false);
            NEX.drawRect(0.0f, 40.0f, 72.0f - this.menu.offs, 41.0f, -1644826, false, null, false);
            int on = -16207098;
            int off = -2599083;
            float offset = this.menu.offs / 20.0f;
            int getRed = NEX.getRed(on);
            int getGreen = NEX.getGreen(on);
            int getBlue = NEX.getBlue(on);
            this.processFactor = (float)((Math.sin(3.0f * this.animTimer - 1.5707964f) + 1.0) / 2.0);
            float red = (float)(NEX.getRed(-2599083) - getRed) * (1.0f - this.processFactor);
            float green = (float)(NEX.getGreen(-2599083) - getGreen) * (1.0f - this.processFactor);
            float blue = (float)(NEX.getBlue(-2599083) - getBlue) * (1.0f - this.processFactor);
            on = new Color((int)((float)getRed + red), (int)((float)getGreen + green), (int)((float)getBlue + blue)).getRGB();
            if (inactive) {
                on = NEX.darkenColor(-10790053, darken).getRGB();
            }
            float xPos = (72.0f - this.menu.offs) / 2.0f - 14.5f;
            NEX.drawRectRoundedCorners(xPos + offset * 2.0f - 0.5f, 20.0f + offset - 1.0f, xPos + 29.0f - offset * 2.0f + 0.5f, 34.0f - offset - 1.0f, NEX.darkenColor(on, 0.5f).getRGB(), 7.0f - offset);
            NEX.drawRectRoundedCorners(xPos + offset * 2.0f, 20.0f + offset, xPos + 29.0f - offset * 2.0f, 34.0f - offset, on, 7.0f - offset);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            DefaultSettings.fontRenderer.drawString("I", xPos + offset * -1.0f + 11.0f, 23.5f, new Color(255, 255, 255, (int)MathUtil.clamp(255.0f * this.processFactor, 4.0f, 255.0f)).getRGB(), 0.8f, true);
            DefaultSettings.fontRenderer.drawString("0", xPos + 29.0f + offset * 0.7f - 14.0f, 23.5f, new Color(255, 255, 255, (int)MathUtil.clamp(255.0f * (1.0f - this.processFactor), 4.0f, 255.0f)).getRGB(), 0.8f, true);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            float radius = 9.4f;
            int color = -1644826;
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor3f((float)f, (float)f1, (float)f2);
            NEX.drawCircle((28.0f - offset * 4.0f) * this.processFactor + xPos + offset * 2.0f, 27.0f, radius - offset, 0.0f, 0);
            radius = 8.5f;
            color = -12829636;
            f = (float)(color >> 16 & 0xFF) / 255.0f;
            f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            f2 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor3f((float)f, (float)f1, (float)f2);
            NEX.drawCircle((28.0f - offset * 4.0f) * this.processFactor + xPos + offset * 2.0f, 27.0f, radius - offset, 0.0f, 0);
            int scaleFactor = (int)scaledFactor;
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            float percent = MathUtil.clamp(this.menu.offsetTick / this.menu.maxOffTick, 0.0f, 0.95f);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            FileUtil.MC.func_110434_K().func_110577_a(icon);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)percent);
            GL11.glTranslatef((float)(5.0f + 7.0f * percent), (float)2.0f, (float)0.0f);
            NEX.drawScaledTex(0.0f, 0.0f, 19, 19);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            GL11.glEnable((int)3089);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glScissor((int)((int)(this.menu.offs * 1.2f / 2.0f * (float)scaleFactor)), (int)(5 * scaleFactor), (int)((int)((72.0f - this.menu.offs * 1.6f) * (float)scaleFactor) - (int)(this.menu.offs * 1.2f / 2.0f * (float)scaleFactor)), (int)(35 * scaleFactor));
            GL11.glDisable((int)3042);
            if (!(percent >= 0.8f)) {
                DefaultSettings.fontRenderer.drawString("Export Mode:", 2.0f + (72.0f - this.menu.offs) / 2.0f - DefaultSettings.fontRenderer.getStringWidth("Export Mode:", 0.9f, true) / 2.0f, 6.0f, NEX.calcAlpha(-1, percent).getRGB(), 0.9f, true);
            }
            GL11.glDisable((int)3089);
            this.postRender(1.0f, false);
        }
        GL11.glPushMatrix();
        this.drawTexture(1.0f);
        GL11.glPopMatrix();
        this.prevOff = this.menu.offs;
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        float offset = this.menu.offs / 20.0f;
        float xPos = (72.0f - this.menu.offs) / 2.0f - 14.5f;
        return (float)mouseX >= this.getPosX() + xPos + offset * 2.0f && (float)mouseY >= this.getPosY() + 20.0f + offset && (float)mouseX < this.getPosX() + xPos + 29.0f - offset * 2.0f && (float)mouseY < this.getPosY() + 14.0f + 20.0f - offset || NEX.distanceBetweenPoints((28.0f - offset * 4.0f) * this.processFactor + xPos + offset * 2.0f, this.posY + 7.0f + 20.0f, mouseX, mouseY) <= 9.4f - offset;
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        if (this.isSelected(mouseX, mouseY) && this.hoverMessage != null) {
            ArrayList<String> lines = new ArrayList<String>();
            float textWidth = (int)((float)(mouseX + 12) + DefaultSettings.fontRenderer.getStringWidth(this.hoverMessage, 0.8f, true));
            if (textWidth > (float)this.gui.width) {
                lines.addAll(DefaultSettings.fontRenderer.listFormattedStringToWidth(this.hoverMessage, this.gui.width - mouseX - 12, true));
            } else {
                lines.add(this.hoverMessage);
            }
            textWidth = 0.0f;
            for (String line : lines) {
                if (!(DefaultSettings.fontRenderer.getStringWidth(line, 0.8f, true) > textWidth)) continue;
                textWidth = DefaultSettings.fontRenderer.getStringWidth(line, 0.8f, true);
            }
            NEX.drawButton(mouseX + 5, mouseY - 7 - 10 * lines.size(), (float)(mouseX + 15) + textWidth, mouseY - 3, -12961222, -2302756, 2);
            int offset = 0;
            Collections.reverse(lines);
            for (String line : lines) {
                DefaultSettings.fontRenderer.drawString(line, (float)(mouseX + 9), (float)(mouseY - 14 - offset), -12961222, 0.8f, true);
                offset += 10;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            this.clickSound();
            byte exportActive = ((GuiConfig)this.gui).menu.exportActive.getByte();
            if (exportActive == 2) {
                ((GuiConfig)this.gui).copyConfigs();
            } else if (exportActive == 1) {
                ((GuiConfig)this.gui).deleteConfigs();
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    static {
        icon = new ResourceLocation("defaultsettings", "textures/gui/export_mode.png");
    }
}

