/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.defaultsettings.gui.Segment;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonSegment
extends Segment {
    protected final Function<ButtonSegment, Boolean> function;
    private static final float BRIGHT_SCALE = 0.85f;
    public String title;
    public String hoverMessage = null;
    protected boolean grabbed;
    protected final int border;
    public int color = -5987164;
    private Function<Segment, Float> posXF;
    private Function<Segment, Float> posYF;
    private Segment parent;

    public ButtonSegment(Screen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, String hoverMessage, LeftMenu menu, boolean popupSegment) {
        super(gui, posX, posY, width, height, popupSegment);
        this.title = title;
        this.function = function;
        this.border = border;
        this.hoverMessage = hoverMessage;
    }

    public ButtonSegment(Screen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, String hoverMessage, boolean popupSegment) {
        this(gui, posX, posY, title, function, width, height, border, hoverMessage, null, popupSegment);
    }

    public ButtonSegment(Screen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, String hoverMessage) {
        this(gui, posX, posY, title, function, width, height, border, hoverMessage, null, false);
    }

    public ButtonSegment(Screen gui, Segment parent, Function<Segment, Float> posX, Function<Segment, Float> posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, String hoverMessage) {
        this(gui, posX.apply(parent).floatValue(), posY.apply(parent).floatValue(), title, function, width, height, border, hoverMessage, null, false);
        this.parent = parent;
        this.posXF = posX;
        this.posYF = posY;
    }

    public ButtonSegment(Screen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border) {
        this(gui, posX, posY, title, function, width, height, border, null);
    }

    public ButtonSegment(Screen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, int width, int height, int border, boolean popupSegment) {
        this(gui, posX, posY, title, function, width, height, border, null, popupSegment);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (resized != this.resized_mark && this.posXF != null) {
            this.posX = this.posXF.apply(this.parent).floatValue();
            this.posY = this.posYF.apply(this.parent).floatValue();
            this.resized_mark = resized;
        }
    }

    protected static Color darkenColor(int color) {
        return new Color((int)((float)((color & 0xFF0000) >> 16) * 0.85f), (int)((float)((color & 0xFF00) >> 8) * 0.85f), (int)((float)(color & 0xFF) * 0.85f), 255);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            if (this.function.apply(this).booleanValue()) {
                this.clickSound();
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public Segment setPos(float x, float y) {
        return super.setPos(x, y);
    }
}

