/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.BakedSegment;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.NEX;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ButtonRoundSegment
extends BakedSegment {
    protected boolean grabbed;
    protected boolean grabbed_prev;
    public float animTimer = 0.0f;
    public float animTimerRight = 0.0f;
    private float processFactor;
    private final String hover;
    private final Function<ButtonRoundSegment, Boolean> function;
    public int color;
    private boolean doIt;
    public final String title;
    private boolean selected_prev;
    public int color_prev;
    public final float size;

    public ButtonRoundSegment(Screen gui, float posX, float posY, float width, float height, String title, String hover, Function<ButtonRoundSegment, Boolean> function, float size, boolean popupSegment) {
        super(gui, 52, posX, posY, width, height, 44, 44, 44, true, popupSegment);
        this.title = title;
        this.hover = hover;
        this.function = function;
        this.size = size;
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        if (this.isSelected(mouseX, mouseY) && this.hover != null) {
            ArrayList<String> lines = new ArrayList<String>();
            float textWidth = (int)((float)(mouseX + 12) + DefaultSettings.fontRenderer.getStringWidth(this.hover, 0.8f, true));
            if (textWidth > (float)this.gui.width) {
                lines.addAll(DefaultSettings.fontRenderer.listFormattedStringToWidth(this.hover, this.gui.width - mouseX - 12, true));
            } else {
                lines.add(this.hover);
            }
            textWidth = 0.0f;
            for (String line : lines) {
                if (!(DefaultSettings.fontRenderer.getStringWidth(line, 0.8f, true) > textWidth)) continue;
                textWidth = DefaultSettings.fontRenderer.getStringWidth(line, 0.8f, true);
            }
            NEX.drawButton(mouseX + 5, mouseY - 7 - 10 * lines.size(), (float)(mouseX + 15) + textWidth, mouseY - 3, -12961222, -2302756, 2);
            int offset = 0;
            Collections.reverse(lines);
            for (String line : lines) {
                DefaultSettings.fontRenderer.drawString(line, (float)(mouseX + 9), (float)(mouseY - 14 - offset), -12961222, 0.8f, true);
                offset += 10;
            }
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.gui instanceof GuiConfig && ((GuiConfig)this.gui).popupField == null) {
            return;
        }
        this.setup();
        boolean selected = this.isSelected(mouseX, mouseY);
        if (selected) {
            if (this.animTimer <= 1.5707964f) {
                this.animTimer = (float)((double)this.animTimer + 0.15);
                this.doIt = true;
            }
        } else if (this.animTimer > 0.0f) {
            this.animTimer = (float)((double)this.animTimer - 0.15);
            this.doIt = true;
        }
        if (this.selected_prev != selected || this.grabbed != this.grabbed_prev || this.color != this.color_prev || this.doIt) {
            this.compiled = false;
            this.doIt = false;
        }
        if (!this.compiled) {
            this.preRender();
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3553);
            NEX.drawRectRoundedCorners(0.0f, 0.0f, this.width, this.height, -1, 2.1474836E9f);
            float diff = this.grabbed ? 1.7f : 1.3f;
            int off = -12829636;
            this.processFactor = (float)Math.sin(this.animTimer * 2.0f - 1.5707964f) / 2.0f + 0.5f;
            int red = (int)((float)NEX.getRed(-12829636) + 35.0f * this.processFactor);
            int green = (int)((float)NEX.getGreen(-12829636) + 35.0f * this.processFactor);
            int blue = (int)((float)NEX.getBlue(-12829636) + 35.0f * this.processFactor);
            NEX.drawRectRoundedCorners(diff, diff, this.width - diff, this.height - diff, 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF, 2.1474836E9f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
            DefaultSettings.fontRenderer.drawString(this.title, 1.0f + this.getWidth() / 2.0f - DefaultSettings.fontRenderer.getStringWidth(this.title, this.size, true) / 2.0f, 6.5f + (this.size > 0.8f ? 1.2f : 0.0f), -1, this.size, true);
            GL11.glPopMatrix();
            this.postRender(1.0f, this.isPopupSegment);
        }
        GL11.glPushMatrix();
        this.drawTexture(1.0f);
        GL11.glPopMatrix();
        this.grabbed_prev = this.grabbed;
        this.selected_prev = selected;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            if (this.gui instanceof GuiConfig && !((GuiConfig)this.gui).popupField.open) {
                return false;
            }
            if (this.function.apply(this).booleanValue()) {
                this.clickSound();
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public Segment setPos(float x, float y) {
        return super.setPos(x, y);
    }
}

