/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.ButtonSegment;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.IconSegment;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.defaultsettings.gui.MathUtil;
import de.pt400c.neptunefx.NEX;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@OnlyIn(value=Dist.CLIENT)
public class ButtonMenuSegment
extends ButtonSegment {
    public final int id;
    public boolean activated;
    private float offsetX = 0.0f;
    private float offsetTick = 0.0f;
    private float timer;
    private final LeftMenu menu;
    private final float origLength;
    private final IconSegment icon;

    public ButtonMenuSegment(int id, Screen gui, float posX, float posY, String title, Function<ButtonSegment, Boolean> function, LeftMenu menu, String icon) {
        super(gui, posX, posY, title, function, 50, 20, 2);
        this.id = id;
        this.menu = menu;
        this.origLength = 50.0f;
        this.icon = new IconSegment(gui, posX + 27.0f, posY + 27.0f - 2.0f, 13.0f, 13.0f, icon, this.menu);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        float triple = (float)Math.sin(0.25 * (double)this.offsetTick);
        float func = triple * triple * triple * 6.0f;
        this.width = this.origLength - this.menu.offs * 1.6f;
        float percent = MathUtil.clamp(this.menu.offsetTick / this.menu.maxOffTick, 0.0f, 1.0f);
        if (this.activated) {
            if (this.timer <= 1.0471976f) {
                this.timer = (float)((double)this.timer + 0.05);
            }
        } else if (this.timer > 0.0f) {
            this.timer = (float)((double)this.timer - 0.05);
        }
        float alpha = (float)((Math.sin(3.0f * this.timer - 4.712389f) + 1.0) / 2.0);
        if (!(this.width < 3.5f)) {
            if ((this.isSelected(mouseX, mouseY) || this.activated) && this.offsetTick < (float)Math.PI * 2) {
                this.offsetTick = (float)((double)this.offsetTick + 0.4);
            } else if (this.offsetTick > 0.0f && !this.isSelected(mouseX, mouseY) && !this.activated) {
                this.offsetTick = (float)((double)this.offsetTick - 0.5);
            }
            this.offsetX = func;
            GL11.glPushMatrix();
            GL11.glEnable((int)3089);
            GL11.glEnable((int)3042);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            int scaleFactor = (int)scaledFactor;
            GL11.glScissor((int)((int)((this.getPosX() + 2.0f + this.offsetX) * (float)scaleFactor)), (int)((int)(((float)FileUtil.MC.field_195558_d.func_198087_p() - this.getPosY() - this.getHeight()) * (float)scaleFactor)), (int)((int)((this.getWidth() - 4.0f) * (float)scaleFactor)), (int)((int)(this.getHeight() * (float)scaleFactor)));
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3089);
            GL11.glPopMatrix();
        }
        int color = -1644826;
        if (this.activated) {
            color = -31464;
        }
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        float stringWidth = DefaultSettings.fontRenderer.getStringWidth(this.title, 0.9f, true);
        float width = (17.0f + stringWidth) / 2.0f;
        float posi = 37.0f - width;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        int outer = NEX.calcAlpha(-31464, percent * 1.7f).getRGB();
        int inner = NEX.calcAlpha(-11513776, percent * 1.7f).getRGB();
        int red = NEX.getRed(outer);
        int green = NEX.getGreen(outer);
        int blue = NEX.getBlue(outer);
        int alphaTest = MathUtil.clamp((int)((float)NEX.getAlpha(outer) - 255.0f * alpha), 0, 255);
        outer = (alphaTest & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        red = NEX.getRed(inner);
        green = NEX.getGreen(inner);
        blue = NEX.getBlue(inner);
        alphaTest = MathUtil.clamp((int)((float)NEX.getAlpha(inner) - 255.0f * alpha), 0, 255);
        inner = (alphaTest & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        NEX.drawRectRoundedCorners(posi - 5.0f + 10.0f * percent, this.posY + this.getHeight() / 2.0f - 14.0f, posi + width * 2.0f + 3.5f - 20.0f * percent, this.posY + this.getHeight() / 2.0f + 7.0f, outer, 800.0f);
        NEX.drawRectRoundedCorners(posi - 5.0f + 1.0f + 10.0f * percent, this.posY + this.getHeight() / 2.0f - 14.0f + 1.0f, posi + width * 2.0f + 3.5f - 1.0f - 20.0f * percent, this.posY + this.getHeight() / 2.0f + 7.0f - 1.0f, inner, 800.0f);
        if (this.activated) {
            NEX.drawRectRoundedCorners(-10.0f, this.posY + this.getHeight() / 2.0f - 14.0f, 40.0f * percent, this.posY + this.getHeight() / 2.0f + 7.0f, -1454354352, 800.0f);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)1.0f);
        float animStuff = posi - 36.0f + 23.0f;
        this.icon.customRender(mouseX, mouseY, posi - 36.0f - animStuff * percent, 0.0f, partialTicks);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)0, (int)((int)(((float)this.gui.height - (this.posY + this.getHeight() / 2.0f - 14.0f + 21.0f)) * (float)((int)scaledFactor))), (int)((int)(74.0f * (1.0f - percent) * (float)((int)scaledFactor))), (int)(21 * (int)scaledFactor));
        DefaultSettings.fontRenderer.drawString(this.title, posi + 17.0f, this.posY + this.getHeight() / 2.0f - 8.0f + 1.2f * percent, this.activated ? -31464 : -1644826, 0.9f - 0.3f * percent, true);
        GL11.glDisable((int)3089);
        GL11.glDisable((int)3042);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed && this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
            if (((Boolean)this.function.apply(this)).booleanValue()) {
                ((GuiConfig)this.gui).headerPart.compiled = false;
                this.setActive(Boolean.logicalXor(this.activated, true), false);
                this.clickSound();
            }
            return true;
        }
        return false;
    }

    public ButtonMenuSegment setActive(boolean active, boolean silent) {
        if (!silent && ((GuiConfig)this.gui).selectedSegment == this) {
            return this;
        }
        this.activated = active;
        ((GuiConfig)this.gui).changeSelected(this);
        return this;
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        return ((GuiConfig)this.gui).popupField == null && (float)mouseX >= this.getPosX() + this.hitX && (float)mouseY >= this.getPosY() + this.hitY && (float)mouseX < this.getPosX() + this.hitX + this.offsetX + this.getWidth() && (float)mouseY < this.getPosY() + this.hitY + this.getHeight();
    }

    protected int getRenderColor(byte state) {
        switch (state) {
            case 1: {
                return -8750470;
            }
            case 2: {
                return -10658467;
            }
        }
        return -5987164;
    }
}

