/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.FramebufferPopup;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.Segment;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public abstract class BakedSegment
extends Segment {
    protected boolean updateForced = false;
    public boolean compiled = false;
    protected FramebufferPopup mapFrameBuffer;
    protected int bufferWidth = (int)((double)this.width * scaledFactor);
    protected int bufferHeight = (int)((double)this.height * scaledFactor);
    protected int id;
    protected int heightBuffer;
    protected int widthBuffer;
    protected final boolean stat;
    private final int red;
    private final int green;
    private final int blue;

    public BakedSegment(Screen gui, int id, float posX, float posY, float width, float height, int red, int green, int blue, boolean stat, boolean popupSegment) {
        super(gui, posX, posY, width, height, popupSegment);
        this.mapFrameBuffer = new FramebufferPopup(this.bufferWidth, this.bufferHeight);
        this.stat = stat;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setup() {
        if (this.updateForced) {
            this.compiled = false;
            this.updateForced = false;
        }
        if (resized != this.resized_mark) {
            this.bufferWidth = (int)((double)this.width * scaledFactor);
            this.bufferHeight = (int)((double)this.height * scaledFactor);
            this.mapFrameBuffer.resize(this.bufferWidth, this.bufferHeight);
            this.resized_mark = resized;
            this.compiled = false;
        }
    }

    public void preRender() {
        this.heightBuffer = this.bufferHeight / (int)scaledFactor;
        this.widthBuffer = this.bufferWidth / (int)scaledFactor;
        GL30.glColor4f((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)1.0f);
        GL30.glClearColor((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)0.0f);
        GL30.glBindFramebuffer((int)36160, (int)this.mapFrameBuffer.msFbo);
        GL30.glViewport((int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight);
        GL30.glClear((int)16640);
        GL30.glEnable((int)3553);
        RenderHelper.func_74518_a();
        GL30.glMatrixMode((int)5889);
        GL30.glPushMatrix();
        GL30.glLoadIdentity();
        GL30.glOrtho((double)0.0, (double)(this.bufferWidth / (int)scaledFactor), (double)(this.bufferHeight / (int)scaledFactor), (double)0.0, (double)1000.0, (double)3000.0);
        GL30.glMatrixMode((int)5888);
        GL30.glPushMatrix();
        GL30.glLoadIdentity();
        GL30.glEnable((int)3042);
        GL30.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void postRender(float alpha, boolean popup) {
        GL30.glBindFramebuffer((int)36008, (int)this.mapFrameBuffer.msFbo);
        GL30.glBindFramebuffer((int)36009, (int)this.mapFrameBuffer.fbo);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight, (int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight, (int)16384, (int)9728);
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL30.glClear((int)16640);
        GL30.glLoadIdentity();
        GL30.glMatrixMode((int)5889);
        GL30.glPopMatrix();
        GL30.glMatrixMode((int)5888);
        GL30.glPopMatrix();
        if (popup && ((GuiConfig)this.gui).popupField != null) {
            GL30.glBindFramebuffer((int)36160, (int)((GuiConfig)this.gui).popupField.mapFrameBufferContents.msFbo);
            GL30.glViewport((int)0, (int)0, (int)((GuiConfig)this.gui).popupField.mapFrameBufferContents.width, (int)((GuiConfig)this.gui).popupField.mapFrameBufferContents.height);
        } else if (this.gui instanceof GuiConfig) {
            if (DefaultSettings.compatibilityMode) {
                FileUtil.MC.func_147110_a().func_147610_a(true);
            } else {
                GL30.glBindFramebuffer((int)36160, (int)((GuiConfig)this.gui).framebufferMc.framebuffer);
            }
            GL30.glViewport((int)0, (int)0, (int)FileUtil.MC.func_147110_a().field_147621_c, (int)FileUtil.MC.func_147110_a().field_147618_d);
        } else {
            FileUtil.MC.func_147110_a().func_147610_a(true);
            GL30.glViewport((int)0, (int)0, (int)FileUtil.MC.func_147110_a().field_147621_c, (int)FileUtil.MC.func_147110_a().field_147618_d);
        }
        this.compiled = true;
    }

    public void drawTexture(float alpha) {
        int currBound = GL30.glGetInteger((int)32873);
        GL30.glBindTexture((int)3553, (int)this.mapFrameBuffer.texture);
        GL30.glPushMatrix();
        GL30.glTranslated((double)this.posX, (double)this.posY, (double)0.0);
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL30.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL30.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL30.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL30.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL30.glEnable((int)3042);
        GL30.glDisable((int)3008);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GL30.glBegin((int)7);
        GL30.glTexCoord2f((float)0.0f, (float)0.0f);
        GL30.glVertex3d((double)0.0, (double)this.heightBuffer, (double)0.0);
        GL30.glTexCoord2f((float)1.0f, (float)0.0f);
        GL30.glVertex3d((double)this.widthBuffer, (double)this.heightBuffer, (double)0.0);
        GL30.glTexCoord2f((float)1.0f, (float)1.0f);
        GL30.glVertex3d((double)this.widthBuffer, (double)0.0, (double)0.0);
        GL30.glTexCoord2f((float)0.0f, (float)1.0f);
        GL30.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL30.glEnd();
        GL30.glEnable((int)3008);
        GL30.glDisable((int)3042);
        GL30.glBindTexture((int)3553, (int)currBound);
        GL30.glPopMatrix();
        GL30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }
}

