/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import de.pt400c.defaultsettings.BakeryRegistry;
import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.FramebufferDefault;
import de.pt400c.defaultsettings.gui.AboutSegment;
import de.pt400c.defaultsettings.gui.BakedSegment;
import de.pt400c.defaultsettings.gui.ButtonControlSegment;
import de.pt400c.defaultsettings.gui.ButtonMenuSegment;
import de.pt400c.defaultsettings.gui.ButtonRoundSegment;
import de.pt400c.defaultsettings.gui.ButtonUpdateChecker;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.ExportSegment;
import de.pt400c.defaultsettings.gui.HelpSegment;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.defaultsettings.gui.MathUtil;
import de.pt400c.defaultsettings.gui.MenuArea;
import de.pt400c.defaultsettings.gui.MenuScreen;
import de.pt400c.defaultsettings.gui.PopupSegment;
import de.pt400c.defaultsettings.gui.PopupWindow;
import de.pt400c.defaultsettings.gui.ProfilesSegment;
import de.pt400c.defaultsettings.gui.QuitButtonSegment;
import de.pt400c.defaultsettings.gui.ScrollableSegment;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.defaultsettings.gui.SplitterSegment;
import de.pt400c.defaultsettings.gui.TextSegment;
import de.pt400c.neptunefx.NEX;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public class GuiConfig
extends DefaultSettingsGUI {
    public final Screen parentScreen;
    public LeftMenu leftMenu;
    public PopupSegment popup;
    public ButtonControlSegment buttonS;
    public ButtonControlSegment buttonK;
    public ButtonControlSegment buttonO;
    public ButtonMenuSegment[] menuButtons = new ButtonMenuSegment[4];
    public ButtonMenuSegment selectedSegment = null;
    private ExecutorService tpe = new ThreadPoolExecutor(1, 3, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private ButtonState[] cooldowns = new ButtonState[]{new ButtonState(false, 0), new ButtonState(false, 0), new ButtonState(false, 0)};
    public FramebufferDefault framebufferMc;
    public boolean init = false;
    public HeaderPart headerPart = null;
    private int gcAmount;
    public ProfilesSegment scrollableProfiles;
    private int storeWidth;
    private int storeHeight;
    private final int framerateLimit;
    public double thingWidth = 0.0;
    public double thingHeight = 0.0;
    public int renderTick = 0;
    public long laterTick = 0L;
    public long prevTick = 0L;
    public float median = 0.0f;

    public GuiConfig(Minecraft minecraft, Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("defaultsettings.main.title", new Object[0]));
        this.minecraft = minecraft;
        this.parentScreen = parentScreen;
        this.framerateLimit = FileUtil.MC.field_195558_d.func_198082_x();
        FileUtil.MC.field_195558_d.func_216526_a(60);
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256 && this.popupField != null) {
            this.popupField.setOpening(false);
            return true;
        }
        if (p_keyPressed_1_ == 290 && this.popupField == null) {
            HelpSegment.openPopup(this);
            return true;
        }
        if (p_keyPressed_1_ == 265 && this.popupField == null) {
            this.headerPart.compiled = false;
            if (this.selectedSegment.id > 0) {
                this.setActive(this.selectedSegment.id - 1);
            } else {
                this.setActive(3);
            }
            return true;
        }
        if (p_keyPressed_1_ == 264 && this.popupField == null) {
            this.headerPart.compiled = false;
            if (this.selectedSegment.id < 3) {
                this.setActive(this.selectedSegment.id + 1);
            } else {
                this.setActive(0);
            }
            return true;
        }
        if (p_keyPressed_1_ == 256 && this.shouldCloseOnEsc()) {
            if (this.menu.exportActive.getByte() == 2 && FileUtil.exportMode() && FileUtil.mainJson.activeConfigs.size() != 0) {
                this.exportModeInfo();
            } else {
                this.onClose();
            }
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void setActive(int id) {
        if (this.selectedSegment != null) {
            this.selectedSegment.setActive(false, true);
        }
        this.menuButtons[id].activated = true;
        this.selectedSegment = this.menuButtons[id];
        this.menu.setIndex(id);
    }

    public void testInit() {
        ++Segment.resized;
        Segment.scaledFactor = FileUtil.MC.field_195558_d.func_198100_s();
        new FileUtil.RegistryChecker();
        if (!DefaultSettings.compatibilityMode && this.framebufferMc != null) {
            this.framebufferMc.resize(FileUtil.MC.field_195558_d.func_198105_m(), FileUtil.MC.field_195558_d.func_198083_n());
        }
        FileUtil.MC.field_195559_v.func_197967_a(true);
        if (this.gcAmount == 9) {
            System.gc();
            this.gcAmount = 0;
        }
        this.thingWidth = FileUtil.MC.field_195558_d.func_198105_m() / (int)Segment.scaledFactor;
        this.thingHeight = FileUtil.MC.field_195558_d.func_198083_n() / (int)Segment.scaledFactor;
        ++this.gcAmount;
        if (!this.init) {
            this.clearSegments();
            if (!DefaultSettings.compatibilityMode) {
                this.framebufferMc = new FramebufferDefault(FileUtil.MC.field_195558_d.func_198105_m(), FileUtil.MC.field_195558_d.func_198083_n());
            }
            this.addSegment(new QuitButtonSegment((Screen)this, i -> i.width - 22, 2.0f, 20, 20, button -> {
                if (this.menu.exportActive.getByte() == 2 && FileUtil.exportMode() && FileUtil.mainJson.activeConfigs.size() != 0) {
                    this.exportModeInfo();
                } else {
                    this.minecraft.func_147108_a(this.parentScreen);
                }
                return true;
            }, 5.0f, false));
            this.addSegment(new HelpSegment(this, i -> i.width - 55, 30.0f));
            this.menu = new MenuScreen(this, 74.0f, 25.0f);
            this.leftMenu = new LeftMenu(this, 0.0f, 25.0f, 46.0f, i -> i.height - 25);
            this.buttonO = new ButtonControlSegment(this, i -> Float.valueOf(i.getWidth() / 2.0f - 45.0f + i.getPosX() - 15.0f), i -> Float.valueOf(i.getHeight() / 2.0f - 30.0f + i.getPosY() + 5.0f), 90.0f, 30.0f, this.menu, 1, "Save Options", "Save all default game options", button -> {
                this.saveOptions();
                return true;
            });
            this.buttonS = new ButtonControlSegment(this, i -> Float.valueOf(i.getWidth() / 2.0f - 45.0f + i.getPosX() + 98.0f), i -> Float.valueOf(i.getHeight() / 2.0f - 30.0f + i.getPosY() + 5.0f), 90.0f, 30.0f, this.menu, 2, "Save Servers", "Save your servers", button -> {
                this.saveServers();
                return true;
            });
            this.buttonK = new ButtonControlSegment(this, i -> Float.valueOf(i.getWidth() / 2.0f - 45.0f + i.getPosX() - 128.0f), i -> Float.valueOf(i.getHeight() / 2.0f - 30.0f + i.getPosY() + 5.0f), 90.0f, 30.0f, this.menu, 0, "Save Keys", "Save keybindings", button -> {
                this.saveKeys();
                return true;
            });
            this.scrollableProfiles = new ProfilesSegment(this, 20.0f, 30.0f, i -> i.width - 74 - 90, i -> i.height - 25 - 10 - 30);
            this.addSegment(this.menu.addVariant(new MenuArea(this, 74.0f, 25.0f).addChild(this.buttonO).addChild(this.buttonS).addChild(this.buttonK)).addVariant(new MenuArea(this, 74.0f, 25.0f).addChild(new ScrollableSegment((Screen)this, 20.0f, 30.0f, i -> i.width - 74 - 90, i -> i.height - 25 - 10 - 30, 0))).addVariant(new MenuArea(this, 74.0f, 25.0f).addChild(this.scrollableProfiles).addChild(new ProfilesSegment.AddSegment((Screen)this, i -> i.width - 102, 5.0f, 18, 18, false))).addVariant(new MenuArea(this, 74.0f, 25.0f).addChild(new AboutSegment((Screen)this, 10.0f, 20.0f, 20, 20, false))));
            this.menuButtons[0] = new ButtonMenuSegment(0, this, 10.0f, 9.0f, "Save", button -> true, this.leftMenu, "textures/gui/save.png").setActive(true, false);
            this.menuButtons[1] = new ButtonMenuSegment(1, this, 10.0f, 35.0f, "Configs", button -> true, this.leftMenu, "textures/gui/config.png");
            this.menuButtons[2] = new ButtonMenuSegment(2, this, 10.0f, 61.0f, "Profiles", button -> true, this.leftMenu, "textures/gui/profiles.png");
            this.menuButtons[3] = new ButtonMenuSegment(3, this, 10.0f, 87.0f, "About", button -> true, this.leftMenu, "textures/gui/about.png");
            this.addSegment(this.leftMenu.addChild(this.menuButtons[0]).addChild(this.menuButtons[1]).addChild(this.menuButtons[2]).addChild(this.menuButtons[3]).addChild(new ExportSegment((Screen)this, 0.0f, i -> i.height - 80, 72.0f, 43.0f, this.leftMenu)).addChild(new SplitterSegment(this, 72.0f, 3.0f, i -> i.height - 30, this.leftMenu)).addChild(new ButtonUpdateChecker(this, i -> Float.valueOf((float)(i.height - 30 - 25) + this.leftMenu.getPosY()), this.leftMenu)));
            this.popup = new PopupSegment(this, 0.0f, 0.0f, this.width, this.height).setWindow(new PopupWindow((Screen)this, (float)(this.width / 2 - 105), (float)(this.height / 2 - 50), 210.0f, 100.0f, "").addChild(new QuitButtonSegment((Screen)this, 190.0f, 5.0f, 14, 14, button -> true, 3.0f, true)));
            this.addSegment(this.popup);
            this.init = true;
            this.headerPart = new HeaderPart(this, 0, 0.0f, 0.0f, i -> i.width, 26.0f, true, false);
        }
        if (this.popupField != null) {
            this.popupField.setOpening(false);
            this.popupField.backgroundTimer = 0.0f;
            this.popupField.windowTimer = 0.0f;
            this.popupField.setVisible(false);
        }
        this.popupField = null;
        super.init();
        if (this.init) {
            this.openDisclaimer();
        }
    }

    private void openDisclaimer() {
        if (FileUtil.otherCreator) {
            this.popup.setOpening(true);
            this.popup.getWindow().title = "Warning";
            this.popup.getWindow().setPos(this.width / 2 - 105, this.height / 2 - 50);
            this.popupField = this.popup;
            this.popupField.getWindow().clearChildren();
            this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "You probably aren't the modpack's\ncreator. Being here might break stuff.\nIf you want to change the profile, use\nthe \u00a7bswitchprofile\u00a7r command, not this.", -1, true));
            this.popupField.getWindow().addChild(new QuitButtonSegment((Screen)this, 190.0f, 5.0f, 14, 14, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            this.popupField.getWindow().addChild(new ButtonRoundSegment(this, 75.0f, 75.0f, 60.0f, 20.0f, "Okay", null, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 0.8f, true));
            this.popup.setVisible(true);
        }
    }

    public void exportModeInfo() {
        this.popup.setOpening(true);
        this.popup.getWindow().title = "Export Mode";
        this.popup.getWindow().setPos(this.width / 2 - 105, this.height / 2 - 50);
        this.popupField = this.popup;
        this.popupField.getWindow().clearChildren();
        this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "The Export Mode has to be disabled\nin order to close this GUI", -1, true));
        this.popupField.getWindow().addChild(new QuitButtonSegment((Screen)this, 190.0f, 5.0f, 14, 14, button -> {
            this.popupField.setOpening(false);
            return true;
        }, 3.0f, true));
        this.popupField.getWindow().addChild(new ButtonRoundSegment(this, 75.0f, 75.0f, 60.0f, 20.0f, "Okay", null, button -> {
            this.popupField.setOpening(false);
            return true;
        }, 0.8f, true));
        this.popup.setVisible(true);
    }

    public void changeSelected(ButtonMenuSegment segment) {
        if (this.selectedSegment != null && this.selectedSegment != segment) {
            this.selectedSegment.setActive(false, true);
        }
        this.selectedSegment = segment;
        this.menu.setIndex(segment.id);
    }

    public void onClose() {
        FileUtil.MC.field_195559_v.func_197967_a(false);
        this.tpe.shutdownNow();
        BakeryRegistry.clearAll();
        if (!DefaultSettings.compatibilityMode && this.framebufferMc != null) {
            this.framebufferMc.deleteFramebuffer();
        }
        FileUtil.MC.field_195558_d.func_216526_a(this.framerateLimit);
        DefaultSettings.targetMS = 9;
        super.onClose();
    }

    public void saveServers() {
        if (FileUtil.serversFileExists()) {
            this.popup.setOpening(true);
            this.popup.getWindow().title = "Save Servers";
            this.popup.getWindow().setPos(this.width / 2 - 105, this.height / 2 - 50);
            this.popupField = this.popup;
            this.popupField.getWindow().clearChildren();
            this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "The server list already exists\n\nWould you like to overwrite it?", -1, true));
            this.popupField.getWindow().addChild(new QuitButtonSegment((Screen)this, 190.0f, 5.0f, 14, 14, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            this.popupField.getWindow().addChild(new ButtonRoundSegment(this, 75.0f, 75.0f, 60.0f, 20.0f, "Overwrite", null, button -> {
                this.cooldowns[1].setProgress(true);
                this.popupField.setOpening(false);
                this.tpe.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtil.saveServers();
                            ((GuiConfig)GuiConfig.this).cooldowns[1].renderCooldown = 30;
                        }
                        catch (ClosedByInterruptException e) {
                            DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the server list: Interruption exception");
                        }
                        catch (Exception e) {
                            DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                            ((GuiConfig)GuiConfig.this).cooldowns[1].renderCooldown = -30;
                        }
                        GuiConfig.this.cooldowns[1].setProgress(false);
                        FileUtil.servers_exists = FileUtil.serversFileExists();
                    }
                });
                return true;
            }, 0.8f, true));
            this.popup.setVisible(true);
        } else {
            this.tpe.execute(new Runnable(){

                @Override
                public void run() {
                    GuiConfig.this.cooldowns[1].setProgress(true);
                    try {
                        FileUtil.saveServers();
                        ((GuiConfig)GuiConfig.this).cooldowns[1].renderCooldown = 30;
                    }
                    catch (ClosedByInterruptException e) {
                        DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the server list: Interruption exception");
                    }
                    catch (Exception e) {
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                        ((GuiConfig)GuiConfig.this).cooldowns[1].renderCooldown = -30;
                    }
                    GuiConfig.this.cooldowns[1].setProgress(false);
                    FileUtil.servers_exists = FileUtil.serversFileExists();
                }
            });
        }
    }

    public void copyConfigs() {
        this.tpe.execute(new Runnable(){

            @Override
            public void run() {
                GuiConfig.this.menu.exportActive.setByte((byte)0);
                try {
                    FileUtil.restoreConfigs();
                }
                catch (IOException e) {
                    if (e instanceof ClosedByInterruptException) {
                        return;
                    }
                    DefaultSettings.getInstance();
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while trying to move the configs:", (Throwable)e);
                }
                GuiConfig.this.menu.exportActive.setByte((byte)1);
                for (MenuArea variant : GuiConfig.this.menu.getVariants()) {
                    variant.getChildren().stream().filter(segment -> segment instanceof ScrollableSegment).forEach(segment -> segment.guiContentUpdate(((ScrollableSegment)segment).searchbar.query));
                }
            }
        });
    }

    public void deleteConfigs() {
        this.tpe.execute(new Runnable(){

            @Override
            public void run() {
                GuiConfig.this.menu.exportActive.setByte((byte)0);
                try {
                    FileUtil.moveAllConfigs();
                    FileUtil.checkMD5();
                }
                catch (IOException e) {
                    if (e instanceof ClosedByInterruptException) {
                        return;
                    }
                    DefaultSettings.getInstance();
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while trying to move the configs:", (Throwable)e);
                }
                GuiConfig.this.menu.exportActive.setByte((byte)(FileUtil.exportMode() ? 2 : 1));
                for (MenuArea variant : GuiConfig.this.menu.getVariants()) {
                    variant.getChildren().stream().filter(segment -> segment instanceof ScrollableSegment).forEach(segment -> segment.guiContentUpdate(((ScrollableSegment)segment).searchbar.query));
                }
            }
        });
    }

    public void saveOptions() {
        if (FileUtil.optionsFilesExist()) {
            this.popup.setOpening(true);
            this.popup.getWindow().title = "Save Options";
            this.popup.getWindow().setPos(this.width / 2 - 105, this.height / 2 - 50);
            this.popupField = this.popup;
            this.popupField.getWindow().clearChildren();
            this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "The default options already exist\n\nWould you like to overwrite them?", -1, true));
            this.popupField.getWindow().addChild(new QuitButtonSegment((Screen)this, 190.0f, 5.0f, 14, 14, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            this.popupField.getWindow().addChild(new ButtonRoundSegment(this, 75.0f, 75.0f, 60.0f, 20.0f, "Overwrite", null, button -> {
                this.cooldowns[0].setProgress(true);
                this.popupField.setOpening(false);
                this.tpe.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtil.saveOptions();
                            ((GuiConfig)GuiConfig.this).cooldowns[0].renderCooldown = 30;
                        }
                        catch (ClosedByInterruptException e) {
                            DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the default game options: Interruption exception");
                        }
                        catch (Exception e) {
                            DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the default game options:", (Throwable)e);
                            ((GuiConfig)GuiConfig.this).cooldowns[0].renderCooldown = -30;
                        }
                        GuiConfig.this.cooldowns[0].setProgress(false);
                        FileUtil.options_exists = FileUtil.optionsFilesExist();
                    }
                });
                return true;
            }, 0.8f, true));
            this.popup.setVisible(true);
        } else {
            this.tpe.execute(new Runnable(){

                @Override
                public void run() {
                    GuiConfig.this.cooldowns[0].setProgress(true);
                    try {
                        FileUtil.saveOptions();
                        ((GuiConfig)GuiConfig.this).cooldowns[0].renderCooldown = 30;
                    }
                    catch (ClosedByInterruptException e) {
                        DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the default game options: Interruption exception");
                    }
                    catch (Exception e) {
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the default game options:", (Throwable)e);
                        ((GuiConfig)GuiConfig.this).cooldowns[0].renderCooldown = -30;
                    }
                    GuiConfig.this.cooldowns[0].setProgress(false);
                    FileUtil.options_exists = FileUtil.optionsFilesExist();
                }
            });
        }
    }

    public void saveKeys() {
        if (FileUtil.keysFileExist()) {
            this.popup.setOpening(true);
            this.popup.getWindow().title = "Save Keybindings";
            this.popup.getWindow().setPos(this.width / 2 - 105, this.height / 2 - 50);
            this.popupField = this.popup;
            this.popupField.getWindow().clearChildren();
            this.popupField.getWindow().addChild(new TextSegment(this, 5.0f, 30.0f, 20, 20, "The default keybindings already exist\n\nWould you like to overwrite them?", -1, true));
            this.popupField.getWindow().addChild(new QuitButtonSegment((Screen)this, 190.0f, 5.0f, 14, 14, button -> {
                this.popupField.setOpening(false);
                return true;
            }, 3.0f, true));
            this.popupField.getWindow().addChild(new ButtonRoundSegment(this, 75.0f, 75.0f, 60.0f, 20.0f, "Overwrite", null, button -> {
                this.cooldowns[2].setProgress(true);
                this.popupField.setOpening(false);
                this.tpe.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtil.saveKeys();
                            ((GuiConfig)GuiConfig.this).cooldowns[2].renderCooldown = 30;
                            FileUtil.restoreKeys();
                        }
                        catch (ClosedByInterruptException e) {
                            DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the key configuration: Interruption exception");
                        }
                        catch (Exception e) {
                            DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                            ((GuiConfig)GuiConfig.this).cooldowns[2].renderCooldown = -30;
                        }
                        GuiConfig.this.cooldowns[2].setProgress(false);
                        FileUtil.keys_exists = FileUtil.keysFileExist();
                    }
                });
                return true;
            }, 0.8f, true));
            this.popup.setVisible(true);
        } else {
            this.tpe.execute(new Runnable(){

                @Override
                public void run() {
                    GuiConfig.this.cooldowns[2].setProgress(true);
                    try {
                        FileUtil.saveKeys();
                        ((GuiConfig)GuiConfig.this).cooldowns[2].renderCooldown = 30;
                        FileUtil.restoreKeys();
                    }
                    catch (ClosedByInterruptException e) {
                        DefaultSettings.log.log(Level.DEBUG, "An exception occurred while saving the key configuration: Interruption exception");
                    }
                    catch (Exception e) {
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                        ((GuiConfig)GuiConfig.this).cooldowns[2].renderCooldown = -30;
                    }
                    GuiConfig.this.cooldowns[2].setProgress(false);
                    FileUtil.keys_exists = FileUtil.keysFileExist();
                }
            });
        }
    }

    public void tick() {
        super.tick();
        for (int id = 0; id < this.cooldowns.length; ++id) {
            if (this.cooldowns[id].renderCooldown > 0) {
                --this.cooldowns[id].renderCooldown;
                continue;
            }
            if (this.cooldowns[id].renderCooldown >= 0) continue;
            ++this.cooldowns[id].renderCooldown;
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (FileUtil.MC.field_195558_d.func_198105_m() != this.storeWidth || FileUtil.MC.field_195558_d.func_198083_n() != this.storeHeight) {
            this.storeWidth = FileUtil.MC.field_195558_d.func_198105_m();
            this.storeHeight = FileUtil.MC.field_195558_d.func_198083_n();
            this.testInit();
        }
        if (this.renderTick == Integer.MAX_VALUE) {
            this.renderTick = -1;
        }
        ++this.renderTick;
        this.prevTick = this.laterTick;
        this.laterTick = System.currentTimeMillis();
        float diff = this.laterTick - this.prevTick;
        float fps = 1.0f / diff * 1000.0f;
        this.median += fps;
        if (this.renderTick % 120 == 0) {
            float medFPS = this.median / 120.0f;
            if (medFPS < 50.0f && DefaultSettings.targetMS > 1) {
                --DefaultSettings.targetMS;
                this.testInit();
            }
            this.median = 0.0f;
        }
        if (!DefaultSettings.compatibilityMode) {
            GL30.glBindFramebuffer((int)36160, (int)this.framebufferMc.framebuffer);
            GL30.glClear((int)16640);
            GL30.glEnable((int)3553);
            GL30.glMatrixMode((int)5889);
            GL30.glLoadIdentity();
            GL30.glOrtho((double)0.0, (double)FileUtil.MC.field_195558_d.func_198107_o(), (double)FileUtil.MC.field_195558_d.func_198087_p(), (double)0.0, (double)1000.0, (double)3000.0);
            GL30.glMatrixMode((int)5888);
            GL30.glLoadIdentity();
            GL30.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
        GL30.glEnable((int)3042);
        GL30.glBlendFunc((int)770, (int)771);
        GL30.glDisable((int)3008);
        AbstractGui.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)-13882324);
        GL30.glDisable((int)3042);
        GL30.glEnable((int)3553);
        int n = this.cooldowns[1].getProgress() ? -3364076 : (this.cooldowns[1].renderCooldown < 0 ? -3402732 : (this.buttonS.color = this.cooldowns[1].renderCooldown > 0 ? -10630124 : -1644826));
        int n2 = this.cooldowns[2].getProgress() ? -3364076 : (this.cooldowns[2].renderCooldown < 0 ? -3402732 : (this.buttonK.color = this.cooldowns[2].renderCooldown > 0 ? -10630124 : -1644826));
        this.buttonO.color = this.cooldowns[0].getProgress() ? -3364076 : (this.cooldowns[0].renderCooldown < 0 ? -3402732 : (this.cooldowns[0].renderCooldown > 0 ? -10630124 : -1644826));
        this.headerPart.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
        if (!DefaultSettings.compatibilityMode) {
            GL30.glBindFramebuffer((int)36008, (int)this.framebufferMc.framebuffer);
            GL30.glBindFramebuffer((int)36009, (int)this.framebufferMc.interFramebuffer);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)FileUtil.MC.field_195558_d.func_198105_m(), (int)FileUtil.MC.field_195558_d.func_198083_n(), (int)0, (int)0, (int)FileUtil.MC.field_195558_d.func_198105_m(), (int)FileUtil.MC.field_195558_d.func_198083_n(), (int)16384, (int)9728);
            FileUtil.MC.func_147110_a().func_147610_a(true);
            GL30.glBindTexture((int)3553, (int)this.framebufferMc.screenTexture);
            GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL30.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL30.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL30.glEnable((int)3042);
            GL30.glDisable((int)3008);
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GL30.glBegin((int)7);
            GL30.glTexCoord2f((float)0.0f, (float)0.0f);
            GL30.glVertex3d((double)0.0, (double)this.thingHeight, (double)0.0);
            GL30.glTexCoord2f((float)1.0f, (float)0.0f);
            GL30.glVertex3d((double)this.thingWidth, (double)this.thingHeight, (double)0.0);
            GL30.glTexCoord2f((float)1.0f, (float)1.0f);
            GL30.glVertex3d((double)this.thingWidth, (double)0.0, (double)0.0);
            GL30.glTexCoord2f((float)0.0f, (float)1.0f);
            GL30.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL30.glEnd();
            GL30.glEnable((int)3008);
            GL30.glDisable((int)3042);
        }
    }

    public static class HeaderPart
    extends BakedSegment {
        private final Function<GuiConfig, Integer> widthF;
        public static String tabName;

        public HeaderPart(Screen gui, int id, float posX, float posY, Function<GuiConfig, Integer> width, float height, boolean stat, boolean popupSegment) {
            super(gui, id, posX, posY, width.apply((GuiConfig)gui).intValue(), height, 0, 0, 0, stat, popupSegment);
            this.widthF = width;
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks) {
            if (resized != this.resized_mark) {
                this.width = this.widthF.apply((GuiConfig)this.gui).intValue();
            }
            this.setup();
            if (!this.compiled) {
                this.preRender();
                GL30.glEnable((int)3042);
                GL30.glDisable((int)3553);
                GL30.glBlendFunc((int)770, (int)771);
                int index = ((GuiConfig)this.gui).menu.index;
                int offs = 0;
                if (index == 0) {
                    tabName = "Save";
                    offs = 0;
                } else if (index == 1) {
                    tabName = "Configs";
                    offs = 20;
                } else if (index == 2) {
                    tabName = "Profiles";
                    offs = 22;
                } else if (index == 3) {
                    tabName = "About";
                    offs = 5;
                }
                NEX.drawRect(0.0f, 25.0f, this.gui.width, 26.0f, -15329770, false, null, false);
                NEX.drawRect(0.0f, 0.0f, 59.5f, 25.0f, -14145496, false, null, false);
                NEX.drawRect(59.5f, 0.0f, this.gui.width, 25.0f, -11513776, false, null, false);
                NEX.drawRect(59.5f, 0.0f, 110 + offs, 25.0f, -8882056, false, null, false);
                GL30.glColor4f((float)0.15686275f, (float)0.15686275f, (float)0.15686275f, (float)1.0f);
                NEX.drawCircle(59.5f, 12.5f, 12.5f, 270.0f, 50);
                GL30.glColor4f((float)0.47058824f, (float)0.47058824f, (float)0.47058824f, (float)1.0f);
                NEX.drawCircle(110 + offs, 12.5f, 12.5f, 270.0f, 50);
                GL30.glEnable((int)3553);
                DefaultSettings.fontRenderer.drawString("Tab", MathUtil.clamp(36.0f - DefaultSettings.fontRenderer.getStringWidth("Tab", 1.2f, true) / 2.0f, 0.0f, 2.1474836E9f), 7.0f, -1, 1.4f, true);
                DefaultSettings.fontRenderer.drawString("- DefaultSettings -", (float)(100 + (this.gui.width - 100) / 2) - DefaultSettings.fontRenderer.getStringWidth("- DefaultSettings -", 1.2f, true) / 2.0f, 8.0f, -1, 1.2f, true);
                DefaultSettings.fontRenderer.drawString(tabName, 80, 8, -1, 1.2f, true);
                GL30.glDisable((int)3042);
                this.postRender(1.0f, false);
            }
            this.drawTexture(1.0f);
        }
    }

    private class ButtonState {
        private boolean inProgress = false;
        public int renderCooldown = 0;

        public ButtonState(boolean inProgress, int renderCooldown) {
            this.inProgress = inProgress;
            this.renderCooldown = renderCooldown;
        }

        public void setProgress(boolean inProgress) {
            this.inProgress = inProgress;
        }

        public boolean getProgress() {
            return this.inProgress;
        }
    }
}

