/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import de.pt400c.defaultsettings.BakeryRegistry;
import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import java.nio.ByteBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public class FramebufferPopup {
    public int width;
    public int height;
    public int msColorRenderBuffer;
    public int msFbo;
    public int texture;
    public int fbo;

    public FramebufferPopup(int width, int height) {
        this.width = width;
        this.height = height;
        this.setupFBO();
    }

    public void resize(int width, int height) {
        BakeryRegistry.fbos.remove(new Integer(this.msFbo));
        BakeryRegistry.fbos.remove(new Integer(this.fbo));
        BakeryRegistry.renderbs.remove(new Integer(this.msColorRenderBuffer));
        BakeryRegistry.textures.remove(new Integer(this.texture));
        GL30.glDeleteFramebuffers((int)this.fbo);
        GL30.glDeleteRenderbuffers((int)this.msFbo);
        GL30.glDeleteRenderbuffers((int)this.msColorRenderBuffer);
        GL30.glDeleteTextures((int)this.texture);
        this.width = width;
        this.height = height;
        this.setupFBO();
    }

    public void setupFBO() {
        this.msColorRenderBuffer = GL30.glGenRenderbuffers();
        this.msFbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)this.msFbo);
        GL30.glBindRenderbuffer((int)36161, (int)this.msColorRenderBuffer);
        GL30.glRenderbufferStorageMultisample((int)36161, (int)DefaultSettings.targetMS, (int)32856, (int)this.width, (int)this.height);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36064, (int)36161, (int)this.msColorRenderBuffer);
        GL30.glBindRenderbuffer((int)36161, (int)0);
        FileUtil.MC.func_147110_a().func_147610_a(true);
        this.texture = GL30.glGenTextures();
        this.fbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)this.fbo);
        GL30.glBindTexture((int)3553, (int)this.texture);
        GL30.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL30.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL30.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture, (int)0);
        GL30.glBindRenderbuffer((int)36161, (int)0);
        FileUtil.MC.func_147110_a().func_147610_a(true);
        BakeryRegistry.fbos.add(new Integer(this.msFbo));
        BakeryRegistry.fbos.add(new Integer(this.fbo));
        BakeryRegistry.renderbs.add(new Integer(this.msColorRenderBuffer));
        BakeryRegistry.textures.add(new Integer(this.texture));
    }
}

