/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import java.nio.ByteBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL32;

@OnlyIn(value=Dist.CLIENT)
public class FramebufferDefault {
    public int framebufferWidth;
    public int framebufferHeight;
    public int framebuffer = -1;
    public int interFramebuffer = -1;
    public int colorBuffer;
    public int multisampledTexture;
    public int screenTexture;

    public FramebufferDefault(int width, int height) {
        this.createBindFramebuffer(width, height);
    }

    public void createBindFramebuffer(int width, int height) {
        if (this.framebuffer >= 0) {
            this.deleteFramebuffer();
        }
        this.createFramebuffer(width, height);
        FileUtil.MC.func_147110_a().func_147610_a(true);
    }

    public void deleteFramebuffer() {
        FileUtil.MC.func_147110_a().func_147610_a(true);
        GL32.glDeleteFramebuffers((int)this.framebuffer);
        GL32.glDeleteFramebuffers((int)this.interFramebuffer);
    }

    public void createFramebuffer(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
        this.createFrameBuffer();
        this.createMSColorAttachment();
        FileUtil.MC.func_147110_a().func_147610_a(true);
        this.createMSFrameBuffer();
        this.createColorAttachment();
        this.framebufferClear();
    }

    private void createColorAttachment() {
        this.screenTexture = GL32.glGenTextures();
        GL32.glBindTexture((int)3553, (int)this.screenTexture);
        GL32.glTexImage2D((int)3553, (int)0, (int)6407, (int)this.framebufferWidth, (int)this.framebufferHeight, (int)0, (int)6407, (int)5121, (ByteBuffer)null);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.screenTexture, (int)0);
    }

    private void createFrameBuffer() {
        this.framebuffer = GL32.glGenFramebuffers();
        GL32.glBindFramebuffer((int)36160, (int)this.framebuffer);
    }

    private void createMSFrameBuffer() {
        this.interFramebuffer = GL32.glGenFramebuffers();
        GL32.glBindFramebuffer((int)36160, (int)this.interFramebuffer);
    }

    private void createMSColorAttachment() {
        this.multisampledTexture = GL32.glGenTextures();
        GL32.glBindTexture((int)37120, (int)this.multisampledTexture);
        GL32.glTexImage2DMultisample((int)37120, (int)DefaultSettings.targetMS, (int)6407, (int)this.framebufferWidth, (int)this.framebufferHeight, (boolean)true);
        GL32.glBindTexture((int)37120, (int)0);
        GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)37120, (int)this.multisampledTexture, (int)0);
    }

    public void framebufferClear() {
        GL32.glClear((int)16384);
        FileUtil.MC.func_147110_a().func_147610_a(true);
    }

    public void resize(int width, int height) {
        GL32.glDeleteFramebuffers((int)this.framebuffer);
        GL32.glDeleteFramebuffers((int)this.interFramebuffer);
        GL32.glDeleteTextures((int)this.screenTexture);
        GL32.glDeleteTextures((int)this.multisampledTexture);
        this.createBindFramebuffer(width, height);
    }
}

