/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import com.mojang.blaze3d.platform.GlStateManager;
import de.pt400c.defaultsettings.EventHandlers;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.KeyContainer;
import de.pt400c.defaultsettings.UnregHandlers;
import de.pt400c.defaultsettings.UpdateContainer;
import de.pt400c.defaultsettings.font.FontRendererClass;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="defaultsettings")
public class DefaultSettings {
    public static final String MODID = "defaultsettings";
    public static final Logger log = LogManager.getLogger((String)"defaultsettings");
    public static final String VERSION = DefaultSettings.getModVersion();
    public static final String USER_AGENT = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2";
    public static Map<String, KeyContainer> keyRebinds = new HashMap<String, KeyContainer>();
    public static boolean setUp = false;
    public static String BUILD_ID = "Unknown";
    public static String BUILD_TIME = "Unknown";
    public static FontRendererClass fontRenderer;
    private static final UpdateContainer updateContainer;
    public static DefaultSettings instance;
    public static final boolean debug = false;
    public static boolean init;
    public static Class<?> alphaTest;
    public static final boolean is_1_15;
    public static int targetMS;
    public static boolean compatibilityMode;

    public DefaultSettings() {
        instance = this;
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (setUp) {
                return;
            }
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::postInit);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::regInit);
            try {
                FileUtil.restoreContents();
            }
            catch (Exception e) {
                log.log(Level.ERROR, "An exception occurred while starting up the game:", (Throwable)e);
            }
            setUp = true;
            MinecraftForge.EVENT_BUS.register(DefaultSettings.class);
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
            MinecraftForge.EVENT_BUS.register((Object)new UnregHandlers());
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> GuiConfig::new);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "ANY", (remote, isServer) -> true));
            new Thread(){

                @Override
                public void run() {
                    try {
                        DefaultSettings.sendCount();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        });
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> log.log(Level.WARN, "DefaultSettings is a client-side mod only! It won't do anything on servers!"));
    }

    public static String getModVersion() {
        TomlParser parser = new TomlParser();
        InputStream stream = DefaultSettings.class.getClassLoader().getResourceAsStream("META-INF/mods.toml");
        CommentedConfig file = (CommentedConfig)parser.parse(stream);
        return (String)((CommentedConfig)((ArrayList)file.get("mods")).get(0)).get("version");
    }

    public void postInit(FMLLoadCompleteEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            fontRenderer = new FontRendererClass();
            fontRenderer.readFontTexture();
            try {
                DefaultSettings.getBuildID();
                DefaultSettings.getBuildTime();
            }
            catch (IOException | NullPointerException e) {
                log.log(Level.ERROR, "Something went wrong while starting up: ", (Throwable)e);
            }
            try {
                FileUtil.restoreKeys();
            }
            catch (IOException e) {
                log.log(Level.ERROR, "An exception occurred while starting up the game (Post):", (Throwable)e);
            }
            catch (NullPointerException e) {
                log.log(Level.ERROR, "An exception occurred while starting up the game (Post):", (Throwable)e);
            }
            try {
                String path = "/Alpha1_14Handler.clazz";
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
                byte[] b = new byte[is.available()];
                is.read(b);
                if (!FileUtil.byteToHash(b).equals("74474cc13af384bff32de57d8ae81ba504912d71ae7534f76125b62d2ea80d19")) {
                    log.log(Level.ERROR, "This mod has been manipulated! Save exit!");
                    Minecraft.func_71410_x().func_71400_g();
                    return;
                }
                Method defC = GlStateManager.class.getClassLoader().getClass().getSuperclass().getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defC.setAccessible(true);
                defC.invoke((Object)GlStateManager.class.getClassLoader(), "de.pt400c.defaultsettings.font.Alpha1_14Handler", b, 0, b.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> log.log(Level.WARN, "DefaultSettings is a client-side mod only! It won't do anything on servers!"));
    }

    public void regInit(RegistryEvent.NewRegistry event) {
        if (!init) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                try {
                    GameSettings gameSettings = FileUtil.MC.field_71474_y;
                    gameSettings.func_74300_a();
                    FileUtil.MC.field_71474_y.func_74303_b();
                }
                catch (NullPointerException e) {
                    log.log(Level.ERROR, "Something went wrong while starting up: ", (Throwable)e);
                }
            });
            DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> log.log(Level.WARN, "DefaultSettings is a client-side mod only! It won't do anything on servers!"));
            init = true;
        }
    }

    private static void getBuildID() throws FileNotFoundException, IOException {
        File file = FMLLoader.getLoadingModList().getModFileById(MODID).getFile().getFilePath().toFile();
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(file));){
            BUILD_ID = jarStream.getManifest().getMainAttributes().getValue("Build-ID");
        }
    }

    private static void getBuildTime() throws FileNotFoundException, IOException {
        File file = FMLLoader.getLoadingModList().getModFileById(MODID).getFile().getFilePath().toFile();
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(file));){
            BUILD_TIME = jarStream.getManifest().getMainAttributes().getValue("Implementation-Timestamp");
        }
    }

    public static UpdateContainer getUpdater() {
        return updateContainer;
    }

    public static DefaultSettings getInstance() {
        return instance;
    }

    public static void sendCount() throws Exception {
        String url = "https://apiv1.jomcraft.net/count";
        String jsonString = "{\"id\":\"Defaultsettings\", \"code\":" + RandomStringUtils.random((int)32, (boolean)true, (boolean)true) + "}";
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", USER_AGENT);
        con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(jsonString);
        wr.flush();
        wr.close();
        con.getResponseCode();
        con.disconnect();
    }

    static {
        updateContainer = new UpdateContainer();
        init = false;
        is_1_15 = !MCPVersion.getMCVersion().startsWith("1.14");
        targetMS = 9;
        compatibilityMode = false;
    }
}

