/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.MutableBoolean;
import de.pt400c.defaultsettings.ThreadRunnable;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import org.apache.logging.log4j.Level;

public class CommandDefaultSettings {
    private static ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)new StringTextComponent(TextFormatting.RED + "Please wait until the last request has finished"));

    protected static void register(FMLServerStartingEvent event) {
        LiteralArgumentBuilder literalargumentbuilder = Commands.func_197057_a((String)"defaultsettings");
        ((LiteralArgumentBuilder)literalargumentbuilder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"save").executes(command -> CommandDefaultSettings.saveProcess((CommandSource)command.getSource(), null))).then(Commands.func_197056_a((String)"argument", (ArgumentType)StringArgumentType.string()).executes(command -> CommandDefaultSettings.saveProcess((CommandSource)command.getSource(), StringArgumentType.getString((CommandContext)command, (String)"argument")))))).then(Commands.func_197057_a((String)"export-mode").executes(command -> CommandDefaultSettings.exportMode((CommandSource)command.getSource(), null)));
        event.getCommandDispatcher().register(literalargumentbuilder);
    }

    private static int exportMode(final CommandSource source, String argument) throws CommandSyntaxException {
        if (tpe.getQueue().size() > 0) {
            throw FAILED_EXCEPTION.create();
        }
        final boolean exportMode = FileUtil.exportMode();
        tpe.execute(new ThreadRunnable(source, null){

            @Override
            public void run() {
                try {
                    if (exportMode) {
                        FileUtil.restoreConfigs();
                        source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Successfully deactivated the export-mode"), true);
                    } else {
                        FileUtil.moveAllConfigs();
                        source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Successfully activated the export-mode"), true);
                    }
                }
                catch (IOException e) {
                    DefaultSettings.getInstance();
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while trying to move the configs:", (Throwable)e);
                    source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Couldn't switch the export-mode"), true);
                }
            }
        });
        return 0;
    }

    private static int saveProcess(final CommandSource source, String argument) throws CommandSyntaxException {
        if (tpe.getQueue().size() > 0) {
            throw FAILED_EXCEPTION.create();
        }
        if ((FileUtil.keysFileExist() || FileUtil.optionsFilesExist() || FileUtil.serversFileExists()) && (argument == null || !argument.equals("-o"))) {
            source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "These files already exist! If you want to overwrite"), true);
            source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "them, add the '-o' argument"), true);
            return 0;
        }
        MutableBoolean issue = new MutableBoolean(false);
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    FileUtil.saveKeys();
                    source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Successfully saved the key configuration"), true);
                    FileUtil.restoreKeys();
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                    source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Couldn't save the key configuration!"), true);
                    this.issue.setBoolean(true);
                }
            }
        });
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    FileUtil.saveOptions();
                    source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Successfully saved the default game options"), true);
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the default game options:", (Throwable)e);
                    source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Couldn't save the default game options!"), true);
                    this.issue.setBoolean(true);
                }
            }
        });
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    FileUtil.saveServers();
                    source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Successfully saved the server list"), true);
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                    source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Couldn't save the server list!"), true);
                    this.issue.setBoolean(true);
                }
                if (this.issue.getBoolean()) {
                    source.func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Please inspect the log files for further information!"), true);
                }
            }
        });
        return 0;
    }
}

