/*
 * Decompiled with CFR 0.152.
 */
package com.lordloss.kiwibirds.objects.blocks;

import com.lordloss.kiwibirds.entities.KiwiEntity;
import com.lordloss.kiwibirds.init.ModEntityTypes;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class KiwiEgg
extends Block {
    private static final VoxelShape EGG_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)11.0, (double)6.0, (double)11.0);
    public static final IntegerProperty HATCH = BlockStateProperties.field_208128_ac;

    public KiwiEgg(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.tryTrample(worldIn, pos, entityIn, 100);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!(entityIn instanceof ZombieEntity)) {
            this.tryTrample(worldIn, pos, entityIn, 3);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    private void tryTrample(World worldIn, BlockPos pos, Entity entity, int chance) {
        if (!this.canTrample(worldIn, entity)) {
            super.func_176199_a(worldIn, pos, entity);
        } else if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(chance) == 0) {
            this.removeEgg(worldIn, pos);
        }
    }

    private void removeEgg(World worldIn, BlockPos pos) {
        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + worldIn.field_73012_v.nextFloat() * 0.2f);
        worldIn.func_175655_b(pos, false);
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (this.canGrow((World)worldIn)) {
            int i = (Integer)state.func_177229_b((IProperty)HATCH);
            if (i < 2) {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203280_iy, SoundCategory.BLOCKS, 0.7f, 0.9f + rand.nextFloat() * 0.2f);
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 0.7f, 0.9f + rand.nextFloat() * 0.2f);
                worldIn.func_217377_a(pos, false);
                worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                KiwiEntity kiwi = (KiwiEntity)((EntityType)ModEntityTypes.KIWI_ENTITY.get()).func_200721_a((World)worldIn);
                kiwi.func_70873_a(-24000);
                kiwi.func_70012_b((double)pos.func_177958_n() + 0.3, pos.func_177956_o(), (double)pos.func_177952_p() + 0.3, 0.0f, 0.0f);
                worldIn.func_217376_c((Entity)kiwi);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            worldIn.func_217379_c(2005, pos, 0);
        }
    }

    private boolean canGrow(World worldIn) {
        return worldIn.field_73012_v.nextInt(15) == 0;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return super.func_196253_a(state, useContext);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        return super.func_196258_a(context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return EGG_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HATCH});
    }

    private boolean canTrample(World worldIn, Entity trampler) {
        if (trampler instanceof KiwiEntity || trampler instanceof ItemEntity) {
            return false;
        }
        return trampler instanceof LivingEntity && !(trampler instanceof PlayerEntity) ? ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)trampler) : true;
    }
}

