/*
 * Decompiled with CFR 0.152.
 */
package com.lordloss.kiwibirds.entities.goals;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class DigGroundGoal
extends Goal {
    private static final Predicate<BlockState> IS_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150349_c);
    private final MobEntity groundDiggerEntity;
    private final World entityWorld;
    private int diggingGroundTimer;

    public DigGroundGoal(MobEntity grassEaterEntityIn) {
        this.groundDiggerEntity = grassEaterEntityIn;
        this.entityWorld = grassEaterEntityIn.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.groundDiggerEntity.func_70681_au().nextInt(this.groundDiggerEntity.func_70631_g_() ? 500 : 1000) != 0) {
            return false;
        }
        BlockPos blockpos = new BlockPos((Entity)this.groundDiggerEntity);
        if (IS_GRASS.test(this.entityWorld.func_180495_p(blockpos))) {
            return true;
        }
        return this.entityWorld.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_196658_i;
    }

    public void func_75249_e() {
        this.diggingGroundTimer = 40;
        this.entityWorld.func_72960_a((Entity)this.groundDiggerEntity, (byte)10);
        this.groundDiggerEntity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.diggingGroundTimer = 0;
    }

    public boolean func_75253_b() {
        return this.diggingGroundTimer > 0;
    }

    public int getDigGroundTimer() {
        return this.diggingGroundTimer;
    }

    public void func_75246_d() {
        this.diggingGroundTimer = Math.max(0, this.diggingGroundTimer - 1);
        if (this.diggingGroundTimer == 4) {
            BlockPos blockpos = new BlockPos((Entity)this.groundDiggerEntity);
            if (IS_GRASS.test(this.entityWorld.func_180495_p(blockpos))) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.groundDiggerEntity)) {
                    this.entityWorld.func_175655_b(blockpos, false);
                }
                this.diggingTreasure();
                this.groundDiggerEntity.func_70615_aA();
            } else {
                BlockPos blockpos1 = blockpos.func_177977_b();
                if (this.entityWorld.func_180495_p(blockpos1).func_177230_c() == Blocks.field_196658_i) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.groundDiggerEntity)) {
                        this.entityWorld.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)Blocks.field_196658_i.func_176223_P()));
                        this.entityWorld.func_180501_a(blockpos1, Blocks.field_196658_i.func_176223_P(), 2);
                    }
                    this.diggingTreasure();
                    this.groundDiggerEntity.func_70615_aA();
                }
            }
        }
    }

    private void diggingTreasure() {
        Random rand = new Random();
        if (rand.nextInt(5) == 0) {
            int choices = rand.nextInt(3);
            block0 : switch (choices) {
                case 0: {
                    this.groundDiggerEntity.func_199703_a((IItemProvider)Items.field_222112_pR);
                    break;
                }
                case 1: {
                    this.groundDiggerEntity.func_199703_a((IItemProvider)Items.field_151145_ak);
                    break;
                }
                case 2: {
                    int seeds = rand.nextInt(4);
                    switch (seeds) {
                        case 0: {
                            this.groundDiggerEntity.func_199703_a((IItemProvider)Items.field_151014_N);
                            break block0;
                        }
                        case 1: {
                            this.groundDiggerEntity.func_199703_a((IItemProvider)Items.field_185163_cU);
                            break block0;
                        }
                        case 2: {
                            this.groundDiggerEntity.func_199703_a((IItemProvider)Items.field_151081_bc);
                            break block0;
                        }
                        case 3: {
                            this.groundDiggerEntity.func_199703_a((IItemProvider)Items.field_151080_bb);
                        }
                    }
                }
            }
        }
    }
}

