/*
 * Decompiled with CFR 0.152.
 */
package com.lordloss.kiwibirds.entities;

import com.lordloss.kiwibirds.entities.goals.DigGroundGoal;
import com.lordloss.kiwibirds.init.BlockInit;
import com.lordloss.kiwibirds.init.ModEntityTypes;
import com.lordloss.kiwibirds.init.SoundInit;
import com.lordloss.kiwibirds.util.Util;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KiwiEntity
extends AnimalEntity {
    private DigGroundGoal digGroundGoal;
    private int exampleTimer;
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU, Items.field_222112_pR});
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(KiwiEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(KiwiEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int isDigging;

    public KiwiEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        KiwiEntity entity = new KiwiEntity((EntityType<? extends AnimalEntity>)((EntityType)ModEntityTypes.KIWI_ENTITY.get()), this.field_70170_p);
        entity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.BREEDING, null, null);
        return entity;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.digGroundGoal = new DigGroundGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new KiwiMateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new KiwiLayEggGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.1, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)this.digGroundGoal);
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean func_204701_dC() {
        return super.func_204701_dC() && !this.hasEgg();
    }

    protected void func_70619_bc() {
        this.exampleTimer = this.digGroundGoal.getDigGroundTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.exampleTimer = Math.max(0, this.exampleTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.exampleTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.exampleTimer <= 0) {
            return 0.0f;
        }
        if (this.exampleTimer >= 4 && this.exampleTimer <= 36) {
            return 1.0f;
        }
        return this.exampleTimer < 4 ? ((float)this.exampleTimer - p_70894_1_) / 4.0f : -((float)(this.exampleTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.exampleTimer > 4 && this.exampleTimer <= 36) {
            float f = ((float)(this.exampleTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.exampleTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)SoundInit.AMBIENT.get();
    }

    static class KiwiMateGoal
    extends BreedGoal {
        private final KiwiEntity kiwi;

        KiwiMateGoal(KiwiEntity kiwi, double p_i48822_2_) {
            super((AnimalEntity)kiwi, p_i48822_2_);
            this.kiwi = kiwi;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.kiwi.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.kiwi.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class KiwiLayEggGoal
    extends Goal {
        private final KiwiEntity kiwi;

        KiwiLayEggGoal(KiwiEntity kiwi) {
            this.kiwi = kiwi;
        }

        public boolean func_75250_a() {
            return this.kiwi.hasEgg();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.kiwi.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos((Entity)this.kiwi);
            if (Util.checkBlock(blockpos, this.kiwi.field_70170_p, Blocks.field_150350_a, Blocks.field_150349_c, Blocks.field_196804_gh)) {
                if (this.kiwi.func_70089_S() && this.kiwi.isDigging() && this.kiwi.isDigging >= 1 && this.kiwi.isDigging % 5 == 0) {
                    this.kiwi.field_70170_p.func_217379_c(2001, blockpos, Block.func_196246_j((BlockState)this.kiwi.field_70170_p.func_180495_p(blockpos.func_177977_b())));
                }
                if (this.kiwi.isDigging < 1) {
                    this.kiwi.setDigging(true);
                } else if (this.kiwi.isDigging > 40) {
                    World world = this.kiwi.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_175656_a(blockpos, BlockInit.kiwi_egg.func_176223_P());
                    this.kiwi.setHasEgg(false);
                    this.kiwi.setDigging(false);
                }
                if (this.kiwi.isDigging()) {
                    this.kiwi.isDigging++;
                }
            } else if (this.kiwi.isDigging > 1) {
                this.kiwi.isDigging = 1;
            }
        }
    }
}

