/*
 * Decompiled with CFR 0.152.
 */
package com.lordloss.kiwibirds;

import com.lordloss.kiwibirds.init.BlockInit;
import com.lordloss.kiwibirds.init.ModEntityTypes;
import com.lordloss.kiwibirds.init.SoundInit;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="kiwibirds")
@Mod.EventBusSubscriber(modid="kiwibirds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class KiwiBirds {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "kiwibirds";
    public static KiwiBirds instance;
    public static final ResourceLocation EXAMPLE_DIM_TYPE;

    public KiwiBirds() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        SoundInit.SOUNDS.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    void setup(FMLCommonSetupEvent event) {
        try {
            new HashSet(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST)).forEach(b -> b.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry((EntityType)ModEntityTypes.KIWI_ENTITY.get(), 7, 2, 5)));
        }
        catch (ConcurrentModificationException e) {
            LOGGER.debug("Info: Concurrent modifications by another mod - trying to queue entity spawnlistEntrys");
            this.queueSpawns();
        }
    }

    void queueSpawns() {
        DeferredWorkQueue.runLater(() -> {
            try {
                new HashSet(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST)).forEach(b -> b.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry((EntityType)ModEntityTypes.KIWI_ENTITY.get(), 7, 2, 5)));
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        });
    }

    static {
        EXAMPLE_DIM_TYPE = new ResourceLocation(MOD_ID, "example");
    }

    public static class KiwiTab
    extends ItemGroup {
        public static final ItemGroup instance = new KiwiTab(ItemGroup.field_78032_a.length, "kiwitab");

        private KiwiTab(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)BlockInit.kiwi_egg);
        }
    }
}

