/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.traits.SimpleTrait;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.TimeUtils;

public final class PotionEffectTrait
extends SimpleTrait {
    public static final ITraitSerializer<PotionEffectTrait> SERIALIZER = new SimpleTrait.Serializer<PotionEffectTrait>(SilentGear.getId("potion_effect_trait"), PotionEffectTrait::new, PotionEffectTrait::readJson, PotionEffectTrait::readBuffer, PotionEffectTrait::writeBuffer);
    private final Map<String, List<PotionData>> potions = new HashMap<String, List<PotionData>>();

    private PotionEffectTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
        PlayerEntity player = context.getPlayer();
        if (player == null || !isEquipped) {
            return;
        }
        GearType gearType = ((ICoreItem)context.getGear().func_77973_b()).getGearType();
        this.potions.forEach((type, list) -> this.applyEffects(player, gearType, (String)type, (Iterable<PotionData>)list));
    }

    private void applyEffects(PlayerEntity player, GearType gearType, String type, Iterable<PotionData> effects) {
        if (gearType.matches(type) || "all".equals(type)) {
            int setPieceCount = this.getSetPieceCount(type, player);
            boolean hasFullSet = !"armor".equals(type) || setPieceCount >= 4;
            effects.forEach(d -> d.getEffect(setPieceCount, hasFullSet).ifPresent(arg_0 -> ((PlayerEntity)player).func_195064_c(arg_0)));
        }
    }

    private int getSetPieceCount(String type, PlayerEntity player) {
        if (!"armor".equals(type)) {
            return 1;
        }
        int count = 0;
        for (ItemStack stack : player.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof ICoreArmor) || !TraitHelper.hasTrait(stack, this)) continue;
            ++count;
        }
        return count;
    }

    private static void readJson(PotionEffectTrait trait, JsonObject json) {
        if (!json.has("potion_effects")) {
            throw new JsonParseException("Potion effect trait '" + trait.getId() + "' is missing 'potion_effects' object");
        }
        JsonObject jsonEffects = json.getAsJsonObject("potion_effects");
        for (Map.Entry entry : jsonEffects.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<PotionData> list = new ArrayList<PotionData>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(PotionData.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.potions.put(key, list);
        }
    }

    private static void readBuffer(PotionEffectTrait trait, PacketBuffer buffer) {
        trait.potions.clear();
        int gearTypeCount = buffer.readByte();
        for (int typeIndex = 0; typeIndex < gearTypeCount; ++typeIndex) {
            ArrayList<PotionData> list = new ArrayList<PotionData>();
            String gearType = buffer.func_218666_n();
            int potionDataCount = buffer.readByte();
            for (int potionIndex = 0; potionIndex < potionDataCount; ++potionIndex) {
                list.add(PotionData.read(buffer));
            }
            trait.potions.put(gearType, list);
        }
    }

    private static void writeBuffer(PotionEffectTrait trait, PacketBuffer buffer) {
        buffer.writeByte(trait.potions.size());
        for (Map.Entry<String, List<PotionData>> entry : trait.potions.entrySet()) {
            buffer.func_180714_a(entry.getKey());
            buffer.writeByte(entry.getValue().size());
            for (PotionData potionData : entry.getValue()) {
                potionData.write(buffer);
            }
        }
    }

    public static class PotionData {
        private boolean requiresFullSet;
        private ResourceLocation effectId;
        private int duration;
        private int[] levels;

        public static PotionData of(boolean requiresFullSet, Effect effect, int ... levels) {
            PotionData ret = new PotionData();
            ret.requiresFullSet = requiresFullSet;
            ret.effectId = Objects.requireNonNull(effect.getRegistryName());
            ret.duration = TimeUtils.ticksFromSeconds((float)PotionData.getDefaultDuration(ret.effectId));
            ret.levels = (int[])levels.clone();
            return ret;
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("full_set", Boolean.valueOf(this.requiresFullSet));
            json.addProperty("effect", this.effectId.toString());
            JsonArray levelsArray = new JsonArray();
            Arrays.stream(this.levels).forEach(arg_0 -> ((JsonArray)levelsArray).add(arg_0));
            json.add("level", (JsonElement)levelsArray);
            return json;
        }

        static PotionData from(JsonObject json) {
            PotionData ret = new PotionData();
            ret.requiresFullSet = JSONUtils.func_151209_a((JsonObject)json, (String)"full_set", (boolean)false);
            ret.effectId = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"effect", (String)"unknown"));
            float durationInSeconds = JSONUtils.func_151221_a((JsonObject)json, (String)"duration", (float)PotionData.getDefaultDuration(ret.effectId));
            ret.duration = TimeUtils.ticksFromSeconds((float)durationInSeconds);
            JsonElement elementLevel = json.get("level");
            if (elementLevel == null) {
                throw new JsonParseException("level element not found, should be either int or array");
            }
            if (elementLevel.isJsonPrimitive()) {
                ret.levels = new int[]{JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1)};
            } else if (elementLevel.isJsonArray()) {
                JsonArray array = elementLevel.getAsJsonArray();
                ret.levels = new int[array.size()];
                for (int i = 0; i < ret.levels.length; ++i) {
                    ret.levels[i] = array.get(i).getAsInt();
                }
            } else {
                throw new JsonParseException("Expected level to be int or array, was " + elementLevel.getClass().getSimpleName());
            }
            return ret;
        }

        static PotionData read(PacketBuffer buffer) {
            PotionData ret = new PotionData();
            ret.requiresFullSet = buffer.readBoolean();
            ret.effectId = buffer.func_192575_l();
            ret.duration = buffer.func_150792_a();
            ret.levels = buffer.func_186863_b();
            return ret;
        }

        void write(PacketBuffer buffer) {
            buffer.writeBoolean(this.requiresFullSet);
            buffer.func_192572_a(this.effectId);
            buffer.func_150787_b(this.duration);
            buffer.func_186875_a(this.levels);
        }

        private static float getDefaultDuration(ResourceLocation effectId) {
            return new ResourceLocation("night_vision").equals((Object)effectId) ? 15.5f : 1.5f;
        }

        Optional<EffectInstance> getEffect(int pieceCount, boolean hasFullSet) {
            if (this.requiresFullSet && !hasFullSet) {
                return Optional.empty();
            }
            Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(this.effectId);
            if (potion == null) {
                return Optional.empty();
            }
            int effectLevel = this.levels[MathHelper.func_76125_a((int)(pieceCount - 1), (int)0, (int)(this.levels.length - 1))];
            if (effectLevel < 1) {
                return Optional.empty();
            }
            return Optional.of(new EffectInstance(potion, this.duration, effectLevel - 1, true, false));
        }
    }
}

