/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.traits.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.item.FakeItemUseContext;

public class BlockPlacerTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("block_placer");
    public static final ITraitSerializer<BlockPlacerTrait> SERIALIZER = new SimpleTrait.Serializer<BlockPlacerTrait>(SERIALIZER_ID, BlockPlacerTrait::new, BlockPlacerTrait::readJson, BlockPlacerTrait::read, BlockPlacerTrait::write);
    private Block block;
    private int damageOnUse;
    private SoundEvent sound = SoundEvents.field_187638_cR;
    private float soundVolume = 1.0f;
    private float soundPitch = 1.0f;

    public BlockPlacerTrait(ResourceLocation name) {
        super(name, SERIALIZER);
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context, int traitLevel) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (!(world.field_72995_K || this.damageOnUse >= 1 && stack.func_77952_i() >= stack.func_77958_k() - this.damageOnUse - 1)) {
            ItemStack fakeBlockStack = new ItemStack((IItemProvider)this.block);
            ActionResultType result = fakeBlockStack.func_196084_a((ItemUseContext)new FakeItemUseContext(context, fakeBlockStack));
            if (result.func_226246_a_()) {
                if (this.damageOnUse > 0) {
                    GearHelper.attemptDamage(stack, this.damageOnUse, (LivingEntity)context.func_195999_j(), context.func_221531_n());
                }
                if (this.sound != null) {
                    float pitch = (float)((double)this.soundPitch * (1.0 + 0.05 * SilentGear.random.nextGaussian()));
                    world.func_184133_a(null, pos, this.sound, SoundCategory.BLOCKS, this.soundVolume, pitch);
                }
            }
            return result;
        }
        for (int i = 0; i < 5; ++i) {
            PhantomLight.spawnParticle((IWorld)world, pos.func_177972_a(context.func_196000_l()), SilentGear.random);
        }
        return ActionResultType.SUCCESS;
    }

    private static void readJson(BlockPlacerTrait trait, JsonObject json) {
        trait.block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"block")));
        trait.damageOnUse = JSONUtils.func_151203_m((JsonObject)json, (String)"damage_on_use");
        trait.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"sound")));
        trait.soundVolume = JSONUtils.func_151217_k((JsonObject)json, (String)"sound_volume");
        trait.soundPitch = JSONUtils.func_151217_k((JsonObject)json, (String)"sound_pitch");
    }

    private static void read(BlockPlacerTrait trait, PacketBuffer buffer) {
        trait.block = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        trait.damageOnUse = buffer.func_150792_a();
        trait.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.func_192575_l());
        trait.soundVolume = buffer.readFloat();
        trait.soundPitch = buffer.readFloat();
    }

    private static void write(BlockPlacerTrait trait, PacketBuffer buffer) {
        buffer.func_192572_a(Objects.requireNonNull(trait.block.getRegistryName()));
        buffer.func_150787_b(trait.damageOnUse);
        buffer.func_192572_a(Objects.requireNonNull(trait.sound.getRegistryName()));
        buffer.writeFloat(trait.soundVolume);
        buffer.writeFloat(trait.soundPitch);
    }
}

