/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartData;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.parts.PartTextureType;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.utils.EnumUtils;
import net.silentchaos512.utils.MathUtils;

public class CompoundPart
extends AbstractGearPart {
    public static final Serializer SERIALIZER = new Serializer((ResourceLocation)SilentGear.getId("compound_part"), CompoundPart::new);
    private GearType gearType = GearType.ALL;
    private PartType partType;
    private IPartPosition partPosition;

    public CompoundPart(ResourceLocation name) {
        super(name);
    }

    public static List<MaterialInstance> getMaterials(IPartData part) {
        return CompoundPartItem.getMaterials(part.getCraftingItem());
    }

    @Nullable
    public static MaterialInstance getPrimaryMaterial(IPartData part) {
        return CompoundPartItem.getPrimaryMaterial(part.getCraftingItem());
    }

    @Override
    public int getTier(PartData part) {
        MaterialInstance material = CompoundPart.getPrimaryMaterial(part);
        return material != null ? material.getTier(this.partType) : super.getTier(part);
    }

    @Override
    public PartType getType() {
        return this.partType;
    }

    @Override
    public IPartPosition getPartPosition() {
        return this.partPosition;
    }

    @Override
    public IPartSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public PartTextureType getLiteTexture(PartData part, ItemStack gear) {
        MaterialInstance material = CompoundPart.getPrimaryMaterial(part);
        if (material != null) {
            return material.getMaterial().getTexture(this.partType, gear);
        }
        return super.getLiteTexture(part, gear);
    }

    @Override
    public int getColor(PartData part, ItemStack gear, int animationFrame) {
        Item item = part.getCraftingItem().func_77973_b();
        if (!(item instanceof CompoundPartItem)) {
            return 0xFFFFFF;
        }
        return ((CompoundPartItem)item).getColor(part.getCraftingItem(), 0);
    }

    @Override
    public int getColor(PartData part, ItemStack gear, int layer, int animationFrame) {
        List<MaterialInstance> materials = CompoundPart.getMaterials(part);
        if (gear.func_77973_b() instanceof ICoreItem) {
            return ColorUtils.getBlendedColor((ICoreItem)gear.func_77973_b(), part.getType(), materials, layer);
        }
        return ColorUtils.getBlendedColor((CompoundPartItem)gear.func_77973_b(), materials, layer);
    }

    @Override
    public int getArmorColor(PartData part, ItemStack gear) {
        MaterialInstance material = CompoundPart.getPrimaryMaterial(part);
        if (material != null) {
            return material.getColor(part.getType(), gear);
        }
        return 0xFFFFFF;
    }

    @Override
    public ITextComponent getDisplayName(@Nullable PartData part, ItemStack gear) {
        if (part != null) {
            return part.getCraftingItem().func_200301_q();
        }
        return super.getDisplayName(null, gear);
    }

    @Override
    public ITextComponent getDisplayNamePrefix(@Nullable PartData part, ItemStack gear) {
        MaterialInstance material;
        if (part != null && (material = CompoundPart.getPrimaryMaterial(part)) != null) {
            return material.getMaterial().getDisplayNamePrefix(gear, this.partType);
        }
        return super.getDisplayNamePrefix(part, gear);
    }

    @Override
    public ITextComponent getMaterialName(@Nullable PartData part, ItemStack gear) {
        MaterialInstance material;
        if (part != null && (material = CompoundPart.getPrimaryMaterial(part)) != null) {
            return material.getDisplayName(this.partType, gear);
        }
        return super.getMaterialName(null, gear);
    }

    @Override
    public String getModelKey(PartData part) {
        String str = "{" + CompoundPart.getMaterials(part).stream().map(m -> SilentGear.shortenId(m.getMaterialId())).collect(Collectors.joining(",")) + "}";
        return super.getModelKey(part) + str;
    }

    @Override
    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat, PartData part) {
        float synergy;
        List<MaterialInstance> materials = CompoundPart.getMaterials(part);
        List<StatInstance> statMods = materials.stream().flatMap(m -> m.getStatModifiers(stat, this.partType, gear).stream()).collect(Collectors.toList());
        statMods.addAll(this.stats.get(stat));
        if (statMods.isEmpty()) {
            return statMods;
        }
        GetStatModifierEvent event = new GetStatModifierEvent(part, stat, statMods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>(event.getModifiers());
        for (StatInstance.Operation op : StatInstance.Operation.values()) {
            Collection modsForOp = ret.stream().filter(s -> s.getOp() == op).collect(Collectors.toList());
            if (modsForOp.size() <= 1) continue;
            StatInstance mod = CompoundPart.compressModifiers(modsForOp, op);
            ret.removeIf(inst -> inst.getOp() == op);
            ret.add(mod);
        }
        if (stat.doesSynergyApply() && !MathUtils.floatsEqual((float)(synergy = SynergyUtils.getSynergy(this.partType, materials, this.getTraits(gear, part))), (float)1.0f)) {
            for (int i = 0; i < ret.size(); ++i) {
                StatInstance oldMod = (StatInstance)ret.get(i);
                StatInstance newMod = new StatInstance(synergy * oldMod.getValue(), oldMod.getOp());
                ret.remove(i);
                ret.add(i, newMod);
            }
        }
        return ret;
    }

    private static StatInstance compressModifiers(Collection<StatInstance> mods, StatInstance.Operation operation) {
        if (operation == StatInstance.Operation.MAX) {
            return mods.stream().max((o1, o2) -> Float.compare(o1.getValue(), o2.getValue())).orElse(new StatInstance(0.0f, operation)).copy();
        }
        return StatInstance.getWeightedAverageMod(mods, operation);
    }

    @Override
    public List<PartTraitInstance> getTraits(ItemStack gear, PartData part) {
        ArrayList<PartTraitInstance> ret = new ArrayList<PartTraitInstance>(super.getTraits(gear, part));
        List<MaterialInstance> materials = CompoundPart.getMaterials(part);
        TraitHelper.getTraits(materials, this.partType, gear).forEach((trait, level) -> {
            PartTraitInstance inst = new PartTraitInstance((ITrait)trait, (int)level, (Collection<ITraitCondition>)Collections.emptyList());
            if (inst.conditionsMatch(materials, this.partType, gear)) {
                ret.add(inst);
            }
        });
        return ret;
    }

    @Override
    public PartData randomizeData(GearType gearType, int tier) {
        for (ItemStack stack : this.getMaterials().getNormal().func_193365_a()) {
            if (!(stack.func_77973_b() instanceof CompoundPartItem)) continue;
            int materialCount = CompoundPart.getRandomMaterialCount(this.partType);
            List<MaterialInstance> materials = this.getRandomMaterials(gearType, materialCount, tier);
            ItemStack craftingItem = ((CompoundPartItem)stack.func_77973_b()).create(materials);
            return PartData.of((IGearPart)this, craftingItem);
        }
        return super.randomizeData(gearType, tier);
    }

    @Override
    public boolean canAddToGear(ItemStack gear, PartData part) {
        GearType type = GearHelper.getType(gear);
        return type != null && type.matches(this.gearType);
    }

    private static int getRandomMaterialCount(PartType partType) {
        if (partType == PartType.MAIN) {
            int ret = 1;
            for (int i = 0; i < 3 && SilentGear.random.nextInt(100) < 70 - 30 * i; ++i) {
                ++ret;
            }
            return ret;
        }
        return SilentGear.random.nextInt(2) + 1;
    }

    private List<MaterialInstance> getRandomMaterials(GearType gearType, int count, int tier) {
        List matsOfTier = MaterialManager.getValues(tier == 0).stream().filter(m -> tier < 0 || tier == m.getTier(this.partType)).filter(m -> m.allowedInPart(this.partType) && m.isCraftingAllowed(this.partType, gearType)).collect(Collectors.toList());
        if (!matsOfTier.isEmpty()) {
            ArrayList<MaterialInstance> ret = new ArrayList<MaterialInstance>();
            for (int i = 0; i < count; ++i) {
                IMaterial material = (IMaterial)matsOfTier.get(SilentGear.random.nextInt(matsOfTier.size()));
                ret.add(CompoundPart.getRandomChildMaterial(material));
            }
            return ret;
        }
        if (tier == -1) {
            return Collections.emptyList();
        }
        return this.getRandomMaterials(gearType, count, -1);
    }

    private static MaterialInstance getRandomChildMaterial(IMaterial material) {
        List<IMaterial> children = MaterialManager.getChildren(material);
        if (children.isEmpty()) {
            return MaterialInstance.of(material);
        }
        return MaterialInstance.of(children.get(SilentGear.random.nextInt(children.size())));
    }

    @Override
    public String toString() {
        return "CompoundPart{id=" + this.getId() + ", partType=" + this.partType + '}';
    }

    public static class Serializer
    extends AbstractGearPart.Serializer<CompoundPart> {
        Serializer(ResourceLocation serializerId, Function<ResourceLocation, CompoundPart> function) {
            super(serializerId, function);
        }

        @Override
        public CompoundPart read(ResourceLocation id, JsonObject json) {
            CompoundPart part = (CompoundPart)super.read(id, json, false);
            String gearTypeStr = JSONUtils.func_151200_h((JsonObject)json, (String)"gear_type");
            part.gearType = GearType.get(gearTypeStr);
            if (part.gearType == null) {
                throw new JsonParseException("Unknown gear type: " + gearTypeStr);
            }
            part.partType = PartType.get(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"part_type")));
            part.partPosition = (IPartPosition)((Object)EnumUtils.byName((String)JSONUtils.func_151200_h((JsonObject)json, (String)"part_position"), (Enum)PartPositions.ANY));
            return part;
        }

        @Override
        public CompoundPart read(ResourceLocation id, PacketBuffer buffer) {
            CompoundPart part = (CompoundPart)super.read(id, buffer);
            part.gearType = GearType.get(buffer.func_218666_n());
            part.partType = PartType.get(buffer.func_192575_l());
            part.partPosition = (IPartPosition)((Object)EnumUtils.byName((String)buffer.func_218666_n(), (Enum)PartPositions.ANY));
            return part;
        }

        @Override
        public void write(PacketBuffer buffer, CompoundPart part) {
            super.write(buffer, part);
            buffer.func_180714_a(part.gearType.getName());
            buffer.func_192572_a(part.partType.getName());
            for (PartPositions pos : PartPositions.values()) {
                if (pos != part.partPosition) continue;
                buffer.func_180714_a(pos.name());
                break;
            }
        }
    }
}

