/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts.type;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.util.GearHelper;

public final class BowstringPart
extends AbstractGearPart {
    public BowstringPart(ResourceLocation name) {
        super(name);
    }

    @Override
    public PartType getType() {
        return PartType.BOWSTRING;
    }

    @Override
    public IPartPosition getPartPosition() {
        return PartPositions.BOWSTRING;
    }

    @Override
    public IPartSerializer<?> getSerializer() {
        return PartType.BOWSTRING.getSerializer();
    }

    @Override
    @Nullable
    public ResourceLocation getTexture(PartData part, ItemStack gear, GearType gearClass, IPartPosition position, int animationFrame) {
        if (!GearType.BOW.equals(gearClass)) {
            return null;
        }
        IPartDisplay props = this.getDisplayProperties(part, gear, animationFrame);
        String path = String.format("items/%s/%s_%s_%d", gearClass, position.getTexturePrefix(), props.getTextureSuffix(), animationFrame);
        return new ResourceLocation(props.getTextureDomain(), path);
    }

    @Override
    @Nullable
    public ResourceLocation getBrokenTexture(PartData part, ItemStack gear, GearType gearClass, IPartPosition position) {
        return null;
    }

    @Override
    public boolean canAddToGear(ItemStack gear, PartData part) {
        GearType type = GearHelper.getType(gear);
        return type != null && type.matches(GearType.RANGED_WEAPON);
    }
}

