/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartData;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.util.DataResource;

public class LazyPartData
implements IPartData {
    private final ResourceLocation partId;
    private final ItemStack craftingItem;

    public LazyPartData(ResourceLocation partId) {
        this(partId, ItemStack.field_190927_a);
    }

    @Deprecated
    public LazyPartData(ResourceLocation partId, MaterialGrade grade) {
        this(partId, grade, ItemStack.field_190927_a);
    }

    @Deprecated
    public LazyPartData(ResourceLocation partId, MaterialGrade grade, ItemStack craftingItem) {
        this.partId = partId;
        this.craftingItem = craftingItem;
    }

    public LazyPartData(ResourceLocation partId, ItemStack craftingItem) {
        this.partId = partId;
        this.craftingItem = craftingItem;
    }

    public static LazyPartData of(ResourceLocation partId) {
        return new LazyPartData(partId);
    }

    public static LazyPartData of(ResourceLocation partId, ItemStack craftingItem) {
        return new LazyPartData(partId, craftingItem);
    }

    public static LazyPartData of(DataResource<IGearPart> part, ItemStack craftingItem) {
        return new LazyPartData(part.getId(), craftingItem);
    }

    public static LazyPartData of(DataResource<IGearPart> part, CompoundPartItem partItem, List<LazyMaterialInstance> materials) {
        return new LazyPartData(part.getId(), partItem.create(materials));
    }

    public static LazyPartData of(DataResource<IGearPart> part, CompoundPartItem partItem, LazyMaterialInstance material) {
        return LazyPartData.of(part, partItem, Collections.singletonList(material));
    }

    @Override
    public ResourceLocation getPartId() {
        return this.partId;
    }

    @Override
    @Nullable
    public IGearPart getPart() {
        return PartManager.get(this.partId);
    }

    @Override
    public MaterialGrade getGrade() {
        return MaterialGrade.NONE;
    }

    @Override
    public ItemStack getCraftingItem() {
        IGearPart part;
        if (this.craftingItem.func_190926_b() && (part = this.getPart()) != null) {
            return PartData.of(part).getCraftingItem();
        }
        return this.craftingItem;
    }

    @Override
    public CompoundNBT write(CompoundNBT tags) {
        tags.func_74778_a("ID", this.partId.toString());
        if (!this.craftingItem.func_190926_b()) {
            tags.func_218657_a("Item", (INBT)this.craftingItem.func_77955_b(new CompoundNBT()));
        }
        return tags;
    }

    public boolean isValid() {
        return this.getPart() != null;
    }

    public static LazyPartData readJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            String key = json.getAsString();
            return new LazyPartData(new ResourceLocation(key));
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String key = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"part");
        String gradeStr = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"grade", (String)MaterialGrade.NONE.name());
        MaterialGrade grade = MaterialGrade.fromString(gradeStr);
        return new LazyPartData(new ResourceLocation(key), grade);
    }

    public static List<PartData> createPartList(Collection<LazyPartData> parts) {
        return parts.stream().filter(LazyPartData::isValid).map(p -> PartData.of(p.getPart())).collect(Collectors.toList());
    }
}

