/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class SyncMaterialCraftingItemsPacket {
    private final Map<ResourceLocation, Ingredient> craftingItems = new HashMap<ResourceLocation, Ingredient>();

    public SyncMaterialCraftingItemsPacket() {
        this((Map)Util.func_199748_a(() -> {
            HashMap map = new HashMap();
            MaterialManager.getValues().forEach(m -> map.put(m.getId(), m.getIngredient(PartType.MAIN)));
            return map;
        }));
    }

    public SyncMaterialCraftingItemsPacket(Map<ResourceLocation, Ingredient> craftingItems) {
        this.craftingItems.putAll(craftingItems);
    }

    @Nullable
    public Ingredient getIngredient(ResourceLocation materialId) {
        return this.craftingItems.get(materialId);
    }

    public static SyncMaterialCraftingItemsPacket fromBytes(PacketBuffer buffer) {
        SyncMaterialCraftingItemsPacket packet = new SyncMaterialCraftingItemsPacket();
        int count = buffer.func_150792_a();
        for (int i = 0; i < count; ++i) {
            packet.craftingItems.put(buffer.func_192575_l(), Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        return packet;
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_150787_b(this.craftingItems.size());
        this.craftingItems.forEach((id, ingredient) -> {
            buffer.func_192572_a(id);
            ingredient.func_199564_a(buffer);
        });
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        SilentGear.LOGGER.debug("Correcting material crafting items");
        MaterialManager.getValues().forEach(m -> m.updateIngredient(this));
        context.get().setPacketHandled(true);
    }
}

