/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.IContainerItem;
import net.silentchaos512.gear.item.ICycleItem;
import net.silentchaos512.gear.item.blueprint.AbstractBlueprintItem;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookContainer;
import net.silentchaos512.gear.network.KeyPressOnItemPacket;
import net.silentchaos512.gear.util.TextUtil;

public class BlueprintBookItem
extends Item
implements IBlueprint,
IContainerItem,
ICycleItem {
    private static final String NBT_SELECTED = "Selected";
    public static final int INVENTORY_SIZE = 54;

    public BlueprintBookItem(Item.Properties properties) {
        super(properties);
    }

    private static int clampSelectedSlot(int slot) {
        return MathHelper.func_76125_a((int)slot, (int)0, (int)53);
    }

    public static int getSelectedSlot(ItemStack book) {
        return BlueprintBookItem.clampSelectedSlot(book.func_196082_o().func_74762_e(NBT_SELECTED));
    }

    public static void setSelectedSlot(ItemStack book, int slot) {
        book.func_196082_o().func_74768_a(NBT_SELECTED, BlueprintBookItem.clampSelectedSlot(slot));
    }

    private ItemStack getSelectedItem(ItemStack book) {
        return this.getInventory(book).getStackInSlot(BlueprintBookItem.getSelectedSlot(book));
    }

    @Override
    public PartType getPartType(ItemStack stack) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.func_190926_b() && this.canStore(selected)) {
            return ((AbstractBlueprintItem)selected.func_77973_b()).getPartType(selected);
        }
        return PartType.MISC_UPGRADE;
    }

    @Override
    public GearType getGearType(ItemStack stack) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.func_190926_b() && this.canStore(selected)) {
            return ((AbstractBlueprintItem)selected.func_77973_b()).getGearType(selected);
        }
        return GearType.NONE;
    }

    @Override
    public int getInventorySize(ItemStack stack) {
        return 54;
    }

    @Override
    public boolean canStore(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof AbstractBlueprintItem && !((AbstractBlueprintItem)item).isSingleUse();
    }

    public static void openContainer(ServerPlayerEntity playerIn, ItemStack stack) {
        NetworkHooks.openGui((ServerPlayerEntity)playerIn, (INamedContainerProvider)new SimpleNamedContainerProvider((id, inv, z) -> new BlueprintBookContainer(id, inv, stack), (ITextComponent)new TranslationTextComponent("container.silentgear.blueprint_book", new Object[0])), buf -> buf.func_150788_a(stack));
    }

    @Override
    public void onCycleKeyPress(ItemStack stack, KeyPressOnItemPacket.Type direction) {
        int current = BlueprintBookItem.getSelectedSlot(stack);
        IItemHandler inventory = this.getInventory(stack);
        for (int i = 1; i <= inventory.getSlots(); ++i) {
            ItemStack inSlot;
            int index = current + (direction == KeyPressOnItemPacket.Type.CYCLE_BACK ? -i : i);
            if (index < 0) {
                index += inventory.getSlots();
            }
            if (index >= inventory.getSlots()) {
                index -= inventory.getSlots();
            }
            if ((inSlot = inventory.getStackInSlot(index)).func_190926_b()) continue;
            BlueprintBookItem.setSelectedSlot(stack, index);
            return;
        }
        if (this.getSelectedItem(stack).func_190926_b()) {
            BlueprintBookItem.setSelectedSlot(stack, 0);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            BlueprintBookItem.openContainer((ServerPlayerEntity)playerIn, stack);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            super.func_150895_a(group, items);
            ItemStack filled = new ItemStack((IItemProvider)this);
            IItemHandler inventory = this.getInventory(filled);
            ArrayList<Item> blueprints = new ArrayList<Item>(Registration.getItems(item -> this.canStore(new ItemStack((IItemProvider)item))));
            for (int i = 0; i < blueprints.size() && i < this.getInventorySize(filled); ++i) {
                inventory.insertItem(i, new ItemStack((IItemProvider)blueprints.get(i)), false);
            }
            this.saveInventory(filled, inventory);
            filled.func_200302_a((ITextComponent)new StringTextComponent("Fully-Loaded Blueprint Book"));
            items.add((Object)filled);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.func_190926_b()) {
            tooltip.add(TextUtil.translate("item", "blueprint_book.selected").func_211708_a(TextFormatting.AQUA).func_150257_a(selected.func_200301_q()));
        }
        tooltip.add(TextUtil.translate("item", "blueprint_book.keyHint", KeyTracker.CYCLE_BACK.func_197978_k(), KeyTracker.CYCLE_NEXT.func_197978_k()).func_211708_a(TextFormatting.GRAY));
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }
}

