/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.ForgeConfigSpec;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomTippedUpgrade;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.item.SlingshotAmmoItem;
import net.silentchaos512.gear.item.ToolHeadItem;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.item.gear.CoreAxe;
import net.silentchaos512.gear.item.gear.CoreBow;
import net.silentchaos512.gear.item.gear.CoreCrossbow;
import net.silentchaos512.gear.item.gear.CoreDagger;
import net.silentchaos512.gear.item.gear.CoreExcavator;
import net.silentchaos512.gear.item.gear.CoreHammer;
import net.silentchaos512.gear.item.gear.CoreKatana;
import net.silentchaos512.gear.item.gear.CoreLumberAxe;
import net.silentchaos512.gear.item.gear.CoreMachete;
import net.silentchaos512.gear.item.gear.CoreMattock;
import net.silentchaos512.gear.item.gear.CorePaxel;
import net.silentchaos512.gear.item.gear.CorePickaxe;
import net.silentchaos512.gear.item.gear.CoreShears;
import net.silentchaos512.gear.item.gear.CoreShield;
import net.silentchaos512.gear.item.gear.CoreShovel;
import net.silentchaos512.gear.item.gear.CoreSickle;
import net.silentchaos512.gear.item.gear.CoreSlingshot;
import net.silentchaos512.gear.item.gear.CoreSpear;
import net.silentchaos512.gear.item.gear.CoreSword;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.lib.util.TimeUtils;

public final class ModItems {
    public static final ItemRegistryObject<BlueprintPackageItem> BLUEPRINT_PACKAGE = ModItems.register("blueprint_package", () -> new BlueprintPackageItem(SilentGear.getId("starter_blueprints")));
    public static final ItemRegistryObject<BlueprintBookItem> BLUEPRINT_BOOK = ModItems.register("blueprint_book", () -> new BlueprintBookItem(ModItems.unstackableProps()));
    public static final ItemRegistryObject<PartBlueprintItem> ROD_BLUEPRINT = ModItems.registerPartBlueprint(PartType.ROD, false);
    public static final ItemRegistryObject<PartBlueprintItem> TIP_BLUEPRINT = ModItems.registerPartBlueprint(PartType.TIP, false);
    public static final ItemRegistryObject<PartBlueprintItem> GRIP_BLUEPRINT = ModItems.registerPartBlueprint(PartType.GRIP, false);
    public static final ItemRegistryObject<PartBlueprintItem> BINDING_BLUEPRINT = ModItems.registerPartBlueprint(PartType.BINDING, false);
    public static final ItemRegistryObject<PartBlueprintItem> BOWSTRING_BLUEPRINT = ModItems.registerPartBlueprint(PartType.BOWSTRING, false);
    public static final ItemRegistryObject<PartBlueprintItem> FLETCHING_BLUEPRINT = ModItems.registerPartBlueprint(PartType.FLETCHING, false);
    public static final ItemRegistryObject<GearBlueprintItem> SWORD_BLUEPRINT = ModItems.registerGearBlueprint(GearType.SWORD, false);
    public static final ItemRegistryObject<GearBlueprintItem> DAGGER_BLUEPRINT = ModItems.registerGearBlueprint(GearType.DAGGER, false);
    public static final ItemRegistryObject<GearBlueprintItem> KATANA_BLUEPRINT = ModItems.registerGearBlueprint(GearType.KATANA, false);
    public static final ItemRegistryObject<GearBlueprintItem> MACHETE_BLUEPRINT = ModItems.registerGearBlueprint(GearType.MACHETE, false);
    public static final ItemRegistryObject<GearBlueprintItem> SPEAR_BLUEPRINT = ModItems.registerGearBlueprint(GearType.SPEAR, false);
    public static final ItemRegistryObject<GearBlueprintItem> PICKAXE_BLUEPRINT = ModItems.registerGearBlueprint(GearType.PICKAXE, false);
    public static final ItemRegistryObject<GearBlueprintItem> SHOVEL_BLUEPRINT = ModItems.registerGearBlueprint(GearType.SHOVEL, false);
    public static final ItemRegistryObject<GearBlueprintItem> AXE_BLUEPRINT = ModItems.registerGearBlueprint(GearType.AXE, false);
    public static final ItemRegistryObject<GearBlueprintItem> PAXEL_BLUEPRINT = ModItems.registerGearBlueprint(GearType.PAXEL, false);
    public static final ItemRegistryObject<GearBlueprintItem> HAMMER_BLUEPRINT = ModItems.registerGearBlueprint(GearType.HAMMER, false);
    public static final ItemRegistryObject<GearBlueprintItem> EXCAVATOR_BLUEPRINT = ModItems.registerGearBlueprint(GearType.EXCAVATOR, false);
    public static final ItemRegistryObject<GearBlueprintItem> LUMBER_AXE_BLUEPRINT = ModItems.registerGearBlueprint(GearType.LUMBER_AXE, false);
    public static final ItemRegistryObject<GearBlueprintItem> MATTOCK_BLUEPRINT = ModItems.registerGearBlueprint(GearType.MATTOCK, false);
    public static final ItemRegistryObject<GearBlueprintItem> SICKLE_BLUEPRINT = ModItems.registerGearBlueprint(GearType.SICKLE, false);
    public static final ItemRegistryObject<GearBlueprintItem> SHEARS_BLUEPRINT = ModItems.registerGearBlueprint(GearType.SHEARS, false);
    public static final ItemRegistryObject<GearBlueprintItem> BOW_BLUEPRINT = ModItems.registerGearBlueprint(GearType.BOW, false);
    public static final ItemRegistryObject<GearBlueprintItem> CROSSBOW_BLUEPRINT = ModItems.registerGearBlueprint(GearType.CROSSBOW, false);
    public static final ItemRegistryObject<GearBlueprintItem> SLINGSHOT_BLUEPRINT = ModItems.registerGearBlueprint(GearType.SLINGSHOT, false);
    public static final ItemRegistryObject<GearBlueprintItem> SHIELD_BLUEPRINT = ModItems.registerGearBlueprint(GearType.SHIELD, false);
    public static final ItemRegistryObject<GearBlueprintItem> HELMET_BLUEPRINT = ModItems.registerGearBlueprint(GearType.HELMET, false);
    public static final ItemRegistryObject<GearBlueprintItem> CHESTPLATE_BLUEPRINT = ModItems.registerGearBlueprint(GearType.CHESTPLATE, false);
    public static final ItemRegistryObject<GearBlueprintItem> LEGGINGS_BLUEPRINT = ModItems.registerGearBlueprint(GearType.LEGGINGS, false);
    public static final ItemRegistryObject<GearBlueprintItem> BOOTS_BLUEPRINT = ModItems.registerGearBlueprint(GearType.BOOTS, false);
    public static final ItemRegistryObject<PartBlueprintItem> ROD_TEMPLATE = ModItems.registerPartBlueprint(PartType.ROD, true);
    public static final ItemRegistryObject<PartBlueprintItem> TIP_TEMPLATE = ModItems.registerPartBlueprint(PartType.TIP, true);
    public static final ItemRegistryObject<PartBlueprintItem> GRIP_TEMPLATE = ModItems.registerPartBlueprint(PartType.GRIP, true);
    public static final ItemRegistryObject<PartBlueprintItem> BINDING_TEMPLATE = ModItems.registerPartBlueprint(PartType.BINDING, true);
    public static final ItemRegistryObject<PartBlueprintItem> BOWSTRING_TEMPLATE = ModItems.registerPartBlueprint(PartType.BOWSTRING, true);
    public static final ItemRegistryObject<PartBlueprintItem> FLETCHING_TEMPLATE = ModItems.registerPartBlueprint(PartType.FLETCHING, true);
    public static final ItemRegistryObject<GearBlueprintItem> SWORD_TEMPLATE = ModItems.registerGearBlueprint(GearType.SWORD, true);
    public static final ItemRegistryObject<GearBlueprintItem> DAGGER_TEMPLATE = ModItems.registerGearBlueprint(GearType.DAGGER, true);
    public static final ItemRegistryObject<GearBlueprintItem> KATANA_TEMPLATE = ModItems.registerGearBlueprint(GearType.KATANA, true);
    public static final ItemRegistryObject<GearBlueprintItem> MACHETE_TEMPLATE = ModItems.registerGearBlueprint(GearType.MACHETE, true);
    public static final ItemRegistryObject<GearBlueprintItem> SPEAR_TEMPLATE = ModItems.registerGearBlueprint(GearType.SPEAR, true);
    public static final ItemRegistryObject<GearBlueprintItem> PICKAXE_TEMPLATE = ModItems.registerGearBlueprint(GearType.PICKAXE, true);
    public static final ItemRegistryObject<GearBlueprintItem> SHOVEL_TEMPLATE = ModItems.registerGearBlueprint(GearType.SHOVEL, true);
    public static final ItemRegistryObject<GearBlueprintItem> AXE_TEMPLATE = ModItems.registerGearBlueprint(GearType.AXE, true);
    public static final ItemRegistryObject<GearBlueprintItem> PAXEL_TEMPLATE = ModItems.registerGearBlueprint(GearType.PAXEL, true);
    public static final ItemRegistryObject<GearBlueprintItem> HAMMER_TEMPLATE = ModItems.registerGearBlueprint(GearType.HAMMER, true);
    public static final ItemRegistryObject<GearBlueprintItem> EXCAVATOR_TEMPLATE = ModItems.registerGearBlueprint(GearType.EXCAVATOR, true);
    public static final ItemRegistryObject<GearBlueprintItem> LUMBER_AXE_TEMPLATE = ModItems.registerGearBlueprint(GearType.LUMBER_AXE, true);
    public static final ItemRegistryObject<GearBlueprintItem> MATTOCK_TEMPLATE = ModItems.registerGearBlueprint(GearType.MATTOCK, true);
    public static final ItemRegistryObject<GearBlueprintItem> SICKLE_TEMPLATE = ModItems.registerGearBlueprint(GearType.SICKLE, true);
    public static final ItemRegistryObject<GearBlueprintItem> SHEARS_TEMPLATE = ModItems.registerGearBlueprint(GearType.SHEARS, true);
    public static final ItemRegistryObject<GearBlueprintItem> BOW_TEMPLATE = ModItems.registerGearBlueprint(GearType.BOW, true);
    public static final ItemRegistryObject<GearBlueprintItem> CROSSBOW_TEMPLATE = ModItems.registerGearBlueprint(GearType.CROSSBOW, true);
    public static final ItemRegistryObject<GearBlueprintItem> SLINGSHOT_TEMPLATE = ModItems.registerGearBlueprint(GearType.SLINGSHOT, true);
    public static final ItemRegistryObject<GearBlueprintItem> SHIELD_TEMPLATE = ModItems.registerGearBlueprint(GearType.SHIELD, true);
    public static final ItemRegistryObject<GearBlueprintItem> HELMET_TEMPLATE = ModItems.registerGearBlueprint(GearType.HELMET, true);
    public static final ItemRegistryObject<GearBlueprintItem> CHESTPLATE_TEMPLATE = ModItems.registerGearBlueprint(GearType.CHESTPLATE, true);
    public static final ItemRegistryObject<GearBlueprintItem> LEGGINGS_TEMPLATE = ModItems.registerGearBlueprint(GearType.LEGGINGS, true);
    public static final ItemRegistryObject<GearBlueprintItem> BOOTS_TEMPLATE = ModItems.registerGearBlueprint(GearType.BOOTS, true);
    public static final ItemRegistryObject<ToolHeadItem> SWORD_BLADE = ModItems.registerCompoundPart("sword_blade", () -> new ToolHeadItem(GearType.SWORD, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> DAGGER_BLADE = ModItems.registerCompoundPart("dagger_blade", () -> new ToolHeadItem(GearType.DAGGER, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> KATANA_BLADE = ModItems.registerCompoundPart("katana_blade", () -> new ToolHeadItem(GearType.KATANA, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> MACHETE_BLADE = ModItems.registerCompoundPart("machete_blade", () -> new ToolHeadItem(GearType.MACHETE, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> SPEAR_TIP = ModItems.registerCompoundPart("spear_tip", () -> new ToolHeadItem(GearType.SPEAR, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> PICKAXE_HEAD = ModItems.registerCompoundPart("pickaxe_head", () -> new ToolHeadItem(GearType.PICKAXE, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> SHOVEL_HEAD = ModItems.registerCompoundPart("shovel_head", () -> new ToolHeadItem(GearType.SHOVEL, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> AXE_HEAD = ModItems.registerCompoundPart("axe_head", () -> new ToolHeadItem(GearType.AXE, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> PAXEL_HEAD = ModItems.registerCompoundPart("paxel_head", () -> new ToolHeadItem(GearType.PAXEL, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> HAMMER_HEAD = ModItems.registerCompoundPart("hammer_head", () -> new ToolHeadItem(GearType.HAMMER, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> EXCAVATOR_HEAD = ModItems.registerCompoundPart("excavator_head", () -> new ToolHeadItem(GearType.EXCAVATOR, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> LUMBER_AXE_HEAD = ModItems.registerCompoundPart("lumber_axe_head", () -> new ToolHeadItem(GearType.LUMBER_AXE, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> MATTOCK_HEAD = ModItems.registerCompoundPart("mattock_head", () -> new ToolHeadItem(GearType.MATTOCK, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> SICKLE_BLADE = ModItems.registerCompoundPart("sickle_blade", () -> new ToolHeadItem(GearType.SICKLE, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> SHEARS_BLADES = ModItems.registerCompoundPart("shears_blades", () -> new ToolHeadItem(GearType.SHEARS, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> BOW_LIMBS = ModItems.registerCompoundPart("bow_limbs", () -> new ToolHeadItem(GearType.BOW, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> CROSSBOW_LIMBS = ModItems.registerCompoundPart("crossbow_limbs", () -> new ToolHeadItem(GearType.CROSSBOW, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> SLINGSHOT_LIMBS = ModItems.registerCompoundPart("slingshot_limbs", () -> new ToolHeadItem(GearType.SLINGSHOT, ModItems.unstackableProps()));
    public static final ItemRegistryObject<ToolHeadItem> SHIELD_PLATE = ModItems.registerCompoundPart("shield_plate", () -> new ToolHeadItem(GearType.SHIELD, new Item.Properties().func_200917_a(1)));
    public static final ItemRegistryObject<ToolHeadItem> ARMOR_BODY = ModItems.registerCompoundPart("armor_body", () -> new ToolHeadItem(GearType.ARMOR, new Item.Properties().func_200917_a(1)));
    public static final ItemRegistryObject<CompoundPartItem> ROD = ModItems.registerCompoundPart("rod", () -> new CompoundPartItem(PartType.ROD, ModItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> LONG_ROD = ModItems.registerCompoundPart("long_rod", () -> new CompoundPartItem(PartType.ROD, ModItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> TIP = ModItems.registerCompoundPart("tip", () -> new CompoundPartItem(PartType.TIP, ModItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> GRIP = ModItems.registerCompoundPart("grip", () -> new CompoundPartItem(PartType.GRIP, ModItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> BINDING = ModItems.registerCompoundPart("binding", () -> new CompoundPartItem(PartType.BINDING, ModItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> BOWSTRING = ModItems.registerCompoundPart("bowstring", () -> new CompoundPartItem(PartType.BOWSTRING, ModItems.baseProps()));
    public static final ItemRegistryObject<CompoundPartItem> FLETCHING = ModItems.registerCompoundPart("fletching", () -> new CompoundPartItem(PartType.FLETCHING, ModItems.baseProps()));
    public static final ItemRegistryObject<Item> CRUDE_REPAIR_KIT = ModItems.register("crude_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitCrudeCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitCrudeEfficiency).get(), ModItems.unstackableProps()));
    public static final ItemRegistryObject<Item> STURDY_REPAIR_KIT = ModItems.register("sturdy_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitSturdyCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitSturdyEfficiency).get(), ModItems.unstackableProps()));
    public static final ItemRegistryObject<Item> CRIMSON_REPAIR_KIT = ModItems.register("crimson_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitCrimsonCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitCrimsonEfficiency).get(), ModItems.unstackableProps()));
    public static final ItemRegistryObject<Item> AZURE_REPAIR_KIT = ModItems.register("azure_repair_kit", () -> new RepairKitItem(() -> ((ForgeConfigSpec.IntValue)Config.Common.repairKitAzureCapacity).get(), () -> ((ForgeConfigSpec.DoubleValue)Config.Common.repairKitAzureEfficiency).get(), ModItems.unstackableProps()));
    public static final ItemRegistryObject<FragmentItem> FRAGMENT;
    public static final ItemRegistryObject<CustomTippedUpgrade> CUSTOM_TIPPED_UPGRADE;
    public static final ItemRegistryObject<Item> PEBBLE;
    public static final ItemRegistryObject<BlockNamedItem> FLAXSEEDS;
    public static final ItemRegistryObject<Item> NETHER_BANANA;
    public static final ItemRegistryObject<Item> GOLDEN_NETHER_BANANA;
    public static final ItemRegistryObject<CoreSword> SWORD;
    public static final ItemRegistryObject<CoreDagger> DAGGER;
    public static final ItemRegistryObject<CoreKatana> KATANA;
    public static final ItemRegistryObject<CoreMachete> MACHETE;
    public static final ItemRegistryObject<CoreSpear> SPEAR;
    public static final ItemRegistryObject<CorePickaxe> PICKAXE;
    public static final ItemRegistryObject<CoreShovel> SHOVEL;
    public static final ItemRegistryObject<CoreAxe> AXE;
    public static final ItemRegistryObject<CorePaxel> PAXEL;
    public static final ItemRegistryObject<CoreHammer> HAMMER;
    public static final ItemRegistryObject<CoreExcavator> EXCAVATOR;
    public static final ItemRegistryObject<CoreLumberAxe> LUMBER_AXE;
    public static final ItemRegistryObject<CoreMattock> MATTOCK;
    public static final ItemRegistryObject<CoreSickle> SICKLE;
    public static final ItemRegistryObject<CoreShears> SHEARS;
    public static final ItemRegistryObject<CoreBow> BOW;
    public static final ItemRegistryObject<CoreCrossbow> CROSSBOW;
    public static final ItemRegistryObject<CoreSlingshot> SLINGSHOT;
    public static final ItemRegistryObject<CoreShield> SHIELD;
    public static final ItemRegistryObject<CoreArmor> HELMET;
    public static final ItemRegistryObject<CoreArmor> CHESTPLATE;
    public static final ItemRegistryObject<CoreArmor> LEGGINGS;
    public static final ItemRegistryObject<CoreArmor> BOOTS;

    private ModItems() {
    }

    static void register() {
    }

    private static Item.Properties baseProps() {
        return new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP);
    }

    private static Item.Properties unstackableProps() {
        return ModItems.baseProps().func_200917_a(1);
    }

    private static <T extends Item> ItemRegistryObject<T> register(String name, Supplier<T> item) {
        return new ItemRegistryObject(Registration.ITEMS.register(name, item));
    }

    private static <T extends CompoundPartItem> ItemRegistryObject<T> registerCompoundPart(String name, Supplier<T> item) {
        return ModItems.register(name, item);
    }

    private static ItemRegistryObject<GearBlueprintItem> registerGearBlueprint(GearType gearType, boolean singleUse) {
        String name = (singleUse ? "template" : "blueprint") + "_" + gearType.getName();
        return ModItems.register(name, () -> new GearBlueprintItem(gearType, singleUse, ModItems.baseProps()));
    }

    private static ItemRegistryObject<PartBlueprintItem> registerPartBlueprint(PartType partType, boolean singleUse) {
        String name = (singleUse ? "template" : "blueprint") + "_" + partType.getName().func_110623_a();
        return ModItems.register(name, () -> new PartBlueprintItem(partType, singleUse, ModItems.baseProps()));
    }

    static {
        CraftingItems.register(Registration.ITEMS);
        FRAGMENT = ModItems.register("fragment", () -> new FragmentItem(ModItems.baseProps()));
        CUSTOM_TIPPED_UPGRADE = ModItems.register("custom_tipped_upgrade", CustomTippedUpgrade::new);
        PEBBLE = ModItems.register("pebble", () -> new SlingshotAmmoItem(ModItems.baseProps()));
        FLAXSEEDS = ModItems.register("flaxseeds", () -> new BlockNamedItem((Block)ModBlocks.FLAX_PLANT.get(), ModItems.baseProps()));
        NETHER_BANANA = ModItems.register("nether_banana", () -> new Item(ModItems.baseProps().func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.4f).func_221453_d())));
        GOLDEN_NETHER_BANANA = ModItems.register("golden_nether_banana", () -> new Item(ModItems.baseProps().func_221540_a(new Food.Builder().func_221456_a(10).func_221454_a(1.0f).func_221455_b().effect(() -> new EffectInstance(Effects.field_76426_n, TimeUtils.ticksFromMinutes((float)10.0f)), 1.0f).effect(() -> new EffectInstance(Effects.field_76429_m, TimeUtils.ticksFromMinutes((float)5.0f)), 1.0f).effect(() -> new EffectInstance(Effects.field_76428_l, TimeUtils.ticksFromSeconds((float)10.0f)), 1.0f).func_221453_d())));
        SWORD = ModItems.register("sword", () -> new CoreSword());
        DAGGER = ModItems.register("dagger", () -> new CoreDagger());
        KATANA = ModItems.register("katana", () -> new CoreKatana());
        MACHETE = ModItems.register("machete", () -> new CoreMachete());
        SPEAR = ModItems.register("spear", () -> new CoreSpear());
        PICKAXE = ModItems.register("pickaxe", () -> new CorePickaxe());
        SHOVEL = ModItems.register("shovel", () -> new CoreShovel());
        AXE = ModItems.register("axe", () -> new CoreAxe());
        PAXEL = ModItems.register("paxel", () -> new CorePaxel());
        HAMMER = ModItems.register("hammer", () -> new CoreHammer());
        EXCAVATOR = ModItems.register("excavator", () -> new CoreExcavator());
        LUMBER_AXE = ModItems.register("lumber_axe", () -> new CoreLumberAxe());
        MATTOCK = ModItems.register("mattock", () -> new CoreMattock());
        SICKLE = ModItems.register("sickle", () -> new CoreSickle());
        SHEARS = ModItems.register("shears", () -> new CoreShears());
        BOW = ModItems.register("bow", () -> new CoreBow());
        CROSSBOW = ModItems.register("crossbow", () -> new CoreCrossbow());
        SLINGSHOT = ModItems.register("slingshot", () -> new CoreSlingshot());
        SHIELD = ModItems.register("shield", () -> new CoreShield());
        HELMET = ModItems.register("helmet", () -> new CoreArmor(EquipmentSlotType.HEAD));
        CHESTPLATE = ModItems.register("chestplate", () -> new CoreArmor(EquipmentSlotType.CHEST));
        LEGGINGS = ModItems.register("leggings", () -> new CoreArmor(EquipmentSlotType.LEGS));
        BOOTS = ModItems.register("boots", () -> new CoreArmor(EquipmentSlotType.FEET));
    }
}

