/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.PartTextureType;

public class SimplePartAdapterMaterial
implements IMaterial {
    private final ResourceLocation materialId;
    private final Map<PartType, IGearPart> parts = new HashMap<PartType, IGearPart>();
    private final Map<PartType, IMaterialLayerList> display = new HashMap<PartType, IMaterialLayerList>();

    public SimplePartAdapterMaterial(ResourceLocation materialId) {
        this.materialId = materialId;
    }

    public void addPart(IGearPart part) {
        if (this.parts.containsKey(part.getType())) {
            throw new IllegalArgumentException("Already have part of type " + part.getType() + " for adapter material " + this.materialId);
        }
        this.parts.put(part.getType(), part);
        this.display.put(part.getType(), MaterialLayerList.DEFAULT);
    }

    private Optional<IGearPart> getPart(PartType partType) {
        return Optional.ofNullable(this.parts.get(partType));
    }

    @Override
    public String getPackName() {
        return "AUTO_ADAPTER";
    }

    @Override
    public ResourceLocation getId() {
        return this.materialId;
    }

    @Override
    public IMaterialSerializer<?> getSerializer() {
        return MaterialSerializers.SIMPLE_ADAPTER;
    }

    @Override
    @Nullable
    public IMaterial getParent() {
        return null;
    }

    @Override
    public int getTier(PartType partType) {
        return this.getPart(partType).map(IGearPart::getTier).orElse(-1);
    }

    @Override
    public Ingredient getIngredient(PartType partType) {
        IGearPart part = this.getPart(PartType.MAIN).orElse(this.getPart(partType).orElse(null));
        return part != null ? part.getMaterials().getNormal() : Ingredient.field_193370_a;
    }

    @Override
    public boolean canSalvage() {
        return true;
    }

    @Override
    public Set<PartType> getPartTypes() {
        return this.parts.keySet();
    }

    @Override
    public boolean allowedInPart(PartType partType) {
        return this.getPart(partType).isPresent();
    }

    @Override
    public void retainData(@Nullable IMaterial oldMaterial) {
    }

    @Override
    public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType, ItemStack gear) {
        return this.getPart(partType).map(p -> p.getStatModifiers(gear, stat, PartData.of(p))).orElse(Collections.emptyList());
    }

    @Override
    public Collection<PartTraitInstance> getTraits(PartType partType, ItemStack gear) {
        return this.getPart(partType).map(p -> p.getTraits(gear, PartData.of(p))).orElse(Collections.emptyList());
    }

    @Override
    public boolean isCraftingAllowed(PartType partType, GearType gearType) {
        return true;
    }

    @Override
    public int getPrimaryColor(ItemStack gear, PartType partType) {
        return this.getPart(partType).map(p -> PartData.of(p).getColor(gear, 0)).orElse(0xFFFFFF);
    }

    @Override
    public PartTextureType getTexture(PartType partType, ItemStack gear) {
        return this.getPart(partType).map(p -> p.getLiteTexture(PartData.of(p), gear)).orElse(PartTextureType.ABSENT);
    }

    @Override
    public IMaterialLayerList getMaterialDisplay(ItemStack gear, PartType partType) {
        return this.display.getOrDefault(partType, MaterialLayerList.DEFAULT);
    }

    @Override
    public ITextComponent getDisplayName(PartType partType, ItemStack gear) {
        return this.getPart(partType).map(p -> p.getDisplayName(PartData.of(p), gear)).orElse((ITextComponent)new StringTextComponent("INVALID"));
    }

    @Override
    @Nullable
    public ITextComponent getDisplayNamePrefix(ItemStack gear, PartType partType) {
        return null;
    }

    @Override
    public void updateIngredient(SyncMaterialCraftingItemsPacket msg) {
    }

    @Override
    public Optional<Ingredient> getPartSubstitute(PartType partType) {
        return Optional.empty();
    }

    @Override
    public boolean hasPartSubstitutes() {
        return false;
    }

    public static class Serializer
    implements IMaterialSerializer<SimplePartAdapterMaterial> {
        @Override
        public SimplePartAdapterMaterial deserialize(ResourceLocation id, String packName, JsonObject json) {
            return new SimplePartAdapterMaterial(id);
        }

        @Override
        public SimplePartAdapterMaterial read(ResourceLocation id, PacketBuffer buffer) {
            SimplePartAdapterMaterial ret = new SimplePartAdapterMaterial(id);
            int partCount = buffer.readByte();
            for (int i = 0; i < partCount; ++i) {
                ResourceLocation partId = buffer.func_192575_l();
                IGearPart part = PartManager.get(partId);
                if (part != null) {
                    ret.addPart(part);
                    continue;
                }
                SilentGear.LOGGER.warn("Read unknown gear part '{}' in adapter material '{}'", (Object)partId, (Object)id);
            }
            return ret;
        }

        @Override
        public void write(PacketBuffer buffer, SimplePartAdapterMaterial material) {
            buffer.writeByte(material.parts.size());
            material.parts.values().forEach(part -> buffer.func_192572_a(part.getId()));
        }

        @Override
        public ResourceLocation getName() {
            return SilentGear.getId("simple_adapter");
        }
    }
}

