/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.parts.PartTextureType;

public final class PartMaterial
implements IMaterial {
    private static final StatModifierMap EMPTY_STAT_MAP = new StatModifierMap();
    private final ResourceLocation materialId;
    @Nullable
    private ResourceLocation parent;
    private final String packName;
    private Ingredient ingredient = Ingredient.field_193370_a;
    private boolean visible = true;
    private int tier = -1;
    private boolean canSalvage = true;
    private final Map<PartType, StatModifierMap> stats = new LinkedHashMap<PartType, StatModifierMap>();
    private final Map<PartType, List<PartTraitInstance>> traits = new LinkedHashMap<PartType, List<PartTraitInstance>>();
    private ITextComponent displayName;
    @Nullable
    private ITextComponent namePrefix = null;
    private final Map<String, MaterialLayerList> display = new HashMap<String, MaterialLayerList>();
    private final List<String> blacklistedGearTypes = new ArrayList<String>();
    private Map<PartType, Ingredient> partSubstitutes;

    private PartMaterial(ResourceLocation id, String packName) {
        this.materialId = id;
        this.packName = packName;
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public ResourceLocation getId() {
        return this.materialId;
    }

    @Override
    public IMaterialSerializer<?> getSerializer() {
        return MaterialSerializers.STANDARD;
    }

    @Override
    @Nullable
    public IMaterial getParent() {
        if (this.parent != null) {
            return MaterialManager.get(this.parent);
        }
        return null;
    }

    @Override
    public int getTier(PartType partType) {
        if (this.tier < 0 && this.getParent() != null) {
            return this.getParent().getTier(partType);
        }
        return this.tier;
    }

    @Override
    public Ingredient getIngredient(PartType partType) {
        return this.ingredient;
    }

    @Override
    public Optional<Ingredient> getPartSubstitute(PartType partType) {
        return Optional.ofNullable(this.partSubstitutes.get(partType));
    }

    @Override
    public boolean hasPartSubstitutes() {
        return !this.partSubstitutes.isEmpty();
    }

    @Override
    public boolean canSalvage() {
        return this.canSalvage;
    }

    @Override
    public Set<PartType> getPartTypes() {
        return Sets.union(this.stats.keySet(), this.getParentOptional().map(m -> new LinkedHashSet<PartType>(m.getPartTypes())).orElse(Collections.emptySet()));
    }

    @Override
    public boolean allowedInPart(PartType partType) {
        return this.stats.containsKey(partType) || this.getParent() != null && this.getParent().allowedInPart(partType);
    }

    @Override
    public void retainData(@Nullable IMaterial oldMaterial) {
        if (oldMaterial instanceof PartMaterial) {
            this.traits.clear();
            ((PartMaterial)oldMaterial).traits.forEach(this.traits::put);
        }
    }

    @Override
    public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType, ItemStack gear) {
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>(this.stats.getOrDefault(partType, EMPTY_STAT_MAP).get(stat));
        if (this.getParent() != null) {
            ret.addAll(this.getParent().getStatModifiers(stat, partType, gear));
        }
        return ret;
    }

    public List<PartTraitInstance> getTraits(PartType partType, ItemStack gear) {
        ArrayList<PartTraitInstance> ret = new ArrayList<PartTraitInstance>(this.traits.getOrDefault(partType, Collections.emptyList()));
        if (this.getParent() != null) {
            ret.addAll(this.getParent().getTraits(partType, gear));
        }
        return ret;
    }

    @Override
    public boolean isCraftingAllowed(PartType partType, GearType gearType) {
        if (this.isGearTypeBlacklisted(gearType) || !this.allowedInPart(partType)) {
            return false;
        }
        if (this.stats.containsKey(partType) || this.getParent() != null && this.getParent().isCraftingAllowed(partType, gearType)) {
            if (partType == PartType.MAIN) {
                ItemStat stat = gearType == GearType.ARMOR ? ItemStats.ARMOR_DURABILITY : ItemStats.DURABILITY;
                return !this.getStatModifiers(stat, partType).isEmpty() && this.getStatUnclamped(stat, partType) > 0.0f;
            }
            return true;
        }
        return false;
    }

    private boolean isGearTypeBlacklisted(GearType gearType) {
        for (String s : this.blacklistedGearTypes) {
            if (!gearType.matches(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPrimaryColor(ItemStack gear, PartType partType) {
        return this.getMaterialDisplay(gear, partType).getPrimaryColor();
    }

    @Override
    public PartTextureType getTexture(PartType partType, ItemStack gear) {
        return this.getMaterialDisplay(gear, partType).getTexture();
    }

    @Override
    @Deprecated
    public IMaterialLayerList getMaterialDisplay(ItemStack gear, PartType partType) {
        if (!gear.func_190926_b()) {
            GearType gearType = ((ICoreItem)gear.func_77973_b()).getGearType();
            String gearTypeKey = partType.getName() + "/" + gearType.getName();
            if (this.display.containsKey(gearTypeKey)) {
                return this.display.get(gearTypeKey);
            }
            for (String key : this.display.keySet()) {
                if (!gearType.matches(key, false)) continue;
                return this.display.get(key);
            }
        }
        return this.display.getOrDefault(partType.getName().func_110623_a() + "/all", this.display.getOrDefault(partType.getName() + "/all", MaterialLayerList.DEFAULT));
    }

    @Override
    public ITextComponent getDisplayName(PartType partType, ItemStack gear) {
        return this.displayName.func_212638_h();
    }

    @Override
    @Nullable
    public ITextComponent getDisplayNamePrefix(ItemStack gear, PartType partType) {
        return this.namePrefix != null ? this.namePrefix.func_212638_h() : null;
    }

    @Override
    public boolean isVisible(PartType partType) {
        return this.visible;
    }

    @Override
    public void updateIngredient(SyncMaterialCraftingItemsPacket msg) {
        Ingredient ing = msg.getIngredient(this.materialId);
        if (ing != null) {
            this.ingredient = ing;
        }
    }

    public String toString() {
        return "PartMaterial{id=" + this.materialId + ", tier=" + this.tier + ", ingredient=" + this.ingredient + '}';
    }

    public static final class Serializer
    implements IMaterialSerializer<PartMaterial> {
        static final int PACK_NAME_MAX_LENGTH = 32;

        @Override
        public PartMaterial deserialize(ResourceLocation id, String packName, JsonObject json) {
            PartMaterial ret = new PartMaterial(id, packName);
            if (json.has("parent")) {
                ret.parent = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"parent"));
            }
            Serializer.deserializeStats(json, ret);
            Serializer.deserializeTraits(json, ret);
            Serializer.deserializeCraftingItems(json, ret);
            Serializer.deserializeNames(json, ret);
            Serializer.deserializeDisplayProps(json, ret);
            Serializer.deserializeAvailability(json, ret);
            return ret;
        }

        static void deserializeStats(JsonObject json, PartMaterial ret) {
            JsonElement elementStats = json.get("stats");
            if (elementStats != null && elementStats.isJsonObject()) {
                for (Map.Entry entry : elementStats.getAsJsonObject().entrySet()) {
                    ResourceLocation partTypeName = SilentGear.getIdWithDefaultNamespace((String)entry.getKey());
                    if (partTypeName == null) continue;
                    PartType partType = PartType.get(partTypeName);
                    StatModifierMap statMods = StatModifierMap.read((JsonElement)entry.getValue());
                    ret.stats.put(partType, statMods);
                }
            }
        }

        private static void deserializeTraits(JsonObject json, PartMaterial ret) {
            JsonElement elementTraits = json.get("traits");
            if (elementTraits != null && elementTraits.isJsonObject()) {
                for (Map.Entry entry : elementTraits.getAsJsonObject().entrySet()) {
                    PartType partType = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace((String)entry.getKey())));
                    if (partType == null) continue;
                    ArrayList list = new ArrayList();
                    ((JsonElement)entry.getValue()).getAsJsonArray().forEach(e -> list.add(PartTraitInstance.deserialize(e.getAsJsonObject())));
                    ret.traits.put(partType, list);
                }
            }
        }

        private static void deserializeCraftingItems(JsonObject json, PartMaterial ret) {
            JsonElement craftingItems = json.get("crafting_items");
            if (craftingItems != null && craftingItems.isJsonObject()) {
                JsonElement main = craftingItems.getAsJsonObject().get("main");
                if (main != null) {
                    ret.ingredient = Ingredient.func_199802_a((JsonElement)main);
                }
            } else {
                throw new JsonSyntaxException("Expected 'crafting_items' to be an object");
            }
        }

        private static void deserializeNames(JsonObject json, PartMaterial ret) {
            JsonElement elementName = json.get("name");
            if (elementName == null || !elementName.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'name' element");
            }
            ret.displayName = Serializer.deserializeText(elementName);
            JsonElement elementNamePrefix = json.get("name_prefix");
            if (elementNamePrefix != null) {
                ret.namePrefix = Serializer.deserializeText(elementNamePrefix);
            }
        }

        @Deprecated
        private static void deserializeDisplayProps(JsonObject json, PartMaterial ret) {
            JsonElement elementDisplay = json.get("display");
            if (elementDisplay != null && elementDisplay.isJsonObject()) {
                JsonObject obj = elementDisplay.getAsJsonObject();
                MaterialLayerList defaultProps = ret.display.getOrDefault("all", MaterialLayerList.DEFAULT);
                if (!ret.display.containsKey("all")) {
                    ret.display.put("all", defaultProps);
                }
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    ret.display.put(key, MaterialLayerList.deserialize(value, defaultProps));
                }
            }
        }

        private static void deserializeAvailability(JsonObject json, PartMaterial ret) {
            JsonElement elementAvailability = json.get("availability");
            if (elementAvailability != null && elementAvailability.isJsonObject()) {
                JsonObject obj = elementAvailability.getAsJsonObject();
                ret.tier = JSONUtils.func_151208_a((JsonObject)obj, (String)"tier", (int)ret.tier);
                ret.visible = JSONUtils.func_151209_a((JsonObject)obj, (String)"visible", (boolean)ret.visible);
                ret.canSalvage = JSONUtils.func_151209_a((JsonObject)obj, (String)"can_salvage", (boolean)ret.canSalvage);
                JsonArray blacklist = JSONUtils.func_151213_a((JsonObject)obj, (String)"gear_blacklist", null);
                if (blacklist != null) {
                    ret.blacklistedGearTypes.clear();
                    blacklist.forEach(e -> ret.blacklistedGearTypes.add(e.getAsString()));
                }
            } else if (ret.parent == null) {
                throw new JsonSyntaxException("Expected 'availability' to be an object");
            }
        }

        private static ITextComponent deserializeText(JsonElement json) {
            if (json.isJsonObject() && json.getAsJsonObject().has("name")) {
                boolean translate = JSONUtils.func_151209_a((JsonObject)json.getAsJsonObject(), (String)"translate", (boolean)false);
                String name = JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject(), (String)"name");
                return translate ? new TranslationTextComponent(name, new Object[0]) : new StringTextComponent(name);
            }
            return Objects.requireNonNull(ITextComponent.Serializer.func_197672_a((JsonElement)json));
        }

        @Override
        public PartMaterial read(ResourceLocation id, PacketBuffer buffer) {
            PartMaterial material = new PartMaterial(id, buffer.func_150789_c(32));
            if (buffer.readBoolean()) {
                material.parent = buffer.func_192575_l();
            }
            material.displayName = buffer.func_179258_d();
            if (buffer.readBoolean()) {
                material.namePrefix = buffer.func_179258_d();
            }
            material.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            material.tier = buffer.readByte();
            material.visible = buffer.readBoolean();
            material.canSalvage = buffer.readBoolean();
            material.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            material.blacklistedGearTypes.clear();
            int blacklistSize = buffer.readByte();
            for (int i = 0; i < blacklistSize; ++i) {
                material.blacklistedGearTypes.add(buffer.func_218666_n());
            }
            int displayCount = buffer.func_150792_a();
            for (int i = 0; i < displayCount; ++i) {
                String key = buffer.func_150789_c(255);
                MaterialLayerList display = MaterialLayerList.read(buffer);
                material.display.put(key, display);
            }
            Serializer.readStats(buffer, material);
            Serializer.readTraits(buffer, material);
            return material;
        }

        @Override
        public void write(PacketBuffer buffer, PartMaterial material) {
            buffer.func_211400_a(material.packName.substring(0, Math.min(32, material.packName.length())), 32);
            buffer.writeBoolean(material.parent != null);
            if (material.parent != null) {
                buffer.func_192572_a(material.parent);
            }
            buffer.func_179256_a(material.displayName);
            buffer.writeBoolean(material.namePrefix != null);
            if (material.namePrefix != null) {
                buffer.func_179256_a(material.namePrefix);
            }
            material.ingredient.func_199564_a(buffer);
            buffer.writeByte(material.tier);
            buffer.writeBoolean(material.visible);
            buffer.writeBoolean(material.canSalvage);
            material.ingredient.func_199564_a(buffer);
            buffer.writeByte(material.blacklistedGearTypes.size());
            material.blacklistedGearTypes.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
            buffer.func_150787_b(material.display.size());
            material.display.forEach((s, display) -> {
                buffer.func_180714_a(s);
                display.write(buffer);
            });
            Serializer.writeStats(buffer, material);
            Serializer.writeTraits(buffer, material);
        }

        @Override
        public ResourceLocation getName() {
            return SilentGear.getId("standard");
        }

        private static void readStats(PacketBuffer buffer, PartMaterial material) {
            material.stats.clear();
            int typeCount = buffer.readByte();
            for (int i = 0; i < typeCount; ++i) {
                PartType partType = PartType.get(buffer.func_192575_l());
                int statCount = buffer.readByte();
                StatModifierMap map = new StatModifierMap();
                for (int j = 0; j < statCount; ++j) {
                    ItemStat stat = (ItemStat)((IForgeRegistry)ItemStats.REGISTRY.get()).getValue(buffer.func_192575_l());
                    StatInstance mod = StatInstance.read(buffer);
                    map.put(stat, mod);
                }
                material.stats.put(partType, map);
            }
        }

        private static void writeStats(PacketBuffer buffer, PartMaterial material) {
            buffer.writeByte(material.stats.size());
            material.stats.forEach((partType, map) -> {
                buffer.func_192572_a(partType.getName());
                buffer.writeByte(map.size());
                map.forEach((stat, mod) -> {
                    buffer.func_192572_a(Objects.requireNonNull(stat.getStatId()));
                    mod.write(buffer);
                });
            });
        }

        private static void readTraits(PacketBuffer buffer, PartMaterial material) {
            material.traits.clear();
            int typeCount = buffer.readByte();
            for (int i = 0; i < typeCount; ++i) {
                PartType partType = PartType.get(buffer.func_192575_l());
                int traitCount = buffer.readByte();
                ArrayList<PartTraitInstance> list = new ArrayList<PartTraitInstance>();
                for (int j = 0; j < traitCount; ++j) {
                    PartTraitInstance trait = PartTraitInstance.read(buffer);
                    list.add(trait);
                }
                material.traits.put(partType, list);
            }
        }

        private static void writeTraits(PacketBuffer buffer, PartMaterial material) {
            buffer.writeByte(material.traits.size());
            material.traits.forEach((partType, list) -> {
                buffer.func_192572_a(partType.getName());
                buffer.writeByte(list.size());
                list.forEach(trait -> trait.write(buffer));
            });
        }
    }
}

