/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.gear.material.SimplePartAdapterMaterial;
import net.silentchaos512.gear.network.SyncMaterialsPacket;
import net.silentchaos512.gear.parts.PartConst;
import net.silentchaos512.gear.parts.PartManager;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class MaterialManager
implements IResourceManagerReloadListener {
    public static final MaterialManager INSTANCE = new MaterialManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"MaterialManager");
    private static final String DATA_PATH = "silentgear_materials";
    private static final Map<ResourceLocation, IMaterial> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<String> ERROR_LIST = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection resources = resourceManager.func_199003_a(DATA_PATH, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            MAP.clear();
            ERROR_LIST.clear();
            SilentGear.LOGGER.info(MARKER, "Reloading material files");
            for (ResourceLocation id : resources) {
                String path = id.func_110623_a().substring(DATA_PATH.length() + 1, id.func_110623_a().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                String packName = "ERROR";
                try {
                    IResource iresource = resourceManager.func_199002_a(id);
                    Throwable throwable = null;
                    try {
                        packName = iresource.func_199026_d();
                        JsonObject json = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error(MARKER, "Could not load material {} as it's null or empty", (Object)name);
                            continue;
                        }
                        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                            SilentGear.LOGGER.info(MARKER, "Skipping loading material {} as its conditions were not met", (Object)name);
                            continue;
                        }
                        IMaterial material = MaterialSerializers.deserialize(name, packName, json);
                        MAP.put(material.getId(), material);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error(MARKER, "Parsing error loading material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error(MARKER, "Could not read material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
            }
            MaterialManager.createAdapterMaterials();
        }
    }

    private static void createAdapterMaterials() {
        SilentGear.LOGGER.info(MARKER, "Trying to create adapter materials...");
        for (IGearPart part : PartManager.getValues()) {
            if (MaterialManager.isBuiltInPart(part)) {
                SilentGear.LOGGER.debug(MARKER, "Not creating adapter for '{}': built-in part", (Object)part.getId());
                continue;
            }
            String[] pathParts = part.getId().func_110623_a().split("/");
            if (pathParts.length != 2) {
                SilentGear.LOGGER.debug(MARKER, "Not considering '{}' for conversion, non-standard name format", (Object)part.getId());
                continue;
            }
            if (MAP.containsKey((Object)SilentGear.getId(pathParts[1]))) {
                SilentGear.LOGGER.debug(MARKER, "Not creating adapter for '{}': has like-named material already", (Object)part.getId());
                continue;
            }
            PartType partType = PartType.get(SilentGear.getId(pathParts[0]));
            ResourceLocation materialId = new ResourceLocation(part.getId().func_110624_b(), pathParts[1]);
            if (partType == null) continue;
            IMaterial material = MAP.computeIfAbsent(materialId, SimplePartAdapterMaterial::new);
            if (material instanceof SimplePartAdapterMaterial) {
                ((SimplePartAdapterMaterial)material).addPart(part);
                SilentGear.LOGGER.info(MARKER, "Added part '{}' to adapter material '{}'", (Object)part.getId(), (Object)materialId);
                continue;
            }
            SilentGear.LOGGER.debug(MARKER, "Not creating adapter for '{}': material already defined", (Object)materialId);
        }
    }

    private static boolean isBuiltInPart(IGearPart part) {
        IGearPart example = PartManager.get(PartConst.MAIN_EXAMPLE);
        return example == null || part.getPackName().equals(example.getPackName());
    }

    public static List<IMaterial> getValues() {
        return MaterialManager.getValues(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMaterial> getValues(boolean includeChildren) {
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            return MAP.values().stream().filter(m -> includeChildren || m.getParent() == null).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMaterial> getChildren(IMaterial material) {
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            return MAP.values().stream().filter(m -> m.getParent() == material).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMaterial get(@Nullable ResourceLocation id) {
        if (id == null) {
            return null;
        }
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            return MAP.get(id);
        }
    }

    @Nullable
    public static IMaterial from(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (IMaterial material : MaterialManager.getValues()) {
            if (!material.getIngredient(PartType.MAIN).test(stack)) continue;
            return material;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSyncPacket(SyncMaterialsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            ImmutableMap oldMaterials = ImmutableMap.copyOf(MAP);
            MAP.clear();
            msg.getMaterials().forEach(arg_0 -> MaterialManager.lambda$handleSyncPacket$3((Map)oldMaterials, arg_0));
            SilentGear.LOGGER.info("Read {} materials from server", (Object)MAP.size());
        }
        ctx.get().setPacketHandled(true);
    }

    public static Collection<ITextComponent> getErrorMessages(ServerPlayerEntity player) {
        if (!ERROR_LIST.isEmpty()) {
            String listStr = String.join((CharSequence)", ", ERROR_LIST);
            return ImmutableList.of((Object)new StringTextComponent("[Silent Gear] The following materials failed to load, check your log file:").func_211708_a(TextFormatting.RED), (Object)new StringTextComponent(listStr));
        }
        return ImmutableList.of();
    }

    private static /* synthetic */ void lambda$handleSyncPacket$3(Map oldMaterials, IMaterial mat) {
        mat.retainData((IMaterial)oldMaterials.get(mat.getId()));
        MAP.put(mat.getId(), mat);
    }
}

