/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.lib.util.NameUtils;

public final class SalvagingRecipeBuilder {
    private final Ingredient ingredient;
    private final IRecipeSerializer<?> serializer;
    private final Collection<ItemStack> results = new ArrayList<ItemStack>();

    private SalvagingRecipeBuilder(Ingredient ingredient, IRecipeSerializer<?> serializer) {
        this.ingredient = ingredient;
        this.serializer = serializer;
    }

    public static SalvagingRecipeBuilder builder(IItemProvider ingredient) {
        return SalvagingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}));
    }

    public static SalvagingRecipeBuilder builder(Tag<Item> ingredient) {
        return SalvagingRecipeBuilder.builder(Ingredient.func_199805_a(ingredient));
    }

    public static SalvagingRecipeBuilder builder(Ingredient ingredient) {
        return new SalvagingRecipeBuilder(ingredient, ModRecipes.SALVAGING_SERIALIZER);
    }

    public static SalvagingRecipeBuilder gearBuilder(ICoreItem item) {
        return new SalvagingRecipeBuilder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), ModRecipes.SALVAGING_GEAR_SERIALIZER);
    }

    public SalvagingRecipeBuilder addResult(IItemProvider item) {
        return this.addResult(item, 1);
    }

    public SalvagingRecipeBuilder addResult(IItemProvider item, int count) {
        this.results.add(new ItemStack(item, count));
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.serializer == ModRecipes.SALVAGING_SERIALIZER && this.results.isEmpty()) {
            throw new IllegalStateException("Empty results for standard salvaging recipe");
        }
        consumer.accept(new Result(id, this));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final SalvagingRecipeBuilder builder;

        public Result(ResourceLocation id, SalvagingRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.builder.ingredient.func_200304_c());
            if (!this.builder.results.isEmpty()) {
                JsonArray results = new JsonArray();
                this.builder.results.forEach(stack -> results.add((JsonElement)this.serializeItem((ItemStack)stack)));
                json.add("results", (JsonElement)results);
            }
        }

        private JsonObject serializeItem(ItemStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("item", NameUtils.fromItem((ItemStack)stack).toString());
            if (stack.func_190916_E() > 1) {
                json.addProperty("count", (Number)stack.func_190916_E());
            }
            return json;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.builder.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

