/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.part;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.data.part.PartBuilder;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.ToolHeadItem;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.lib.util.NameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartsProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public PartsProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public String func_200397_b() {
        return "Silent Gear - Parts";
    }

    protected Collection<PartBuilder> getParts() {
        ArrayList<PartBuilder> ret = new ArrayList<PartBuilder>();
        ret.add(this.part("binding", GearType.TOOL, PartType.BINDING, PartPositions.BINDING, (IItemProvider)ModItems.BINDING));
        ret.add(this.part("bowstring", GearType.RANGED_WEAPON, PartType.BOWSTRING, PartPositions.BOWSTRING, (IItemProvider)ModItems.BOWSTRING));
        ret.add(this.part("fletching", GearType.NONE, PartType.FLETCHING, PartPositions.FLETCHING, (IItemProvider)ModItems.FLETCHING));
        ret.add(this.part("grip", GearType.TOOL, PartType.GRIP, PartPositions.GRIP, (IItemProvider)ModItems.GRIP));
        ret.add(this.part("long_rod", GearType.TOOL, PartType.ROD, PartPositions.ROD, (IItemProvider)ModItems.LONG_ROD));
        ret.add(this.part("rod", GearType.TOOL, PartType.ROD, PartPositions.ROD, (IItemProvider)ModItems.ROD));
        ret.add(this.part("tip", GearType.TOOL, PartType.TIP, PartPositions.TIP, (IItemProvider)ModItems.TIP));
        Registration.getItems(ToolHeadItem.class).forEach(item -> {
            PartPositions position = item.getGearType() == GearType.ARMOR ? PartPositions.ARMOR : PartPositions.HEAD;
            ret.add(this.part(NameUtils.fromItem((IItemProvider)item).func_110623_a(), item.getGearType(), item.getPartType(), position, (IItemProvider)item));
        });
        return ret;
    }

    private PartBuilder part(String name, GearType gearType, PartType partType, PartPositions position, IItemProvider item) {
        return new PartBuilder((ResourceLocation)SilentGear.getId(name), gearType, partType, position, item).name((ITextComponent)new TranslationTextComponent("part.silentgear." + name, new Object[0]));
    }

    public void func_200398_a(DirectoryCache cache) {
        Path outputFolder = this.generator.func_200391_b();
        for (PartBuilder builder : this.getParts()) {
            try {
                String jsonStr = GSON.toJson((JsonElement)builder.serialize());
                String hashStr = field_208307_a.hashUnencodedChars((CharSequence)jsonStr).toString();
                Path path = outputFolder.resolve(String.format("data/%s/silentgear_parts/%s.json", builder.id.func_110624_b(), builder.id.func_110623_a()));
                if (!Objects.equals(cache.func_208323_a(outputFolder), hashStr) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(jsonStr);
                    }
                }
                cache.func_208316_a(path, hashStr);
            }
            catch (IOException ex) {
                LOGGER.error("Could not save parts to {}", (Object)outputFolder, (Object)ex);
            }
        }
    }
}

