/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.part;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.parts.type.CompoundPart;

public class PartBuilder {
    final ResourceLocation id;
    private final ResourceLocation serializerType = CompoundPart.SERIALIZER.getName();
    private final GearType gearType;
    private final PartType partType;
    private final PartPositions position;
    private final int tier = -1;
    private final Ingredient ingredient;
    private boolean visible = true;
    private ITextComponent name;
    @Nullable
    private ITextComponent namePrefix;

    public PartBuilder(ResourceLocation id, GearType gearType, PartType partType, PartPositions position, IItemProvider item) {
        this(id, gearType, partType, position, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public PartBuilder(ResourceLocation id, GearType gearType, PartType partType, PartPositions position, Tag<Item> tag) {
        this(id, gearType, partType, position, Ingredient.func_199805_a(tag));
    }

    public PartBuilder(ResourceLocation id, GearType gearType, PartType partType, PartPositions position, Ingredient ingredient) {
        this.gearType = gearType;
        this.partType = partType;
        this.position = position;
        this.id = id;
        this.ingredient = ingredient;
    }

    public PartBuilder visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public PartBuilder name(ITextComponent text) {
        this.name = text;
        return this;
    }

    public PartBuilder namePrefix(ITextComponent text) {
        this.namePrefix = text;
        return this;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.serializerType.toString());
        json.addProperty("gear_type", this.gearType.getName());
        json.addProperty("part_type", this.partType.getName().toString());
        json.addProperty("part_position", this.position.name());
        JsonObject availability = new JsonObject();
        if (this.tier >= 0) {
            availability.addProperty("tier", (Number)this.tier);
            availability.addProperty("visible", Boolean.valueOf(this.visible));
        }
        if (!availability.entrySet().isEmpty()) {
            json.add("availability", (JsonElement)availability);
        }
        JsonObject craftingItems = new JsonObject();
        craftingItems.add("normal", this.ingredient.func_200304_c());
        json.add("crafting_items", (JsonElement)craftingItems);
        json.add("name", ITextComponent.Serializer.func_200528_b((ITextComponent)this.name));
        if (this.namePrefix != null) {
            json.add("name_prefix", ITextComponent.Serializer.func_200528_b((ITextComponent)this.namePrefix));
        }
        return json;
    }
}

