/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.ToolHeadItem;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.lib.util.NameUtils;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final Collection<CraftingItems> TIP_UPGRADES = ImmutableList.of((Object)((Object)CraftingItems.IRON_TIPPED_UPGRADE), (Object)((Object)CraftingItems.GOLD_TIPPED_UPGRADE), (Object)((Object)CraftingItems.DIAMOND_TIPPED_UPGRADE), (Object)((Object)CraftingItems.EMERALD_TIPPED_UPGRADE), (Object)((Object)CraftingItems.REDSTONE_COATED_UPGRADE), (Object)((Object)CraftingItems.GLOWSTONE_COATED_UPGRADE), (Object)((Object)CraftingItems.LAPIS_COATED_UPGRADE), (Object)((Object)CraftingItems.QUARTZ_TIPPED_UPGRADE));

    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "silentgear", existingFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Silent Gear - Item Models";
    }

    protected void registerModels() {
        Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(this::blockItemModel);
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(new ResourceLocation("item/generated"));
        for (CraftingItems item : CraftingItems.values()) {
            if (!TIP_UPGRADES.contains((Object)item)) {
                this.builder(item, (ModelFile)itemGenerated, "item/" + item.getName());
                continue;
            }
            String upgradeType = item.getName().substring(0, item.getName().indexOf(95));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getName())).parent((ModelFile)itemGenerated)).texture("layer0", "item/upgrade_base")).texture("layer1", "item/upgrade_" + upgradeType);
        }
        Registration.getItems(PartBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$0((ModelFile)itemGenerated, arg_0));
        Registration.getItems(GearBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$1((ModelFile)itemGenerated, arg_0));
        this.builder((IItemProvider)ModItems.CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.STURDY_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.CRIMSON_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.AZURE_REPAIR_KIT, (ModelFile)itemGenerated);
        Registration.getItems(ToolHeadItem.class).forEach(arg_0 -> this.lambda$registerModels$2((ModelFile)itemGenerated, arg_0));
        this.builder((IItemProvider)ModItems.BLUEPRINT_PACKAGE, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.FLAXSEEDS, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.GOLDEN_NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.PEBBLE, (ModelFile)itemGenerated);
    }

    private void blockItemModel(Block block) {
        if (block == ModBlocks.FLAX_PLANT.get() || block == ModBlocks.WILD_FLAX_PLANT.get()) {
            return;
        }
        SilentGear.LOGGER.debug("blockItemModel: {}, {}", (Object)block, (Object)block.func_199767_j());
        if (block == ModBlocks.PHANTOM_LIGHT.get()) {
            this.builder((IItemProvider)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/phantom_light");
        } else if (block == ModBlocks.NETHERWOOD_SAPLING.get() || block == ModBlocks.STONE_TORCH.get()) {
            this.builder((IItemProvider)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "block/" + NameUtils.from((IForgeRegistryEntry)block).func_110623_a());
        } else if (block == ModBlocks.NETHERWOOD_FENCE.get()) {
            this.withExistingParent("netherwood_fence", this.modLoc("block/netherwood_fence_inventory"));
        } else if (block == ModBlocks.NETHERWOOD_DOOR.get()) {
            this.builder((IItemProvider)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/netherwood_door");
        } else if (block == ModBlocks.NETHERWOOD_TRAPDOOR.get()) {
            this.withExistingParent("netherwood_trapdoor", this.modLoc("block/netherwood_trapdoor_bottom"));
        } else if (block.func_199767_j() != Items.field_190931_a) {
            String name = NameUtils.from((IForgeRegistryEntry)block).func_110623_a();
            this.withExistingParent(name, this.modLoc("block/" + name));
        }
    }

    private void builder(IItemProvider item, ModelFile parent) {
        String name = NameUtils.fromItem((IItemProvider)item).func_110623_a();
        this.builder(item, parent, "item/" + name);
    }

    private void builder(IItemProvider item, ModelFile parent, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem((IItemProvider)item).func_110623_a())).parent(parent)).texture("layer0", texture);
    }

    private /* synthetic */ void lambda$registerModels$2(ModelFile itemGenerated, ToolHeadItem item) {
        String texture = item.getGearType().matches(GearType.ARMOR) ? "item/dummy_icon_main" : "item/" + item.getGearType().getName() + "/main_generic_hc";
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.from((IForgeRegistryEntry)item).func_110623_a())).parent(itemGenerated)).texture("layer0", texture);
    }

    private /* synthetic */ void lambda$registerModels$1(ModelFile itemGenerated, GearBlueprintItem item) {
        ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.from((IForgeRegistryEntry)item).func_110623_a())).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + item.getGearType().getName());
    }

    private /* synthetic */ void lambda$registerModels$0(ModelFile itemGenerated, PartBlueprintItem item) {
        ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.from((IForgeRegistryEntry)item).func_110623_a())).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + item.getPartType().getName().func_110623_a());
    }
}

