/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.crafting.ingredient.IPartIngredient;
import net.silentchaos512.gear.gear.material.MaterialManager;

public final class PartMaterialIngredient
extends Ingredient
implements IPartIngredient {
    private final PartType partType;
    private final GearType gearType;

    private PartMaterialIngredient(PartType partType, GearType gearType) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.partType = partType;
        this.gearType = gearType;
    }

    public static PartMaterialIngredient of(PartType partType) {
        return PartMaterialIngredient.of(partType, GearType.TOOL);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType) {
        return new PartMaterialIngredient(partType, gearType);
    }

    @Override
    public PartType getPartType() {
        return this.partType;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        IMaterial material = MaterialManager.from(stack);
        return material != null && material.isCraftingAllowed(this.partType, this.gearType);
    }

    public ItemStack[] func_193365_a() {
        List<IMaterial> materials = MaterialManager.getValues();
        if (!materials.isEmpty()) {
            return (ItemStack[])materials.stream().filter(mat -> mat.isCraftingAllowed(this.partType, this.gearType)).flatMap(mat -> Stream.of(mat.getIngredient(this.partType).func_193365_a())).filter(stack -> !stack.func_190926_b()).toArray(ItemStack[]::new);
        }
        return super.func_193365_a();
    }

    public boolean isSimple() {
        return false;
    }

    public boolean func_203189_d() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("part_type", this.partType.getName().toString());
        if (this.gearType != GearType.TOOL) {
            json.addProperty("gear_type", this.gearType.getName());
        }
        return json;
    }

    public static final class Serializer
    implements IIngredientSerializer<PartMaterialIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("material");

        private Serializer() {
        }

        public PartMaterialIngredient parse(PacketBuffer buffer) {
            ResourceLocation typeName = buffer.func_192575_l();
            PartType partType = PartType.get(typeName);
            if (partType == null) {
                throw new JsonParseException("Unknown part type: " + typeName);
            }
            GearType gearType = GearType.get(buffer.func_218666_n());
            if (gearType == null) {
                throw new JsonParseException("Unknown gear type: " + typeName);
            }
            return new PartMaterialIngredient(partType, gearType);
        }

        public PartMaterialIngredient parse(JsonObject json) {
            String typeName = JSONUtils.func_151219_a((JsonObject)json, (String)"part_type", (String)"");
            if (typeName.isEmpty()) {
                throw new JsonSyntaxException("'part_type' is missing");
            }
            PartType type = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace(typeName)));
            if (type == null) {
                throw new JsonSyntaxException("part_type " + typeName + " does not exist");
            }
            String gearTypeName = JSONUtils.func_151219_a((JsonObject)json, (String)"gear_type", (String)"tool");
            GearType gearType = GearType.get(gearTypeName);
            if (gearType == null) {
                throw new JsonSyntaxException("gear_type " + gearTypeName + " does not exist");
            }
            return new PartMaterialIngredient(type, gearType);
        }

        public void write(PacketBuffer buffer, PartMaterialIngredient ingredient) {
            buffer.func_192572_a(ingredient.partType.getName());
            buffer.func_180714_a(ingredient.gearType.getName());
        }
    }
}

