/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.init.NerfedGear;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.util.IAOETool;

@Mod.EventBusSubscriber(modid="silentgear", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    private static boolean isResourceLocation(Object o) {
        return o instanceof String && ResourceLocation.func_208304_a((String)((String)o)) != null;
    }

    private Config() {
    }

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Common.spec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Client.spec);
    }

    public static void sync() {
    }

    @SubscribeEvent
    public static void sync(ModConfig.Loading event) {
        Config.sync();
    }

    @SubscribeEvent
    public static void sync(ModConfig.Reloading event) {
        Config.sync();
    }

    private static String[] getDefaultNerfedGear() {
        ImmutableSet toolTypes = ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe", (Object)"sword");
        ImmutableSet toolMaterials = ImmutableSet.of((Object)"wooden", (Object)"stone", (Object)"iron", (Object)"golden", (Object)"diamond");
        List<String> items = toolTypes.stream().flatMap(arg_0 -> Config.lambda$getDefaultNerfedGear$1((Set)toolMaterials, arg_0)).collect(Collectors.toList());
        ImmutableSet armorTypes = ImmutableSet.of((Object)"helmet", (Object)"chestplate", (Object)"leggings", (Object)"boots");
        ImmutableSet armorMaterials = ImmutableSet.of((Object)"leather", (Object)"chainmail", (Object)"iron", (Object)"diamond", (Object)"golden");
        items.addAll(armorTypes.stream().flatMap(arg_0 -> Config.lambda$getDefaultNerfedGear$3((Set)armorMaterials, arg_0)).collect(Collectors.toList()));
        return items.toArray(new String[0]);
    }

    private static /* synthetic */ Stream lambda$getDefaultNerfedGear$3(Set armorMaterials, String type) {
        return armorMaterials.stream().map(material -> "minecraft:" + material + "_" + type);
    }

    private static /* synthetic */ Stream lambda$getDefaultNerfedGear$1(Set toolMaterials, String type) {
        return toolMaterials.stream().map(material -> "minecraft:" + material + "_" + type);
    }

    public static final class Client {
        static final ForgeConfigSpec spec;
        public static final ForgeConfigSpec.BooleanValue allowEnchantedEffect;
        public static final ForgeConfigSpec.BooleanValue useLiteModels;
        public static final ForgeConfigSpec.BooleanValue disableNewMaterialTooltips;

        private Client() {
        }

        static {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            allowEnchantedEffect = builder.comment(new String[]{"Allow gear items to have the 'enchanted glow' effect. Set to 'false' to disable the effect.", "The way vanilla handles the effect is bugged, and it is recommended to disable this until custom models are possible again."}).define("gear.allowEnchantedEffect", false);
            useLiteModels = builder.comment(new String[]{"Use 'lite' gear models. These should be easier on some systems, but do not allow unique textures for different materials.", "Currently, this option has no effect, as the normal model system is not working yet (lite models are used)"}).define("gear.useLiteModels", false);
            disableNewMaterialTooltips = builder.comment("Disable item tooltips related to the new material system. Will be removed when fully implemented.").define("item.gear.materials.disableNewTooltips", false);
            spec = builder.build();
        }
    }

    public static final class Common {
        static final ForgeConfigSpec spec;
        public static final ForgeConfigSpec.EnumValue<BlueprintType> blueprintTypes;
        public static final ForgeConfigSpec.BooleanValue spawnWithStarterBlueprints;
        public static final ForgeConfigSpec.BooleanValue nerfedItemsEnabled;
        public static final ForgeConfigSpec.DoubleValue nerfedItemDurabilityMulti;
        public static final ForgeConfigSpec.DoubleValue nerfedItemHarvestSpeedMulti;
        static final ForgeConfigSpec.ConfigValue<List<? extends String>> nerfedItems;
        public static final ForgeConfigSpec.DoubleValue sinewDropRate;
        static final ForgeConfigSpec.ConfigValue<List<? extends String>> sinewAnimals;
        public static final ForgeConfigSpec.EnumValue<IAOETool.MatchMode> matchModeStandard;
        public static final ForgeConfigSpec.EnumValue<IAOETool.MatchMode> matchModeOres;
        public static final ForgeConfigSpec.BooleanValue gearBreaksPermanently;
        public static final ForgeConfigSpec.DoubleValue repairFactorAnvil;
        public static final ForgeConfigSpec.DoubleValue repairFactorQuick;
        public static final ForgeConfigSpec.IntValue repairKitCrudeCapacity;
        public static final ForgeConfigSpec.IntValue repairKitSturdyCapacity;
        public static final ForgeConfigSpec.IntValue repairKitCrimsonCapacity;
        public static final ForgeConfigSpec.IntValue repairKitAzureCapacity;
        public static final ForgeConfigSpec.DoubleValue repairKitCrudeEfficiency;
        public static final ForgeConfigSpec.DoubleValue repairKitSturdyEfficiency;
        public static final ForgeConfigSpec.DoubleValue repairKitCrimsonEfficiency;
        public static final ForgeConfigSpec.DoubleValue repairKitAzureEfficiency;
        public static final ForgeConfigSpec.BooleanValue upgradesInAnvilOnly;
        private static final Map<ItemStat, ForgeConfigSpec.DoubleValue> statMultipliers;
        public static final ForgeConfigSpec.DoubleValue salvagerMinLossRate;
        public static final ForgeConfigSpec.DoubleValue salvagerMaxLossRate;
        public static final ForgeConfigSpec.BooleanValue mineAndSlashSupport;
        public static final ForgeConfigSpec.BooleanValue extraPartAndTraitLogging;

        private Common() {
        }

        public static float getStatWithMultiplier(ItemStat stat, float value) {
            if (statMultipliers.containsKey(stat)) {
                return ((Double)statMultipliers.get(stat).get()).floatValue() * value;
            }
            return value;
        }

        public static boolean isNerfedItem(Item item) {
            return (Boolean)nerfedItemsEnabled.get() != false && Common.isThingInList(item, nerfedItems);
        }

        public static boolean isSinewAnimal(LivingEntity entity) {
            return Common.isThingInList(entity.func_200600_R(), sinewAnimals);
        }

        private static boolean isThingInList(IForgeRegistryEntry<?> thing, ForgeConfigSpec.ConfigValue<List<? extends String>> list) {
            ResourceLocation name = thing.getRegistryName();
            for (String str : (List)list.get()) {
                ResourceLocation fromList = ResourceLocation.func_208304_a((String)str);
                if (fromList == null || !fromList.equals((Object)name)) continue;
                return true;
            }
            return false;
        }

        static {
            statMultipliers = new HashMap<ItemStat, ForgeConfigSpec.DoubleValue>();
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.push("item");
            builder.comment("Blueprint and template settings");
            builder.push("blueprint");
            blueprintTypes = builder.comment("Allowed blueprint types. Valid values are: BOTH, BLUEPRINT, and TEMPLATE").defineEnum("typesAllowed", (Enum)BlueprintType.BOTH);
            spawnWithStarterBlueprints = builder.comment(new String[]{"When joining a new world, should players be given a blueprint package?", "The blueprint package gives some blueprints when used (right-click).", "To change what is given, override the starter_blueprints loot table."}).define("spawnWithStarterBlueprints", true);
            builder.pop();
            builder.comment("Repair kit configs.");
            builder.push("repairKits");
            builder.comment(new String[]{"Capacity is the number of materials that can be stored (all types combined)", "Setting to zero would make the repair kit unusable."});
            builder.push("capacity");
            repairKitCrudeCapacity = builder.defineInRange("crude", 16, 0, Integer.MAX_VALUE);
            repairKitSturdyCapacity = builder.defineInRange("sturdy", 32, 0, Integer.MAX_VALUE);
            repairKitCrimsonCapacity = builder.defineInRange("crimson", 48, 0, Integer.MAX_VALUE);
            repairKitAzureCapacity = builder.defineInRange("azure", 64, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment(new String[]{"Efficiency is the percentage of the repair value used. Higher values mean less materials used.", "Setting to zero would make the repair kit unusable."});
            builder.push("efficiency");
            repairKitCrudeEfficiency = builder.defineInRange("crude", (double)0.35f, 0.0, 10.0);
            repairKitSturdyEfficiency = builder.defineInRange("sturdy", (double)0.4f, 0.0, 10.0);
            repairKitCrimsonEfficiency = builder.defineInRange("crimson", (double)0.45f, 0.0, 10.0);
            repairKitAzureEfficiency = builder.defineInRange("azure", 0.5, 0.0, 10.0);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.comment(new String[]{"Settings for nerfed items.", "You can give items reduced durability to encourage use of Silent Gear tools.", "Changes require a restart!"});
            builder.push("nerfedItems");
            nerfedItemsEnabled = builder.comment("Enable this feature. If false, the other settings in this category are ignored.").define("enabled", false);
            nerfedItemDurabilityMulti = builder.comment("Multiplies max durability by this value. If the result would be zero, a value of 1 is assigned.").defineInRange("durabilityMultiplier", 0.05, 0.0, 1.0);
            nerfedItemHarvestSpeedMulti = builder.comment("Multiplies harvest speed by this value.").defineInRange("harvestSpeedMultiplier", 0.5, 0.0, 1.0);
            nerfedItems = builder.comment("These items will have reduced durability").defineList("items", NerfedGear.DEFAULT_ITEMS, x$0 -> Config.isResourceLocation(x$0));
            builder.pop();
            builder.comment("Settings for sinew drops");
            builder.push("sinew");
            sinewDropRate = builder.comment("Drop rate of sinew (chance out of 1)").defineInRange("dropRate", 0.2, 0.0, 1.0);
            sinewAnimals = builder.comment("These entities can drop sinew when killed.").defineList("dropsFrom", (List)ImmutableList.of((Object)"minecraft:cow", (Object)"minecraft:pig", (Object)"minecraft:sheep"), x$0 -> Config.isResourceLocation(x$0));
            builder.pop();
            builder.comment("Settings for gear (tools, weapons, and armor)");
            builder.push("gear");
            gearBreaksPermanently = builder.comment("If true, gear breaks permanently, like vanilla tools and armor").define("breaksPermanently", false);
            builder.comment(new String[]{"Settings for AOE tools (hammer, excavator)", "Match modes determine what blocks are considered similar enough to be mined together.", "LOOSE: Break anything (you probably do not want this)", "MODERATE: Break anything with the same harvest level", "STRICT: Break only the exact same block"});
            builder.push("aoeTool");
            matchModeStandard = builder.comment("Match mode for most blocks").defineEnum("matchMode.standard", (Enum)IAOETool.MatchMode.MODERATE);
            matchModeOres = builder.comment("Match mode for ore blocks (anything in the forge:ores block tag)").defineEnum("matchMode.ores", (Enum)IAOETool.MatchMode.STRICT);
            builder.pop();
            builder.push("repairs");
            repairFactorAnvil = builder.comment("Effectiveness of gear repairs done in an anvil. Set to 0 to disable anvil repairs.").defineInRange("anvilEffectiveness", 0.5, 0.0, 1.0);
            repairFactorQuick = builder.comment("DEPRECATED! Effectiveness of quick gear repairs (crafting grid). Set to 0 to disable quick repairs.").defineInRange("quickEffectiveness", 0.35, 0.0, 1.0);
            builder.pop();
            builder.push("upgrades");
            upgradesInAnvilOnly = builder.comment("If true, upgrade parts may only be applied in an anvil.").define("applyInAnvilOnly", false);
            builder.pop();
            builder.comment(new String[]{"Multipliers for stats on all gear. This allows the stats on all items to be increased or decreased", "without overriding every single file."});
            builder.push("statMultipliers");
            ((IForgeRegistry)ItemStats.REGISTRY.get()).getValues().forEach(stat -> {
                ResourceLocation name = Objects.requireNonNull(stat.getRegistryName());
                String key = name.func_110624_b() + "." + name.func_110623_a();
                ForgeConfigSpec.DoubleValue config = builder.defineInRange(key, 1.0, 0.0, Double.MAX_VALUE);
                statMultipliers.put((ItemStat)stat, config);
            });
            builder.pop();
            builder.pop();
            builder.comment("Settings for the salvager");
            builder.push("salvager");
            salvagerMinLossRate = builder.comment(new String[]{"Minimum rate of part loss when salvaging items. 0 = no loss, 1 = complete loss.", "Rate depends on remaining durability."}).defineInRange("partLossRate.min", 0.0, 0.0, 1.0);
            salvagerMaxLossRate = builder.comment(new String[]{"Maximum rate of part loss when salvaging items. 0 = no loss, 1 = complete loss.", "Rate depends on remaining durability."}).defineInRange("partLossRate.max", 0.5, 0.0, 1.0);
            builder.pop();
            mineAndSlashSupport = builder.comment("Enable compatibility with the Mine and Slash mod, if installed").define("compat.mineAndSlash.enabled", true);
            extraPartAndTraitLogging = builder.comment(new String[]{"Log additional information related to loading and synchronizing gear parts and traits.", "This might help track down more obscure issues."}).define("debug.logging.extraPartAndTraitInfo", false);
            spec = builder.build();
        }
    }
}

