/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.network.Network;
import net.silentchaos512.gear.network.ShowPartsScreenPacket;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.utils.Color;

public final class SGearPartsCommand {
    private static final SuggestionProvider<CommandSource> partIdSuggestions = (ctx, builder) -> ISuggestionProvider.func_212476_a(PartManager.getValues().stream().map(IGearPart::getId), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> partInGearSuggestions = (ctx, builder) -> {
        PartDataList parts = GearData.getConstructionParts(SGearPartsCommand.getGear((CommandContext<CommandSource>)ctx));
        return ISuggestionProvider.func_212476_a(parts.getUniqueParts(false).stream().map(part -> part.getPart().getId()), (SuggestionsBuilder)builder);
    };
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private SGearPartsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"sgear_parts");
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"partID", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(partIdSuggestions).then(Commands.func_197056_a((String)"grade", (ArgumentType)new MaterialGrade.Argument()).executes(ctx -> SGearPartsCommand.runAdd((CommandContext<CommandSource>)ctx, SGearPartsCommand.getPartGrade((CommandContext<CommandSource>)ctx))))).executes(ctx -> SGearPartsCommand.runAdd((CommandContext<CommandSource>)ctx, MaterialGrade.NONE))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"partID", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(partInGearSuggestions).executes(SGearPartsCommand::runRemoveById))).then(Commands.func_197056_a((String)"partIndex", (ArgumentType)IntegerArgumentType.integer()).executes(SGearPartsCommand::runRemoveByIndex)));
        builder.then(Commands.func_197057_a((String)"list").executes(SGearPartsCommand::runList));
        builder.then(Commands.func_197057_a((String)"dump").executes(SGearPartsCommand::runDumpCsv));
        builder.then(Commands.func_197057_a((String)"show_gui").executes(context -> {
            ServerPlayerEntity playerMP = ((CommandSource)context.getSource()).func_197035_h();
            Network.channel.sendTo((Object)new ShowPartsScreenPacket(), playerMP.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            return 1;
        }));
        dispatcher.register(builder);
    }

    private static int runAdd(CommandContext<CommandSource> ctx, MaterialGrade grade) throws CommandSyntaxException {
        IGearPart part = SGearPartsCommand.getPart(ctx);
        if (part == null) {
            return 0;
        }
        ItemStack gear = SGearPartsCommand.getGear(ctx);
        if (gear.func_190926_b()) {
            return 0;
        }
        GearData.addPart(gear, PartData.of(part));
        GearData.recalculateStats(gear, (PlayerEntity)((CommandSource)ctx.getSource()).func_197035_h());
        return 1;
    }

    private static int runRemoveById(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ItemStack gear = SGearPartsCommand.getGear(ctx);
        if (gear.func_190926_b()) {
            return 0;
        }
        IGearPart part = SGearPartsCommand.getPart(ctx);
        if (part == null) {
            return 0;
        }
        PartDataList partList = GearData.getConstructionParts(gear);
        boolean removed = false;
        for (int i = 0; !removed && i < partList.size(); ++i) {
            PartData data = partList.get(i);
            if (data.getPart() != part) continue;
            partList.remove(data);
            removed = true;
        }
        if (removed) {
            GearData.writeConstructionParts(gear, partList);
            GearData.recalculateStats(gear, (PlayerEntity)((CommandSource)ctx.getSource()).func_197035_h());
            ((CommandSource)ctx.getSource()).func_197030_a(SGearPartsCommand.text("remove.success", new Object[0]), true);
            return 1;
        }
        ((CommandSource)ctx.getSource()).func_197021_a(SGearPartsCommand.text("gearDoesNotContainPart", new Object[0]));
        return 0;
    }

    private static int runRemoveByIndex(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ItemStack gear = SGearPartsCommand.getGear(ctx);
        if (gear.func_190926_b()) {
            return 0;
        }
        PartDataList partList = GearData.getConstructionParts(gear);
        int index = IntegerArgumentType.getInteger(ctx, (String)"partIndex");
        if (index < 0 || index >= partList.size()) {
            ((CommandSource)ctx.getSource()).func_197021_a(SGearPartsCommand.text("indexOutOfBounds", new Object[0]));
            return 0;
        }
        partList.remove(index);
        GearData.writeConstructionParts(gear, partList);
        GearData.recalculateStats(gear, (PlayerEntity)((CommandSource)ctx.getSource()).func_197035_h());
        ((CommandSource)ctx.getSource()).func_197030_a(SGearPartsCommand.text("remove.success", new Object[0]), true);
        return 1;
    }

    private static int runList(CommandContext<CommandSource> context) {
        String listStr = PartManager.getValues().stream().map(part -> part.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(listStr), true);
        for (PartType type : PartType.getValues()) {
            int count = PartManager.getPartsOfType(type).size();
            String str = String.format("%s: %d", type.getName(), count);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(str), true);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runDumpCsv(CommandContext<CommandSource> context) {
        String dirPath = "output/silentgear";
        String fileName = "part_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Could not create directory: " + output.getParent()));
            return 0;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Name\tID\tType\tTier\t");
            ItemStats.allStatsOrdered().forEach(s -> builder.append(s.getDisplayName().func_150254_d()).append("\t"));
            builder.append("Traits\tLite Texture\tNormal Color\tBroken Color\tFallback Color\tArmor Color");
            writer.write(builder.toString());
            for (IGearPart part : PartManager.getValues()) {
                writer.write(SGearPartsCommand.partToTsvLine(part) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Wrote to " + output.getAbsolutePath()), true);
        }
        return 1;
    }

    private static String partToTsvLine(IGearPart part) {
        StringBuilder builder = new StringBuilder();
        PartData partData = PartData.of(part);
        SGearPartsCommand.appendTsv(builder, part.getDisplayName(partData, ItemStack.field_190927_a).getString());
        SGearPartsCommand.appendTsv(builder, part.getId().toString());
        SGearPartsCommand.appendTsv(builder, part.getType().getName());
        SGearPartsCommand.appendTsv(builder, partData.getTier());
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> statModifiers = part.getStatModifiers(stat, partData);
            SGearPartsCommand.appendTsv(builder, FORMAT_CODES.matcher(StatModifierMap.formatText(statModifiers, stat, 5).getString()).replaceAll(""));
        }
        SGearPartsCommand.appendTsv(builder, part.getTraits(partData).stream().map(t -> t.getTrait().getDisplayName(t.getLevel()).func_150254_d()).collect(Collectors.joining(", ")));
        IPartDisplay display = part.getDisplayProperties(partData, ItemStack.field_190927_a, 0);
        SGearPartsCommand.appendTsv(builder, (Object)display.getLiteTexture());
        SGearPartsCommand.appendTsv(builder, Color.format((int)(display.getNormalColor() & 0xFFFFFF)));
        SGearPartsCommand.appendTsv(builder, Color.format((int)(display.getBrokenColor() & 0xFFFFFF)));
        SGearPartsCommand.appendTsv(builder, Color.format((int)(display.getFallbackColor() & 0xFFFFFF)));
        SGearPartsCommand.appendTsv(builder, Color.format((int)(display.getArmorColor() & 0xFFFFFF)));
        return builder.toString();
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    @Nullable
    private static IGearPart getPart(CommandContext<CommandSource> ctx) {
        ResourceLocation id = ResourceLocationArgument.func_197195_e(ctx, (String)"partID");
        IGearPart part = PartManager.get(id);
        if (part == null) {
            ((CommandSource)ctx.getSource()).func_197021_a(SGearPartsCommand.text("partNotFound", id));
        }
        return part;
    }

    private static MaterialGrade getPartGrade(CommandContext<CommandSource> ctx) {
        return MaterialGrade.Argument.getGrade(ctx, "grade");
    }

    private static ItemStack getGear(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if (((CommandSource)ctx.getSource()).func_197022_f() instanceof ServerPlayerEntity) {
            ItemStack gear = ((CommandSource)ctx.getSource()).func_197035_h().func_184614_ca();
            if (gear.func_77973_b() instanceof ICoreItem) {
                return gear;
            }
        } else {
            ((CommandSource)ctx.getSource()).func_197021_a(SGearPartsCommand.text("sourceMustBePlayer", new Object[0]));
        }
        return ItemStack.field_190927_a;
    }

    private static ITextComponent text(String key, Object ... args) {
        return new TranslationTextComponent("command.silentgear.parts." + key, args);
    }
}

