/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.part;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.BakedPerspectiveModel;
import net.silentchaos512.gear.client.model.BakedWrapper;
import net.silentchaos512.gear.client.model.LayeredModel;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.client.model.part.CompoundPartModelOverrideList;
import net.silentchaos512.gear.util.Const;

public class CompoundPartModel
extends LayeredModel<CompoundPartModel> {
    private final ItemCameraTransforms cameraTransforms;
    final GearType gearType;
    final PartType partType;
    private CompoundPartModelOverrideList overrideList;

    CompoundPartModel(ItemCameraTransforms cameraTransforms, GearType gearType, PartType partType) {
        this.cameraTransforms = cameraTransforms;
        this.gearType = gearType;
        this.partType = partType;
    }

    public void clearCache() {
        if (this.overrideList != null) {
            this.overrideList.clearCache();
        }
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        this.overrideList = new CompoundPartModelOverrideList(this, owner, bakery, spriteGetter, modelTransform, modelLocation);
        return new BakedWrapper(this, owner, bakery, spriteGetter, modelTransform, modelLocation, this.overrideList);
    }

    public IBakedModel bake(List<MaterialLayer> layers, String transformVariant, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrideList, ResourceLocation modelLocation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TransformationMatrix rotation = modelTransform.func_225615_b_();
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform);
        for (int i = 0; i < layers.size(); ++i) {
            MaterialLayer layer = layers.get(i);
            TextureAtlasSprite texture = spriteGetter.apply(new Material(PlayerContainer.field_226615_c_, layer.getTexture(this.gearType, 0)));
            builder.addAll(CompoundPartModel.getQuadsForSprite(i, texture, rotation, layer.getColor()));
        }
        if (layers.isEmpty()) {
            if (Const.Materials.EXAMPLE.isPresent()) {
                this.buildFakeModel(spriteGetter, (ImmutableList.Builder<BakedQuad>)builder, rotation, Const.Materials.EXAMPLE.get());
            } else {
                TextureAtlasSprite texture = spriteGetter.apply(new Material(PlayerContainer.field_226615_c_, (ResourceLocation)SilentGear.getId("item/error")));
                builder.addAll(CompoundPartModel.getQuadsForSprite(0, texture, rotation, 0xFFFFFF));
            }
        }
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        return new BakedPerspectiveModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)transforms, overrideList, rotation.isIdentity(), owner.isSideLit(), this.getCameraTransforms(transformVariant));
    }

    private void buildFakeModel(Function<Material, TextureAtlasSprite> spriteGetter, ImmutableList.Builder<BakedQuad> builder, TransformationMatrix rotation, IMaterial material) {
        MaterialLayer exampleMain;
        IMaterialDisplay model = MaterialDisplayManager.get(material);
        if (model != null && (exampleMain = model.getLayers(this.gearType, this.partType).getFirstLayer()) != null) {
            builder.addAll(CompoundPartModel.getQuadsForSprite(0, spriteGetter.apply(new Material(PlayerContainer.field_226615_c_, exampleMain.getTexture(this.gearType, 0))), rotation, exampleMain.getColor()));
        }
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> ret = new HashSet<Material>();
        if (this.gearType == GearType.ARMOR || this.gearType == GearType.SHIELD) {
            return ret;
        }
        ret.add(new Material(PlayerContainer.field_226615_c_, (ResourceLocation)SilentGear.getId("item/error")));
        for (PartTextures tex : PartTextures.getTextures(this.gearType)) {
            ret.add(this.getTexture(tex.getTexture()));
        }
        for (IMaterialDisplay materialDisplay : MaterialDisplayManager.getValues()) {
            for (MaterialLayer layer : materialDisplay.getLayers(this.gearType, this.partType)) {
                ret.add(this.getTexture(layer));
            }
        }
        return ret;
    }

    private Material getTexture(MaterialLayer layer) {
        return CompoundPartModel.getMaterial(layer.getTexture(this.gearType, 0));
    }

    private Material getTexture(ResourceLocation tex) {
        String path = "item/" + this.gearType.getName() + "/" + tex.func_110623_a();
        ResourceLocation location = new ResourceLocation(tex.func_110624_b(), path);
        return CompoundPartModel.getMaterial(location);
    }

    private static Material getMaterial(ResourceLocation tex) {
        return new Material(PlayerContainer.field_226615_c_, tex);
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return Collections.emptyList();
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }

    private ItemCameraTransforms getCameraTransforms(String transformVariant) {
        return this.cameraTransforms;
    }
}

