/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.client.material.PartGearKey;

public final class MaterialDisplay
implements IMaterialDisplay {
    private final Map<PartGearKey, MaterialLayerList> map = new LinkedHashMap<PartGearKey, MaterialLayerList>();
    private final ResourceLocation modelId;

    private MaterialDisplay(ResourceLocation modelId) {
        this.modelId = modelId;
    }

    public static MaterialDisplay of(Map<PartGearKey, MaterialLayerList> display) {
        MaterialDisplay model = new MaterialDisplay(new ResourceLocation("null"));
        model.map.putAll(display);
        return model;
    }

    @Override
    public IMaterialLayerList getLayers(GearType gearType, PartType partType) {
        return this.map.getOrDefault(this.getMostSpecificKey(gearType, partType), MaterialLayerList.DEFAULT);
    }

    private PartGearKey getMostSpecificKey(GearType gearType, PartType partType) {
        PartGearKey key = PartGearKey.of(gearType, partType);
        if (this.map.containsKey(key)) {
            return key;
        }
        for (PartGearKey parent = key.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.map.containsKey(parent)) continue;
            return parent;
        }
        return key;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        this.map.forEach((key, layerList) -> json.add(key.toString(), layerList.serialize()));
        return json;
    }

    public static MaterialDisplay deserialize(ResourceLocation modelId, JsonObject json) {
        MaterialDisplay ret = new MaterialDisplay(modelId);
        json.entrySet().forEach(entry -> {
            PartGearKey key = PartGearKey.read((String)entry.getKey());
            JsonElement value = (JsonElement)entry.getValue();
            ret.map.put(key, MaterialLayerList.deserialize(value, MaterialLayerList.DEFAULT));
        });
        return ret;
    }

    public String toString() {
        return "MaterialDisplay{modelId=" + this.modelId + '}';
    }
}

