/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.silentchaos512.gear.block.craftingstation.CraftingStationContainer;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingStationTileEntity
extends LockableSidedInventoryTileEntity {
    public static final int CRAFTING_GRID_SIZE = 9;
    public static final int SIDE_INVENTORY_SIZE = 18;
    public static final int CRAFTING_GRID_START = 0;
    public static final int SIDE_INVENTORY_START = 9;

    public CraftingStationTileEntity() {
        super((TileEntityType)ModTileEntities.CRAFTING_STATION.get(), 27);
    }

    public NonNullList<Pair<ItemStack, IInventory>> getAdjacentInventories() {
        NonNullList list = NonNullList.func_191196_a();
        if (this.field_145850_b == null) {
            return list;
        }
        for (Direction side : Arrays.asList(null, Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST)) {
            BlockPos pos = side == null ? this.field_174879_c : this.field_174879_c.func_177972_a(side);
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (!(te instanceof IInventory)) continue;
            BlockState state = this.field_145850_b.func_180495_p(pos);
            BlockRayTraceResult raytrace = new BlockRayTraceResult(new Vec3d(0.0, 0.0, 0.0), side, pos, false);
            ItemStack stack = state.func_177230_c().getPickBlock(state, (RayTraceResult)raytrace, (IBlockReader)this.field_145850_b, pos, null);
            list.add((Object)new ImmutablePair((Object)stack, (Object)((IInventory)te)));
        }
        return list;
    }

    public IInventory getInternalStorage() {
        return this;
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        return false;
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sendUpdate();
    }

    private void sendUpdate() {
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public int[] func_180463_a(Direction direction) {
        return new int[0];
    }

    public boolean func_180462_a(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean func_180461_b(int i, ItemStack itemStack, Direction direction) {
        return false;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.silentgear.crafting_station", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new CraftingStationContainer(id, playerInventory, this);
    }
}

