/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gear.block.craftingstation.CraftingStationInventory;
import net.silentchaos512.gear.block.craftingstation.CraftingStationTileEntity;
import net.silentchaos512.gear.init.ModContainers;

public class CraftingStationContainer
extends RecipeBookContainer<CraftingStationInventory> {
    CraftingStationInventory craftMatrix;
    CraftResultInventory craftResult;
    private final CraftingStationTileEntity tileEntity;
    private final PlayerEntity player;
    private Slot outputSlot;

    public CraftingStationContainer(int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(id, playerInventory, new CraftingStationTileEntity());
    }

    public CraftingStationContainer(int id, PlayerInventory playerInventory, CraftingStationTileEntity tileEntityIn) {
        super((ContainerType)ModContainers.CRAFTING_STATION.get(), id);
        this.player = playerInventory.field_70458_d;
        this.tileEntity = tileEntityIn;
        this.craftResult = new CraftResultInventory(){

            public void func_70296_d() {
                CraftingStationContainer.this.tileEntity.func_70296_d();
            }
        };
        this.craftMatrix = new CraftingStationInventory(this, this.tileEntity);
        this.craftMatrix.func_174889_b(this.player);
        this.setupInventorySlots(playerInventory, (IInventory)this.tileEntity);
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    private void setupInventorySlots(PlayerInventory playerInv, IInventory extendedInv) {
        this.field_75151_b.clear();
        this.setupCraftingGrid();
        this.setupSideInventory();
        this.setupPlayerSlots(playerInv);
        this.outputSlot = this.func_75146_a((Slot)new CraftingResultSlot(playerInv.field_70458_d, (CraftingInventory)this.craftMatrix, (IInventory)this.craftResult, this.tileEntity.func_70302_i_(), 124, 35));
        this.func_75130_a((IInventory)this.tileEntity);
    }

    private void setupCraftingGrid() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = x + y * 3;
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, index, 30 + x * 18, 17 + y * 18));
            }
        }
    }

    private void setupPlayerSlots(PlayerInventory playerInventory) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = x + (y + 1) * 9;
                this.func_75146_a(new Slot((IInventory)playerInventory, index, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 142));
        }
    }

    private void setupSideInventory() {
        int rowCount = (int)Math.ceil(6.0);
        int totalHeight = 44 + 18 * (rowCount - 2);
        for (int y = 0; y < rowCount; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 9 + x + y * 3;
                int xPos = x * 18 - 56;
                int yPos = y * 18 + 5 + (166 - totalHeight) / 2;
                this.func_75146_a(new Slot((IInventory)this.tileEntity, index, xPos, yPos));
            }
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        IWorldPosCallable.func_221488_a((World)this.player.field_70170_p, (BlockPos)this.player.func_180425_c()).func_221486_a((world, pos) -> {
            if (!world.field_72995_K) {
                ICraftingRecipe recipe;
                ServerPlayerEntity playerMP = (ServerPlayerEntity)this.player;
                ItemStack stack = ItemStack.field_190927_a;
                Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, world);
                if (optional.isPresent() && this.craftResult.func_201561_a(world, playerMP, (IRecipe)(recipe = (ICraftingRecipe)optional.get()))) {
                    stack = recipe.func_77572_b((IInventory)this.craftMatrix);
                }
                this.craftResult.func_70299_a(this.outputSlot.field_75222_d, stack);
                playerMP.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, this.outputSlot.field_75222_d, stack));
            }
        });
    }

    public void func_201771_a(RecipeItemHelper itemHelperIn) {
        this.craftMatrix.func_194018_a(itemHelperIn);
    }

    public void func_201768_e() {
        this.craftMatrix.func_174888_l();
        this.craftResult.func_174888_l();
    }

    public boolean func_201769_a(IRecipe<? super CraftingStationInventory> recipe) {
        return recipe.func_77569_a((IInventory)this.craftMatrix, this.player.field_70170_p);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.tileEntity.func_70299_a(i + 0, stack);
        }
        this.tileEntity.func_70296_d();
    }

    public int func_201767_f() {
        return this.outputSlot.field_75222_d;
    }

    public int func_201770_g() {
        return 3;
    }

    public int func_201772_h() {
        return 3;
    }

    public int func_203721_h() {
        return this.tileEntity.func_70302_i_() + 1;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.tileEntity.func_70300_a(playerIn);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int playerStart = this.tileEntity.func_70302_i_();
            int hotbarStart = playerStart + 27;
            if (slot == this.outputSlot) {
                itemstack1.func_77973_b().func_77622_d(itemstack1, this.player.field_70170_p, playerIn);
                if (!this.func_75135_a(itemstack1, playerStart, playerStart + 36, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= playerStart && index < hotbarStart ? !this.func_75135_a(itemstack1, 9, 27, false) && !this.func_75135_a(itemstack1, hotbarStart, hotbarStart + 9, false) : (index >= hotbarStart && index < hotbarStart + 9 ? !this.func_75135_a(itemstack1, 9, 27, false) && !this.func_75135_a(itemstack1, playerStart, playerStart + 27, false) : !this.func_75135_a(itemstack1, playerStart, playerStart + 36, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }
}

