/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitInstance;
import net.silentchaos512.gear.api.traits.LazyTraitInstance;
import net.silentchaos512.gear.util.DataResource;

public class TraitInstance
implements ITraitInstance {
    private final ITrait trait;
    private final int level;
    private final ImmutableList<ITraitCondition> conditions;

    private TraitInstance(ITrait trait, int level, ITraitCondition ... conditions) {
        this.trait = trait;
        this.level = level;
        this.conditions = ImmutableList.builder().add((Object[])conditions).build();
    }

    public static ITraitInstance of(DataResource<ITrait> trait, int level, ITraitCondition ... conditions) {
        if (trait.isPresent()) {
            return TraitInstance.of(trait.get(), level, conditions);
        }
        return TraitInstance.lazy(trait.getId(), level, conditions);
    }

    public static TraitInstance of(ITrait trait, int level, ITraitCondition ... conditions) {
        return new TraitInstance(trait, level, conditions);
    }

    public static LazyTraitInstance lazy(ResourceLocation traitId, int level, ITraitCondition ... conditions) {
        return new LazyTraitInstance(traitId, level, conditions);
    }

    @Override
    public ResourceLocation getTraitId() {
        return this.trait.getId();
    }

    @Override
    @Nonnull
    public ITrait getTrait() {
        return this.trait;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public Collection<ITraitCondition> getConditions() {
        return this.conditions;
    }
}

